/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.dc.provisional.cmdbf.exception.CMDBfException;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.XMLRepository;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLTreeOutputter
extends AbstractOutputter {
    public static final String XMLXTREAM = "org.eclipse.cosmos.dr.drs.service.handler.xml.XMLStream";
    protected String rootId;
    private static ILogger logger = LoggerWrapper.getLogger(XMLTreeOutputter.class);

    public void render(PrintWriter output, IParameters input) throws Exception {
        XMLRepository repository = (XMLRepository)this.context.getStore().getAttribute("org.eclipse.cosmos.dr.drs.service.handler.xml.XMLRepository");
        if (repository == null) {
            throw new CMDBfException(Messages.getString((String)"XMLTreeOutputter.XML_RENDER_ERR"));
        }
        InputStream istream = repository.getXMLStream((Object)input.getParameter("id"));
        if (istream != null) {
            InputSource is = new InputSource(istream);
            this.render(output, is);
        }
    }

    protected Object getId(Object value) {
        return this.idResolver.getId(value);
    }

    protected void render(PrintWriter pw, InputSource input) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document d = builder.parse(input);
            StringBuffer buffer = new StringBuffer("{ identifier: \"object\",  label: \"title\",  items:[");
            buffer.append(this.renderElement(d.getDocumentElement(), true, this.getId((Object)d.getDocumentElement())));
            buffer.append("]}");
            pw.println(buffer.toString());
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
        }
        catch (SAXException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    protected StringBuffer renderElement(Element elem, boolean rootElement, Object id) {
        NodeList children = elem.getChildNodes();
        StringBuffer buffer = new StringBuffer();
        StringBuffer childBuffer = new StringBuffer();
        String childrenStr = "";
        StringBuffer textContent = null;
        int count = 0;
        for (int x = 0; x < children.getLength(); ++x) {
            Node node = children.item(x);
            if (node.getNodeType() == 1) {
                Object nodeId = this.getId((Object)node);
                childBuffer.append(this.renderElement((Element)node, false, nodeId));
                if (childrenStr == "") {
                    childrenStr = childrenStr + "[";
                }
                if (count > 0) {
                    childrenStr = childrenStr + ",";
                }
                childrenStr = childrenStr + "{_reference:\"" + nodeId + "\"}";
                ++count;
            }
            if (node.getNodeType() != 3) continue;
            String nodeValue = node.getNodeValue();
        }
        if (!rootElement) {
            buffer.append(",{title:\"" + elem.getNodeName() + "\",nodeClass:\"element\",object:\"" + id + "\"");
        } else {
            buffer.append("{title:\"" + elem.getNodeName() + "\",nodeClass:\"rootElement\",object:\"" + id + "\"");
        }
        buffer.append(", store:[");
        buffer.append("['nodeName', '").append(elem.getNodeName()).append("']");
        buffer.append(",['prefix', '").append(elem.getPrefix()).append("']");
        buffer.append(",['namespaceURI', '").append(elem.getNamespaceURI()).append("']");
        buffer.append(",['baseURI', '").append(elem.getBaseURI()).append("']");
        buffer.append(",['localName', '").append(elem.getLocalName()).append("']");
        NamedNodeMap attributes = elem.getAttributes();
        if (attributes.getLength() > 0) {
            buffer.append(",");
            for (int x = 0; x < attributes.getLength(); ++x) {
                Node attribute = attributes.item(x);
                if (x > 0) {
                    buffer.append(",");
                }
                buffer.append("['" + attribute.getNodeName() + "','").append(attribute.getNodeValue()).append("']");
            }
        }
        if (textContent != null) {
            buffer.append(",");
            buffer.append("['text content', '").append(textContent).append("']");
        }
        buffer.append("]");
        if (childrenStr != "") {
            childrenStr = childrenStr + "]";
            buffer.append(", children:").append(childrenStr);
            buffer.append("}");
            buffer.append(childBuffer);
        } else {
            buffer.append("}");
        }
        return buffer;
    }

    public static final void main(String[] argv) throws Exception {
    }
}

