/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf;

import java.io.PrintWriter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf.AbstractFormatter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf.IFormatter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLtoNodeListFormatter
extends AbstractFormatter
implements IFormatter {
    public void render(PrintWriter output, IParameters input, Element graphResponse) throws Exception {
        StringBuffer buffer = new StringBuffer("{ identifier: \"object\",  label: \"title\",  items:[");
        buffer.append(this.renderElement(graphResponse, true, this.getId((Object)graphResponse)));
        buffer.append("]}");
        output.println(buffer.toString());
    }

    protected Object getId(Object value) {
        return this.idResolver.getId(value);
    }

    protected StringBuffer renderElement(Element elem, boolean rootElement, Object id) {
        NodeList children = elem.getChildNodes();
        StringBuffer buffer = new StringBuffer();
        StringBuffer childBuffer = new StringBuffer();
        String childrenStr = "";
        StringBuffer textContent = null;
        int count = 0;
        for (int x = 0; x < children.getLength(); ++x) {
            Node node = children.item(x);
            if (node.getNodeType() == 1) {
                Object nodeId = this.getId((Object)node);
                childBuffer.append(this.renderElement((Element)node, false, nodeId));
                if (childrenStr == "") {
                    childrenStr = childrenStr + "[";
                }
                if (count > 0) {
                    childrenStr = childrenStr + ",";
                }
                childrenStr = childrenStr + "{_reference:\"" + nodeId + "\"}";
                ++count;
            }
            if (node.getNodeType() != 3) continue;
            String nodeValue = node.getNodeValue();
        }
        if (!rootElement) {
            buffer.append(",{title:\"" + elem.getNodeName() + "\",nodeClass:\"element\",object:\"" + id + "\"");
        } else {
            buffer.append("{title:\"" + elem.getNodeName() + "\",nodeClass:\"rootElement\",object:\"" + id + "\"");
        }
        buffer.append(", store:\"[");
        buffer.append("{name:'node', properties:[");
        buffer.append("{name:'nodeName', value:'").append(elem.getNodeName()).append("'}");
        buffer.append(",{name:'prefix', value:'").append(elem.getPrefix()).append("'}");
        buffer.append(",{name:'namespaceURI', value:'").append(elem.getNamespaceURI()).append("'}");
        buffer.append(",{name:'baseURI', value:'").append(elem.getBaseURI()).append("'}");
        buffer.append(",{name:'localName', value:'").append(elem.getLocalName()).append("'}");
        NamedNodeMap attributes = elem.getAttributes();
        if (attributes.getLength() > 0) {
            buffer.append("]},");
            buffer.append("{name:'attributes', properties:[");
            for (int x = 0; x < attributes.getLength(); ++x) {
                Node attribute = attributes.item(x);
                if (x > 0) {
                    buffer.append(",");
                }
                buffer.append("{name:'" + attribute.getNodeName() + "', value:'").append(attribute.getNodeValue()).append("'}");
            }
        }
        if (textContent != null) {
            buffer.append("]},");
            buffer.append("{name:'text content', properties:[");
            buffer.append("{name:'content', value:'").append(textContent).append("'}");
        }
        buffer.append("]}]\"");
        if (childrenStr != "") {
            childrenStr = childrenStr + "]";
            buffer.append(", children:").append(childrenStr);
            buffer.append("}");
            buffer.append(childBuffer);
        } else {
            buffer.append("}");
        }
        return buffer;
    }
}

