/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.provisional.dr.ps.common;

import java.util.Locale;
import org.eclipse.cosmos.internal.dr.ps.common.Configuration;

public class Template {
    public static final String NAMESPACE_QUERY = "http://cmdbf.org/schema/1-0-0/query";
    protected String page;
    protected String debugContainer;
    protected String dojoPath;
    protected String dojoBaseUrl;
    protected String cosmosBaseURL;
    protected String serviceBaseURL = "";
    protected Locale locale;

    public void initialize(Configuration configuration) throws Exception {
        this.dojoPath = configuration.getValue((Object)"DOJO_PATH");
        this.dojoBaseUrl = configuration.getValue((Object)"DOJO_BASE_URL");
        this.cosmosBaseURL = configuration.getValue((Object)"COSMOS_BASE_URL");
        this.serviceBaseURL = configuration.getValue((Object)"COSMOS_SERVICE_BASE_URL");
        this.page = configuration.getValue((Object)"DEFAULT_PAGE_TEMPLATE");
    }

    public void setDojoBaseURL(String dojoBaseUrl) {
        this.dojoBaseUrl = dojoBaseUrl;
    }

    public String getDojoBaseUrl() {
        return this.dojoBaseUrl;
    }

    public void setDojoPath(String dojoPath) {
        this.dojoPath = dojoPath;
    }

    public String getServiceBaseURL() {
        return this.serviceBaseURL;
    }

    public void setServiceBaseURL(String serviceBaseURL) {
        this.serviceBaseURL = serviceBaseURL;
    }

    public String header() {
        if (this.cosmosBaseURL == null) {
            this.cosmosBaseURL = "js/org/eclipse/cosmos";
        }
        if (this.serviceBaseURL == null) {
            this.serviceBaseURL = "";
        }
        StringBuffer out = new StringBuffer();
        out.append("<script type=\"text/javascript\">").append("djConfig= {isDebug:").append(this.debugContainer != null ? "true" : "false").append(",").append("locale: \"" + this.locale.getLanguage().replace('_', '-') + "\",").append("useXDomain: true,").append("baseUrl: \"./\",").append("cosmosWidgetService: \"" + this.serviceBaseURL + "json?service=org/eclipse/cosmos/internal/dr/drs/service/outputter/widget/WidgetProperties\",").append("parseOnLoad: true,").append("xdWaitSeconds: 5 };").append("</script>\n");
        out.append("<script type=\"text/javascript\" src=\"" + this.dojoPath + "\"></script>\n");
        out.append("<script>").append("dojo.registerModulePath(\"dojo\",\"" + this.dojoBaseUrl + "/dojo\");").append("dojo.registerModulePath(\"dojox\",\"" + this.dojoBaseUrl + "/dojox\");").append("dojo.registerModulePath(\"dijit\",\"" + this.dojoBaseUrl + "/dijit\");").append("dojo.registerModulePath(\"org.eclipse.cosmos\",\"" + this.cosmosBaseURL + "\");").append("dojo.registerModulePath(\"nls.org.eclipse.cosmos\",\"" + this.cosmosBaseURL + "/../../../nls/org/eclipse/cosmos\");").append("dojo.require(\"dijit.dijit\");").append("dojo.require(\"org.eclipse.cosmos.provisional.dr.ps.components.widget.common\");").append("dojo.require(\"org.eclipse.cosmos.provisional.dr.ps.components.utility.common\");").append("dojo.require(\"dojo.parser\");").append("</script>");
        return out.toString();
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getPage() {
        return "pages/" + this.page;
    }

    public void setDebug(String debug) {
        this.debugContainer = debug;
    }

    public String getDebug() {
        return this.debugContainer;
    }

    public String getCosmosBaseURL() {
        return this.cosmosBaseURL;
    }

    public void setCosmosBaseURL(String cosmosBaseURL) {
        this.cosmosBaseURL = cosmosBaseURL;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

