package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.BoundaryType;

public class BoundaryCompare
{

	protected static Vector<BoundaryType> merge(List<BoundaryType> bounds, List<BoundaryType> bounds2)
	{
		Vector <BoundaryType> toRemove = new Vector <BoundaryType> ();
		Iterator <BoundaryType> iter1 = bounds.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			BoundaryType o1 = (BoundaryType) iter1.next();
			Iterator <BoundaryType> iter2 = bounds2.iterator();
			while (iter2.hasNext())
			{
				BoundaryType o2 = (BoundaryType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						//merge hosted resources, types and description groups
						toRemove.add(o2);
					}
				}
					
			}
		}
		
		bounds2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <BoundaryType> finals = new Vector <BoundaryType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(bounds);
		finals.addAll(bounds2);		
		
		return finals;
	}

	protected static boolean equals(BoundaryType o1, BoundaryType o2)
	{
		if (!StringCompare.equals(o1.getLowerBound(),o2.getLowerBound()))
			return false;
		if (!StringCompare.equals(o1.getUpperBound(),o2.getUpperBound()))
			return false;
		return true;
	}

}
