/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.examples.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SDD_DASImpl;
import org.eclipse.cosmos.me.sdd.common.validation.util.ValidatorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SDD_DAS_Sample {
    private static final String FSEP = System.getProperty("file.separator");
    private static final String filesPath = "src" + FSEP + "org" + FSEP + "eclipse" + FSEP + "cosmos" + FSEP + "me" + FSEP + "internal" + FSEP + "deployment" + FSEP + "sdd" + FSEP + "examples" + FSEP + "common" + FSEP + "validation" + FSEP;
    private static final String XML_INPUT_FILE = String.valueOf(filesPath) + "DeploymentDescriptor.xml";
    private static final String XML_OUTPUT_FILE = String.valueOf(filesPath) + "SDD_DAS_Sample-Output.xml";

    public static void main(String[] args) {
        SDD_DAS_Sample.prepFiles();
        SDD_DASImpl deploymentDescriptorDAS = new SDD_DASImpl();
        Document document = null;
        try {
            document = deploymentDescriptorDAS.loadDocument(new FileInputStream(XML_INPUT_FILE));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (XMLValidationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        Element resourceElement = ValidatorUtils.findElement(document, "Resource");
        Element nameElement = ValidatorUtils.findElement(resourceElement, "Name");
        nameElement.setTextContent("Linux");
        Collection<XMLValidationError> validationErrors = deploymentDescriptorDAS.validate(document);
        if (validationErrors.size() > 0) {
            for (XMLValidationError error : validationErrors) {
                System.err.println(error.getErrorMessage());
            }
            System.exit(1);
        }
        try {
            deploymentDescriptorDAS.saveDocument(document, new FileOutputStream(XML_OUTPUT_FILE), null, false);
        }
        catch (XMLValidationException xMLValidationException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void prepFiles() {
        File ddOriginal = new File(String.valueOf(filesPath) + "DeploymentDescriptor.xml_Original");
        try {
            FileChannel ddSrcChannel = new FileInputStream(ddOriginal).getChannel();
            FileChannel ddDestChannel = new FileOutputStream(XML_INPUT_FILE).getChannel();
            ddDestChannel.transferFrom(ddSrcChannel, 0L, ddSrcChannel.size());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

