/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.BoundaryType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.BoundaryCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.OperationCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerParameterCompare {
    protected static Collection<IntegerParameterType> merge(Vector<IntegerParameterType> ints1, Vector<IntegerParameterType> ints2) {
        Vector<IntegerParameterType> paramsToRemove = new Vector<IntegerParameterType>();
        for (IntegerParameterType param1 : ints1) {
            for (IntegerParameterType param2 : ints2) {
                if (paramsToRemove.contains(param2) || !IntegerParameterCompare.equals(param1, param2)) continue;
                paramsToRemove.add(param2);
                Vector<BoundaryType> bounds = BoundaryCompare.merge(param1.getBounds(), param2.getBounds());
                param1.getBounds().clear();
                param1.getBounds().addAll(bounds);
            }
        }
        ints2.removeAll(paramsToRemove);
        Vector<IntegerParameterType> finalParams = new Vector<IntegerParameterType>();
        finalParams.addAll(ints1);
        finalParams.addAll(ints2);
        return finalParams;
    }

    protected static boolean equals(IntegerParameterType int1, IntegerParameterType int2) {
        if (!StringCompare.equals(int1.getDefaultValue(), int2.getDefaultValue())) {
            return false;
        }
        if (int1.isSensitive() != int2.isSensitive()) {
            return false;
        }
        if (int1.isRequired() != int2.isRequired()) {
            return false;
        }
        return !OperationCompare.equals(int1.getOperation(), int2.getOperation());
    }
}

