/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchematronRule;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementSchematronCacheBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder";
    private RuleBindings dataStructure;
    protected StringBuffer buffer;
    protected String name;
    protected String type;
    protected String targetNamespace;
    protected Map schemaAttributes;
    protected boolean schematronFound = false;
    protected Map prefixLookup;
    protected List ruleContexts;
    protected Map ruleBinding = new HashMap();
    protected boolean aliasFound = false;
    protected boolean aliasesFound = false;
    protected List aliases;
    protected boolean phenic = false;

    public ElementSchematronCacheBuilder() {
        this.dataStructure = new RuleBindings();
        this.ruleContexts = new ArrayList();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("phenics".equals(localName)) {
            this.phenic = false;
            return;
        }
        if (this.buffer != null) {
            SMLValidatorUtil.addElement(this.buffer, 0, qName, true, true);
            if (this.schematronFound && "schema".equals(localName) && "http://purl.oclc.org/dsdl/schematron".equals(uri)) {
                SchematronRule schematronRule = new SchematronRule(this.buffer, this.ruleContexts, this.prefixLookup);
                if (this.name != null) {
                    this.dataStructure.bindRule(this.targetNamespace, this.name, schematronRule);
                } else if (this.type != null) {
                    this.dataStructure.bindRule(this.targetNamespace, String.valueOf(this.type) + "$typeDelim", schematronRule);
                } else if (this.aliases != null && this.ruleBinding.size() > 0) {
                    for (Object docAlias : this.ruleBinding.keySet()) {
                        Object ruleAlias = this.ruleBinding.get(docAlias);
                        if (!this.aliases.contains(ruleAlias)) continue;
                        this.dataStructure.bindRule((String)docAlias, schematronRule);
                    }
                } else if (this.targetNamespace == null && this.ruleBinding.size() <= 0) {
                    this.dataStructure.addUnboundRule(schematronRule);
                }
                this.targetNamespace = null;
                this.prefixLookup = new HashMap();
                this.buffer = null;
                this.ruleContexts.clear();
                this.name = null;
                this.schematronFound = false;
                this.aliases = null;
            }
        }
        if ("schema".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
            this.schemaAttributes = null;
            this.targetNamespace = null;
        } else if ("aliases".equals(localName) && "http://schemas.serviceml.org/smlif/2006/10".equals(uri)) {
            this.aliasesFound = false;
        } else if (this.aliasFound && "alias".equals(localName) && "http://schemas.serviceml.org/smlif/2006/10".equals(uri)) {
            this.aliasFound = false;
        } else if ("element".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
            this.name = null;
        } else if ("complexType".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
            this.type = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("phenics".equals(localName)) {
            this.phenic = true;
            return;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri)) {
            if ("schema".equals(localName)) {
                this.schematronFound = false;
                this.targetNamespace = attributes.getValue("targetNamespace");
                this.schemaAttributes = new HashMap();
                int x = 0;
                while (x < attributes.getLength()) {
                    String key = attributes.getQName(x);
                    if (key.startsWith("xmlns")) {
                        this.schemaAttributes.put(attributes.getQName(x), attributes.getValue(x));
                    }
                    ++x;
                }
            } else if ("element".equals(localName)) {
                this.name = attributes.getValue("name");
            } else if ("complexType".equals(localName)) {
                this.type = attributes.getValue("name");
            }
        } else if ("http://schemas.serviceml.org/smlif/2006/10".equals(uri)) {
            if ("ruleBinding".equals(localName)) {
                this.ruleBinding.put(attributes.getValue("documentAlias"), attributes.getValue("ruleAlias"));
            } else if ("aliases".equals(localName)) {
                this.aliasesFound = true;
                this.aliases = new ArrayList();
            } else if (this.aliasesFound && "alias".equals(localName)) {
                this.aliasFound = true;
            }
        } else if ("http://purl.oclc.org/dsdl/schematron".equals(uri) && "schema".equals(localName)) {
            this.schematronFound = true;
            this.buffer = new StringBuffer();
        }
        if (this.buffer != null) {
            if (uri.equals("http://purl.oclc.org/dsdl/schematron")) {
                if (localName.equals("rule")) {
                    this.buffer.append("<").append(qName).append(this.printRuleAttributes(attributes)).append(">");
                } else {
                    if (localName.equals("ns")) {
                        if (this.prefixLookup == null) {
                            this.prefixLookup = new HashMap();
                        }
                        this.prefixLookup.put(attributes.getValue("prefix"), attributes.getValue("uri").trim());
                    }
                    this.buffer.append("<").append(qName).append(this.printReplaceSMLFNAttributes(attributes)).append(">");
                }
            } else if ("element".equals(localName) && "http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.buffer.append("<").append(qName).append(this.printSchNamespaceAttributes(attributes)).append(">");
            } else {
                this.buffer.append("<").append(qName).append(this.printAttributes(attributes)).append(">");
            }
        }
    }

    protected StringBuffer printRuleAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            String attributeValue = attributes.getValue(x);
            if (attributes.getLocalName(x).equals("context")) {
                if (attributeValue.startsWith(".")) {
                    attributeValue = attributeValue.substring(1);
                }
                this.ruleContexts.add(attributeValue);
                if (attributeValue.startsWith("/")) {
                    buffer.append(" ").append(attributes.getQName(x)).append("=\"").append(attributeValue).append("\"");
                    return buffer;
                }
            }
            buffer.append(" ").append(attributes.getQName(x)).append("=\"").append("$contextParam").append("\"");
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printReplaceSMLFNAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            if (attributes.getLocalName(x).equals("uri") && (attributes.getValue(x).equals("http://schemas.serviceml.org/sml/function/2006/07") || attributes.getValue(x).equals("http://schemas.serviceml.org/smlfn/query/2006/07"))) {
                buffer.append(" ").append(attributes.getQName(x)).append("=\"").append("org.eclipse.cosmos.rm.validation.internal.reference.SMLExtensionFunctions").append("\"");
            } else {
                buffer.append(" ").append(attributes.getQName(x)).append("=\"").append(attributes.getValue(x)).append("\"");
            }
            ++x;
        }
        return buffer;
    }

    protected StringBuffer printSchNamespaceAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=\"").append(attributes.getValue(x)).append("\"");
            this.schemaAttributes.remove(attributes.getQName(x));
            ++x;
        }
        for (Object key : this.schemaAttributes.keySet()) {
            buffer.append(" ").append(key).append("=\"").append(this.schemaAttributes.get(key)).append("\"");
        }
        return buffer;
    }

    protected StringBuffer printAttributes(Attributes attributes) {
        StringBuffer buffer = new StringBuffer();
        int x = 0;
        while (x < attributes.getLength()) {
            buffer.append(" ").append(attributes.getQName(x)).append("=\"").append(attributes.getValue(x)).append("\"");
            ++x;
        }
        return buffer;
    }

    public Object getDataStructure() {
        return this.dataStructure;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.phenic) {
            return;
        }
        if (this.buffer != null) {
            this.buffer.append(new String(ch, start, length));
        }
        if (this.aliasFound) {
            this.aliases.add(new String(ch, start, length));
        }
    }

    public byte getPhase() {
        return 3;
    }

    public static class RuleBindings {
        private static final String UNTARGETED = "untargeted";
        private static final String UNBOUND_RULES = "unboundRules";
        protected Map data = new HashMap();
        private List unboundRules;

        public void bindRule(String alias, SchematronRule schematronRule) {
            this.bindRule(UNTARGETED, alias, schematronRule);
        }

        public void bindRule(String uri, String localName, SchematronRule schematronRule) {
            HashMap<String, SchematronRule> schematronRules = null;
            schematronRules = (HashMap<String, SchematronRule>)this.data.get(uri);
            if (schematronRules == null) {
                schematronRules = new HashMap<String, SchematronRule>();
                this.data.put(uri, schematronRules);
            }
            schematronRules.put(localName, schematronRule);
        }

        public void addUnboundRule(SchematronRule schematronRule) {
            if (this.unboundRules == null) {
                this.unboundRules = new ArrayList();
            }
            this.unboundRules.add(schematronRule);
        }

        public SchematronRule getBoundRule(String alias) {
            return this.getBoundRule(UNTARGETED, alias);
        }

        public SchematronRule getBoundRule(String uri, String localName) {
            Map schematronRules = (Map)this.data.get(uri);
            if (schematronRules == null) {
                return null;
            }
            return (SchematronRule)schematronRules.get(localName);
        }

        public List getUnboundedRules() {
            return this.unboundRules;
        }

        public boolean isRuleBindingPresent() {
            return this.unboundRules == null || this.unboundRules.size() <= 0;
        }
    }
}

