/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetSchemaNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TargetSchemaBuilder
extends AbstractDataBuilder
implements IDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TargetSchemaBuilder";
    protected Map dataStructure = new HashMap();
    protected boolean uriElementFound = false;

    public Object getDataStructure() {
        return this.dataStructure;
    }

    public void startSchema(String uri) {
    }

    public void endSchema(String uri) {
        Map substitionMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        IDataBuilder refTypeElement = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.RefTypeElementBuilder");
        IDataBuilder elementTypeMapBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        ElementTypeMap elementTypeMapBuilderStructure = (ElementTypeMap)elementTypeMapBuilder.getDataStructure();
        IDataBuilder typeInheritance = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        Map refTypeElems = (Map)refTypeElement.getDataStructure();
        Map inheritance = (Map)typeInheritance.getDataStructure();
        for (Object elementName : this.dataStructure.keySet()) {
            if (refTypeElems.containsKey(elementName)) continue;
            String targetRefTypeNS = elementTypeMapBuilderStructure.getType(uri, (String)elementName);
            String targetRefType = ParserHelper.removeNameSpace(targetRefTypeNS);
            Object parent = inheritance.get(targetRefType);
            boolean valid = false;
            while (parent != null) {
                if (refTypeElems.get(parent) != null) {
                    valid = true;
                    break;
                }
                parent = inheritance.get(parent);
            }
            if (valid) continue;
            this.appendToErrorMessage("Target Element does not define sml:refType");
            return;
        }
        for (Object namespaceURI : substitionMap.keySet()) {
            String elementNameNonNS = ParserHelper.removeNameSpace((String)namespaceURI);
            TargetSchemaNode targetSchemaNode = (TargetSchemaNode)this.dataStructure.get(elementNameNonNS);
            if (targetSchemaNode != null) {
                Object substitionName = substitionMap.get(namespaceURI);
                TargetSchemaNode subTargetSchemaNode = (TargetSchemaNode)this.dataStructure.get(substitionName);
                targetSchemaNode.setSubstitutionGroup(subTargetSchemaNode);
                continue;
            }
            Map substitutionMap = (Map)substitionMap.get(namespaceURI);
            for (String elementName : substitutionMap.keySet()) {
                String substitutedElement = (String)substitutionMap.get(elementName);
                substitutedElement = substitutedElement == null ? null : ParserHelper.removeNameSpace(substitutedElement);
                TargetSchemaNode subTargetSchemaNode = (TargetSchemaNode)this.dataStructure.get(substitutedElement);
                if (subTargetSchemaNode == null) continue;
                this.dataStructure.put(elementNameNonNS, subTargetSchemaNode);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("schema".equals(localName)) {
            this.startSchema(uri);
        } else if ("element".endsWith(localName)) {
            String elementName = attributes.getValue("name");
            String targetElement = attributes.getValue("http://schemas.serviceml.org/sml/2006/10", "targetElement");
            String targetType = attributes.getValue("http://schemas.serviceml.org/sml/2006/10", "targetType");
            String targetRequired = attributes.getValue("http://schemas.serviceml.org/sml/2006/10", "targetRequired");
            if (targetElement != null || targetType != null || targetRequired != null) {
                TargetSchemaNode schemaNode = new TargetSchemaNode(elementName, this.locator == null ? -1 : this.locator.getLineNumber(), this.locator == null ? -1 : this.locator.getColumnNumber());
                schemaNode.setTargetElement(targetElement);
                schemaNode.setTargetType(targetType);
                schemaNode.setRequired(targetRequired);
                this.dataStructure.put(elementName, schemaNode);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("schema".equals(localName)) {
            this.endSchema(uri);
        }
    }

    public byte getPhase() {
        return 1;
    }
}

