/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.ValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TypeInheritanceDataBuilderImpl
extends AbstractDataBuilder
implements IDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl";
    private Map inheritanceMap = new HashMap();
    private TypeNode currentComplexType;
    private Map attributes = new Hashtable();

    public Object getDataStructure() {
        return this.inheritanceMap;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "complexType".equals(localName)) {
            String complexTypeName = attributes.getValue("name");
            if (complexTypeName != null && attributes != null) {
                String targetNameSpace;
                Hashtable<String, String> complexTypeAtts = new Hashtable<String, String>();
                String acyclic = attributes.getValue("http://schemas.serviceml.org/sml/2006/10", "acyclic");
                if (acyclic != null) {
                    complexTypeAtts.put("acyclic", acyclic);
                }
                this.currentComplexType = new TypeNode(complexTypeName, (targetNameSpace = this.getTargetNamespace()) == null ? "" : targetNameSpace);
                Map typesPerUri = SMLValidatorUtil.retrieveNestedMap(this.attributes, this.currentComplexType.getUri(), true);
                typesPerUri.put(this.currentComplexType.getType(), complexTypeAtts);
            }
        } else if (this.currentComplexType != null && "extension".equals(localName)) {
            String name = attributes.getValue("base");
            String[] tokens = this.tokenizeName(name);
            String parentURI = "";
            if (tokens[0] != null) {
                parentURI = (String)this.getPrefixMap().get(tokens[0]);
            }
            TypeNode parent = new TypeNode(tokens[1], parentURI);
            this.validateRelationship(parent, this.currentComplexType);
            Map namesPerUri = SMLValidatorUtil.retrieveNestedMap(this.inheritanceMap, this.currentComplexType.getUri(), true);
            namesPerUri.put(this.currentComplexType.getType(), parent);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "complexType".equals(localName)) {
            this.currentComplexType = null;
        }
    }

    public static boolean isDerivedType(Map inheritanceMap, TypeNode refType, TypeNode refTypeInQuestion) {
        if (refType.equals(refTypeInQuestion)) {
            return true;
        }
        TypeNode currentType = refTypeInQuestion;
        while (currentType != null) {
            Map namePerUri = (Map)inheritanceMap.get(currentType.getUri());
            TypeNode typeNode = currentType = namePerUri == null ? null : (TypeNode)namePerUri.get(currentType.getType());
            if (!refType.equals(currentType)) continue;
            return true;
        }
        return false;
    }

    public byte getPhase() {
        return 1;
    }

    private void validateRelationship(TypeNode baseType, TypeNode complexType) {
        if (this.isTypeAcyclic(baseType, false) && !this.isTypeAcyclic(complexType, true)) {
            this.setStructureValidity(false);
            this.appendToErrorMessage(NLS.bind((String)ValidationMessages.acyclicBadDerivation, (Object[])new String[]{baseType.getType(), complexType.getType()}));
        }
    }

    private boolean isTypeAcyclic(TypeNode complexType, boolean defaultValue) {
        String acyclicValue;
        Map typeAttributes;
        if (complexType.getUri() == null || complexType.getType() == null) {
            return false;
        }
        Map namesPerUri = (Map)this.attributes.get(complexType.getUri());
        Map map = typeAttributes = namesPerUri == null ? null : (Map)namesPerUri.get(complexType.getType());
        if (typeAttributes != null && (acyclicValue = (String)typeAttributes.get("acyclic")) != null) {
            return "true".equalsIgnoreCase(acyclicValue);
        }
        return defaultValue;
    }

    public static TypeNode retrieveType(Map inheritance, String uri, String localName) {
        Map typesPerUri = (Map)inheritance.get(uri);
        return typesPerUri == null ? null : (TypeNode)typesPerUri.get(localName);
    }
}

