/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.reference.BadContextException;
import org.eclipse.cosmos.rm.validation.internal.reference.BadExpressionException;
import org.eclipse.cosmos.rm.validation.internal.reference.URIReference;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointer;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerExpression;
import org.eclipse.cosmos.rm.validation.internal.reference.XPointerSyntaxException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DerefXPathFunction
implements XPathFunction {
    public static final int ARITY = 1;
    private static DerefXPathFunction instance;

    public Object evaluate(List arguments) throws XPathFunctionException {
        Map refTypeElements = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.RefTypeElementBuilder");
        Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        IdentityDataBuilder.SMLIFIdentity identity = (IdentityDataBuilder.SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
        Map inheritanceMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        Map map = inheritanceMap = inheritanceMap == null ? new Hashtable() : inheritanceMap;
        if (refTypeElements == null || domDocuments == null || identity == null) {
            throw new XPathFunctionException(SMLMessages.errorMissingStructure);
        }
        NodeList nodeList = (NodeList)arguments.get(0);
        ArrayNodeList result = new ArrayNodeList();
        Exception exception = null;
        int i = 0;
        int nodeCount = nodeList.getLength();
        while (i < nodeCount) {
            block20: {
                Node currentNode = nodeList.item(i);
                String name = currentNode.getLocalName();
                String uri = currentNode.getNamespaceURI();
                String string = uri = uri == null ? "" : uri;
                if (name == null) {
                    throw new XPathFunctionException(SMLMessages.errorDetermineName);
                }
                TypeNode currentTypeNode = new TypeNode(name, uri);
                Map typeMap = null;
                boolean refType = false;
                while (currentTypeNode != null && !refType) {
                    typeMap = (Map)refTypeElements.get(currentTypeNode.getUri());
                    refType = typeMap != null && typeMap.get(currentTypeNode.getType()) != null;
                    currentTypeNode = TypeInheritanceDataBuilderImpl.retrieveType(inheritanceMap, currentTypeNode.getUri(), currentTypeNode.getType());
                }
                if (!refType) {
                    throw new XPathFunctionException(NLS.bind((String)SMLMessages.errorWrongType, (Object)name));
                }
                NodeList currentChildNodes = currentNode.getChildNodes();
                if (nodeList != null) {
                    StringBuffer referenceExpression = new StringBuffer();
                    int j = 0;
                    int childNodeCount = currentChildNodes.getLength();
                    while (j < childNodeCount) {
                        Node currentChildNode = currentChildNodes.item(j);
                        if ("http://schemas.serviceml.org/sml/2006/10".equals(currentChildNode.getNamespaceURI()) && "uri".equals(currentChildNode.getLocalName())) {
                            NodeList uriNodes = currentChildNode.getChildNodes();
                            int k = 0;
                            int uriNodeCount = uriNodes.getLength();
                            while (k < uriNodeCount) {
                                Node uriNode = uriNodes.item(k);
                                if (3 == uriNode.getNodeType() && uriNode.getNodeValue() != null) {
                                    referenceExpression.append(SMLValidatorUtil.removeLineBreaks(uriNode.getNodeValue()));
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    String referenceExp = referenceExpression.toString();
                    if (referenceExp != null) {
                        try {
                            URIReference uriReference = new URIReference(referenceExp);
                            Node context = null;
                            try {
                                context = uriReference.retrieveDocumentDOM();
                            }
                            catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                                break block20;
                            }
                            if (context == null) break block20;
                            String fragmentExpression = uriReference.getFragment();
                            if (fragmentExpression == null) {
                                result.add(context);
                                break block20;
                            }
                            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
                            result.add(xpointerExpression.evaluate(context));
                        }
                        catch (XPointerSyntaxException e) {
                            exception = e;
                        }
                        catch (URISyntaxException e) {
                            exception = e;
                        }
                        catch (BadContextException e) {
                            exception = e;
                        }
                        catch (BadExpressionException e) {
                            exception = e;
                        }
                        if (exception != null) {
                            throw new XPathFunctionException(exception);
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public Object evaluate(String referenceExp) throws XPathFunctionException {
        Node context;
        URIReference uriReference;
        Exception exception;
        block13: {
            Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
            IdentityDataBuilder.SMLIFIdentity identity = (IdentityDataBuilder.SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            if (domDocuments == null || identity == null) {
                throw new XPathFunctionException(SMLMessages.errorMissingStructure);
            }
            exception = null;
            if (referenceExp == null) {
                return null;
            }
            uriReference = new URIReference(referenceExp);
            try {
                context = uriReference.retrieveDocumentDOM();
            }
            catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                return null;
            }
            if (context != null) break block13;
            return null;
        }
        try {
            String fragmentExpression = uriReference.getFragment();
            if (fragmentExpression == null) {
                return context;
            }
            XPointerExpression xpointerExpression = XPointer.compile(fragmentExpression);
            return xpointerExpression.evaluate(context);
        }
        catch (XPointerSyntaxException e) {
            exception = e;
        }
        catch (URISyntaxException e) {
            exception = e;
        }
        catch (BadContextException e) {
            exception = e;
        }
        catch (BadExpressionException e) {
            exception = e;
        }
        if (exception != null) {
            throw new XPathFunctionException(exception);
        }
        return null;
    }

    public static XPathFunction instance() {
        if (instance == null) {
            instance = new DerefXPathFunction();
        }
        return instance;
    }

    private static class ArrayNodeList
    extends ArrayList
    implements NodeList {
        private static final long serialVersionUID = 7992097730072474662L;

        private ArrayNodeList() {
        }

        public int getLength() {
            return super.size();
        }

        public Node item(int index) {
            return (Node)super.get(index);
        }
    }
}

