/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchematronRule;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementSchematronCacheBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementTypeMapDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.NamespaceContextBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.ValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.util.FileHelper;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchematronValidator
extends AbstractSMLValidator {
    protected static final String SKELETON15 = "validation-resources\\skeleton1-5.xsl";
    protected IValidationOutput validationLogger;
    protected ElementTypeMap elementTypeMapBuilderStructure;
    protected ElementSchematronCacheBuilder.RuleBindings schemaCacheBuilderStructure;
    protected Map inheritance;

    public void initialize(Map validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder", new ElementSchematronCacheBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder", new ElementTypeMapDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityDataBuilder", new IdentityDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl", new TypeInheritanceDataBuilderImpl());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.NamespaceContextBuilder", new NamespaceContextBuilder());
    }

    public boolean validate() {
        this.validationLogger = this.getValidationOutput();
        this.inheritance = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        this.elementTypeMapBuilderStructure = (ElementTypeMap)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        this.schemaCacheBuilderStructure = (ElementSchematronCacheBuilder.RuleBindings)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder");
        List docWithNoAlias = (List)domDocuments.get("no_alias");
        for (Object alias : domDocuments.keySet()) {
            Object rootElement = domDocuments.get(alias);
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, alias)) continue;
            return false;
        }
        for (Object rootElement : docWithNoAlias) {
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, null)) continue;
            return false;
        }
        return true;
    }

    protected boolean processNode(Node currentElement, Node rootElement, Object alias) {
        if (currentElement.getNodeType() != 1) {
            return true;
        }
        if (this.schemaCacheBuilderStructure.isRuleBindingPresent()) {
            String nodeNamespace = currentElement.getNamespaceURI();
            SchematronRule schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, currentElement.getLocalName());
            if (alias != null && schematron == null) {
                schematron = this.schemaCacheBuilderStructure.getBoundRule((String)alias);
            }
            String targetType = null;
            if (schematron == null && (targetType = this.elementTypeMapBuilderStructure.getType(currentElement.getNamespaceURI(), currentElement.getLocalName())) != null) {
                schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, targetType + "$typeDelim");
                Map inheritanceMap = null;
                if (schematron == null && (inheritanceMap = (Map)this.inheritance.get(currentElement.getNamespaceURI())) != null) {
                    TypeNode parent = (TypeNode)inheritanceMap.get(targetType);
                    while (parent != null) {
                        schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, String.valueOf(ParserHelper.removeNameSpace(parent.getType())) + "$typeDelim");
                        if (schematron != null) break;
                        parent = (TypeNode)inheritanceMap.get(parent.getType());
                    }
                }
            }
            if (schematron != null && !this.validateSchematron(schematron, currentElement, rootElement)) {
                return false;
            }
        } else {
            List unboundRules = this.schemaCacheBuilderStructure.getUnboundedRules();
            int i = 0;
            int ruleCount = unboundRules.size();
            while (i < ruleCount) {
                if (!this.validateSchematron((SchematronRule)unboundRules.get(i), currentElement, rootElement)) {
                    return false;
                }
                ++i;
            }
        }
        NodeList nodeLists = currentElement.getChildNodes();
        int x = 0;
        while (x < nodeLists.getLength()) {
            Node node = nodeLists.item(x);
            if (node.getNodeType() == 1 && !this.processNode(node, rootElement, null)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean validateSchematron(SchematronRule schematronNode, Node currentElement, Node rootElement) {
        ErrorCaptureStream errorCaptureStream = new ErrorCaptureStream();
        try {
            StringBuffer buffer = schematronNode.getSchematron();
            if (buffer == null) {
                return true;
            }
            String schematronFragment = buffer.toString().replaceAll("\\$contextParam", "/*[1]");
            StringReader sr = new StringReader(schematronFragment);
            DOMResult schematron = new DOMResult();
            this.transform(new StreamSource(sr), new StreamSource(FileHelper.getResourceAsStream(SKELETON15)), schematron, errorCaptureStream);
            List ruleContexts = schematronNode.getRuleContexts();
            final Map prefixMap = schematronNode.getPrefixMap();
            int i = 0;
            int ruleCount = ruleContexts.size();
            while (i < ruleCount) {
                String ruleContext = (String)ruleContexts.get(i);
                if (ruleContext.length() > 0) {
                    NamespaceContext namespaceContext = new NamespaceContext(){

                        public String getNamespaceURI(String prefix) {
                            String uri = (String)prefixMap.get(prefix);
                            return uri == null ? "" : uri;
                        }

                        public String getPrefix(String arg0) {
                            return null;
                        }

                        public Iterator getPrefixes(String arg0) {
                            return null;
                        }
                    };
                    SMLValidatorUtil.xpath.setNamespaceContext(namespaceContext);
                    XPathExpression xpathExp = SMLValidatorUtil.xpath.compile(ruleContext);
                    NodeList nodeList = (NodeList)xpathExp.evaluate(currentElement, XPathConstants.NODESET);
                    if (nodeList != null) {
                        int x = 0;
                        while (x < nodeList.getLength()) {
                            if (!this.applySchematron(errorCaptureStream, nodeList.item(x), schematron.getNode())) {
                                return false;
                            }
                            ++x;
                        }
                    }
                } else if (!this.applySchematron(errorCaptureStream, currentElement, schematron.getNode())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            this.handleError(errorCaptureStream, e.getLocalizedMessage());
            return false;
        }
    }

    private void handleError(ErrorCaptureStream errorCaptureStream, String msg) {
        if (!errorCaptureStream.isEmpty()) {
            String[] lines = errorCaptureStream.getLines();
            int i = 0;
            while (i < lines.length && lines[i] != null) {
                this.validationLogger.reportError(lines[i]);
                ++i;
            }
        }
        this.validationLogger.reportError(msg);
    }

    private boolean applySchematron(ErrorCaptureStream errorCaptureStream, Node currentElement, Node schematron) {
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        DOMSource schematronSource = new DOMSource(schematron);
        try {
            this.transform(this.createStreamSource(currentElement), schematronSource, output, errorCaptureStream);
        }
        catch (Exception e) {
            this.handleError(errorCaptureStream, NLS.bind((String)ValidationMessages.schematronTransformation, (Object)(e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage())));
            return false;
        }
        String result = sw.getBuffer().toString();
        if (result.trim().length() > 0) {
            this.validationLogger.reportError(result);
            return false;
        }
        return true;
    }

    private StreamSource createStreamSource(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            return new StreamSource(new StringReader(result.getWriter().toString()));
        }
        catch (TransformerConfigurationException e) {
            this.validationLogger.reportError(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            this.validationLogger.reportError(e.getLocalizedMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            this.validationLogger.reportError(e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            this.validationLogger.reportError(e.getLocalizedMessage());
        }
        return null;
    }

    protected void transform(Source source, Source xslt, Result result, ErrorCaptureStream captureError) throws TransformerException {
        Transformer transformer = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        transformer = tFactory.newTransformer(xslt);
        transformer.setErrorListener(new ErrorListener(){

            public void error(TransformerException e) throws TransformerException {
                throw e;
            }

            public void fatalError(TransformerException e) throws TransformerException {
                throw e;
            }

            public void warning(TransformerException e) throws TransformerException {
                throw e;
            }
        });
        System.setErr(new PrintStream(captureError));
        transformer.transform(source, result);
        System.setErr(System.err);
    }

    private static class ErrorCaptureStream
    extends OutputStream {
        private String[] lines = new String[5];
        private int currentInx = 0;
        private StringBuffer buffer = new StringBuffer();

        public void write(int b) throws IOException {
            if (this.currentInx >= this.lines.length) {
                return;
            }
            if (b == 10) {
                if (this.currentInx == 0 || !this.buffer.toString().equals(this.lines[this.currentInx - 1])) {
                    this.lines[this.currentInx++] = this.buffer.toString();
                }
                this.buffer = new StringBuffer();
                return;
            }
            if (b != 13) {
                this.buffer.append((char)b);
            }
        }

        public boolean isEmpty() {
            return this.lines[0] == null;
        }

        public String[] getLines() {
            return this.lines;
        }
    }
}

