/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.actions;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.actions.AbstractAction;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.core.MainValidator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public class ValidateResourceAction
extends AbstractAction {
    private MainValidator validator = new MainValidator();

    public void run(IAction action) {
        boolean validateIFDocument;
        if (this.noValidSelection()) {
            return;
        }
        Map attributes = this.validator.getAttributes();
        IStructuredSelection selection = this.getSelection();
        IResource firstElement = null;
        boolean bl = validateIFDocument = selection.size() == 1 && (firstElement = (IResource)selection.getFirstElement()) instanceof IFile && SMLCommonUtil.identifyDocumentType((IFile)firstElement) == 2;
        if (validateIFDocument) {
            attributes.put("validation.input.type", "value.sml.if");
            attributes.put("validation.instance", firstElement.getRawLocation().toString());
        } else {
            StringBuffer filePaths = new StringBuffer();
            for (IResource resource : this.getSelection()) {
                if (filePaths.length() > 0) {
                    filePaths.append(",");
                }
                filePaths.append(resource.getFullPath());
            }
            attributes.put("validation.input.type", "value.sml.unit");
            attributes.put("validation.instance", filePaths.toString());
        }
        attributes.put("attribute.environment", "value.environment.eclipse");
        boolean validation = this.validator.start();
        if (validation) {
            MessageDialog.openInformation((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.confirmNoErrorTitle, (String)SMLMessages.confirmNoError);
        } else {
            try {
                SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProblemView");
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.failedValidationTitle, (String)SMLMessages.failedValidation);
            }
        }
    }
}

