/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLConstants;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SMLCommonUtil {
    private static boolean textNodeWrite = false;

    public static void openErrorWithDetail(Shell parent, String title, String message, String cause) {
        class CustomErrorDialog
        extends ErrorDialog {
            private String cause;
            private static final int LIST_ITEM_COUNT = 7;
            private List list;
            private boolean isListDisplayed;
            private Clipboard clipboard;

            public CustomErrorDialog(Shell parentShell, int severity, String dialogTitle, String message, String cause) {
                super(parentShell, dialogTitle, message, (IStatus)new Status(severity, "org.eclipse.cosmos.rm.smlif", severity, "", new Throwable(cause)), 7);
                this.cause = cause;
                this.isListDisplayed = false;
            }

            public void openErrorDialog() {
                this.open();
            }

            protected List createDropDownList(Composite parent) {
                if (this.isListDisplayed) {
                    this.isListDisplayed = false;
                    this.list.dispose();
                    return this.list;
                }
                this.isListDisplayed = true;
                this.list = new List(parent, 2818);
                if (this.cause != null) {
                    StringTokenizer st = new StringTokenizer(this.cause, "\n");
                    String indents = "";
                    boolean addedIndentation = false;
                    while (st.hasMoreTokens()) {
                        String currentToken = st.nextToken();
                        currentToken = currentToken.replace('\r', ' ');
                        currentToken = currentToken.trim();
                        if (!addedIndentation && currentToken.startsWith("at")) {
                            indents = String.valueOf(indents) + "  ";
                            addedIndentation = true;
                        } else if (addedIndentation && !currentToken.startsWith("at")) {
                            addedIndentation = false;
                        }
                        this.list.add(String.valueOf(indents) + currentToken);
                    }
                }
                GridData data = new GridData(1808);
                data.heightHint = this.list.getItemHeight() * 7;
                data.horizontalSpan = 2;
                this.list.setLayoutData((Object)data);
                this.list.setFont(parent.getFont());
                Menu copyMenu = new Menu((Control)this.list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }
                });
                copyItem.setText(SMLMessages.commonCopy);
                this.list.setMenu(copyMenu);
                return this.list;
            }

            private void copyToClipboard() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer clipBoardBuffer = new StringBuffer();
                String[] listEntrySelections = this.list.getSelection();
                int i = 0;
                while (i < listEntrySelections.length) {
                    clipBoardBuffer.append(String.valueOf(listEntrySelections[i]) + SMLConstants.LINE_SEPARATOR);
                    ++i;
                }
                this.clipboard = new Clipboard(this.list.getDisplay());
                this.clipboard.setContents(new Object[]{clipBoardBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        CustomErrorDialog errorDialog = new CustomErrorDialog(parent, 4, title, message, cause);
        errorDialog.openErrorDialog();
    }

    public static void openErrorWithDetail(final String title, final String message, Throwable t) {
        String stackTrace = SMLCommonUtil.getExceptionStackTrace(t);
        Throwable exceptionCause = t.getCause() != null ? t.getCause() : t;
        final String cause = String.valueOf(exceptionCause.getClass().getName()) + "\n" + exceptionCause.getMessage() + "\n" + stackTrace;
        SMLPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SMLCommonUtil.openErrorWithDetail(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, cause);
            }
        });
    }

    public static String getExceptionStackTrace(Throwable t) {
        Throwable throwable = SMLCommonUtil.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    public static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return SMLCommonUtil.findCause(cause);
    }

    public static int identifyDocumentType(IFile file) {
        Throwable exception = null;
        try {
            return SMLValidatorUtil.identifyDocumentType((IFile)file);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (CoreException e) {
            exception = e;
        }
        if (exception != null) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.errorContentTypeTitle, NLS.bind((String)SMLMessages.errorContentType, (Object)file.getFullPath()), exception);
        }
        return 3;
    }

    public static Node retrieveChildNode(Node parent, String uri, String localName) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (uri.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String retrieveTextNode(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node textNode = children.item(i);
            String currentText = null;
            if (textNode.getNodeType() == 3 && (currentText = textNode.getNodeValue()) != null && (currentText = currentText.trim()).length() > 0) {
                sb.append(currentText);
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        StringBuffer finalTextValue = new StringBuffer();
        while (st.hasMoreTokens()) {
            String currentLine = st.nextToken().trim();
            if (currentLine.length() <= 0) continue;
            if (finalTextValue.length() > 0) {
                finalTextValue.append(" ");
            }
            finalTextValue.append(currentLine);
        }
        return finalTextValue.toString();
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames) {
        return SMLCommonUtil.nestedNodeRetrieval(node, nodeNames, false);
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames, boolean create) {
        Node currentNode = node;
        int i = 0;
        while (i < nodeNames.length) {
            if (currentNode == null) {
                return null;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(currentNode, nodeNames[i][0], nodeNames[i][1]);
            if (childNode == null && create) {
                childNode = currentNode.getOwnerDocument().createElementNS(nodeNames[i][0], nodeNames[i][1]);
                childNode.setPrefix(currentNode.getPrefix());
                currentNode.appendChild(childNode);
            }
            currentNode = childNode;
            ++i;
        }
        return currentNode;
    }

    public static Node[] retrieveChildElements(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                childElements.add(child);
            }
            ++i;
        }
        return childElements.toArray(new Node[childElements.size()]);
    }

    public static Node createElement(Node parentNode, String uri, String localName) {
        Element node = parentNode.getOwnerDocument().createElementNS(uri, localName);
        node.setPrefix(parentNode.getPrefix());
        parentNode.appendChild(node);
        return node;
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent) {
        SMLCommonUtil.serializeNode(buffer, node, indent, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void serializeNode(StringBuffer buffer, Node node, int indent, String currentIndex, Map indices) {
        switch (node.getNodeType()) {
            case 3: {
                SMLCommonUtil.textNodeWrite = true;
                buffer.append(node.getNodeValue().trim());
                break;
            }
            case 8: {
                if (node.getNodeValue() == null) {
                    return;
                }
                SMLValidatorUtil.addIndent((StringBuffer)buffer, (int)indent);
                buffer.append("<!--" + node.getNodeValue() + "-->");
                break;
            }
            case 1: {
                needsLineSep = false;
                i = buffer.length() - 1;
                while (i >= 0) {
                    currentChar = buffer.charAt(i);
                    if (currentChar == '\n') break;
                    if (currentChar != '\t' && currentChar != ' ' && currentChar != '\r') {
                        needsLineSep = true;
                        break;
                    }
                    --i;
                }
                if (needsLineSep) {
                    buffer.append(IValidationConstants.LINE_SEPARATOR);
                }
                attributes = node.getAttributes();
                children = SMLCommonUtil.retrieveChildNodes(node);
                hasAttributes = attributes != null && attributes.getLength() > 0;
                hasChildren = children != null && children.length > 0;
                SMLCommonUtil.textNodeWrite = false;
                elementIndices = new int[2];
                elementIndices[0] = buffer.length();
                SMLValidatorUtil.addElement((StringBuffer)buffer, (int)indent, (String)node.getNodeName(), (boolean)false, (boolean)false);
                if (hasAttributes) {
                    SMLValidatorUtil.addAttribute((StringBuffer)buffer, (NamedNodeMap)attributes, (boolean)(hasChildren == false), (boolean)true);
                } else if (!hasChildren) {
                    buffer.append("/").append(">");
                } else {
                    buffer.append(">");
                }
                if (!hasChildren) {
                    elementIndices[1] = buffer.length();
                    if (currentIndex != null) {
                        indices.put(currentIndex, elementIndices);
                    }
                    return;
                }
                counter = 0;
                i = 0;
                while (i < children.length) {
                    child = children[i];
                    if (child.getNodeType() != 3) ** GOTO lbl59
                    nodeValue = child.getNodeValue();
                    if (nodeValue != null && nodeValue.trim().length() > 0) ** GOTO lbl61
                    ** GOTO lbl62
lbl59:
                    // 1 sources

                    buffer.append(IValidationConstants.LINE_SEPARATOR);
lbl61:
                    // 2 sources

                    SMLCommonUtil.serializeNode(buffer, child, indent + 1, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter++, indices);
lbl62:
                    // 2 sources

                    ++i;
                }
                SMLValidatorUtil.addElement((StringBuffer)buffer, (int)(SMLCommonUtil.textNodeWrite != false ? -1 : indent), (String)node.getNodeName(), (boolean)true, (boolean)true);
                elementIndices[1] = buffer.length();
                if (currentIndex != null) {
                    indices.put(currentIndex, elementIndices);
                }
                SMLCommonUtil.textNodeWrite = false;
                break;
            }
            case 9: {
                buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + IValidationConstants.LINE_SEPARATOR);
                children = node.getChildNodes();
                if (children == null) break;
                i = 0;
                childCount = children.getLength();
                while (i < childCount) {
                    SMLCommonUtil.serializeNode(buffer, children.item(i), indent, currentIndex, indices);
                    ++i;
                }
                break;
            }
        }
    }

    private static Node[] retrieveChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        ArrayList<Node> finalChildrenList = new ArrayList<Node>();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            String nodeValue = null;
            if (child.getNodeType() != 3 || (nodeValue = child.getNodeValue()) != null && nodeValue.trim().length() > 0) {
                finalChildrenList.add(child);
            }
            ++i;
        }
        return finalChildrenList.toArray(new Node[finalChildrenList.size()]);
    }

    public static String beginTagFor(String elementName) {
        return SMLCommonUtil.tagFor(false, null, elementName);
    }

    public static String beginTagFor(String namespace, String elementName) {
        return SMLCommonUtil.tagFor(false, namespace, elementName);
    }

    public static String endTagFor(String elementName) {
        return SMLCommonUtil.tagFor(true, null, elementName);
    }

    public static String endTagFor(String namespace, String elementName) {
        return SMLCommonUtil.tagFor(true, namespace, elementName);
    }

    protected static String tagFor(boolean end, String namespace, String elementName) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        if (namespace != null) {
            tagBuffer.append(namespace).append(":");
        }
        tagBuffer.append(elementName).append(">");
        return tagBuffer.toString();
    }
}

