/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.DocumentsPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.OverviewPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLFormToolkit;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFFormPart;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SMLIFEditor
extends FormEditor
implements IResourceChangeListener {
    public static final int TYPE_IDENTITY = 0;
    private OverviewPage overviewPage;
    private DocumentsPage documentsPage;
    private SMLIFPage smlifPage;
    private Node rootNode;
    private Node identityNode;
    private boolean reportedError;
    private SMLFormToolkit extendedToolkit;
    private AbstractFormPage[] formPages;
    private Document document;
    private SMLIFFormPart smlifFormPart;
    private boolean needsReload;
    private boolean enableResourceListener;
    private long lastModifiedDate;
    private ActivateListener activateListener;
    private IFile workspaceFile;
    private File localFile;

    public SMLIFEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 3);
        this.extendedToolkit = new SMLFormToolkit(SMLPlugin.getDefault().getWorkbench().getDisplay());
        this.smlifFormPart = new SMLIFFormPart(this);
        this.enableResourceListener = true;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.workspaceFile = null;
        this.localFile = null;
        if (input instanceof IFileEditorInput) {
            this.workspaceFile = ((IFileEditorInput)input).getFile();
        } else if (input instanceof IPathEditorInput) {
            this.localFile = new File(((IPathEditorInput)input).getPath().toString());
        }
        if (this.workspaceFile == null && this.localFile == null) {
            throw new PartInitException(SMLMessages.errorEditorWrongInput);
        }
        super.init(site, input);
        this.setPartName(this.workspaceFile == null ? this.localFile.getName() : this.workspaceFile.getName());
        if (site != null) {
            this.activateListener = new ActivateListener(site);
        }
    }

    protected void addPages() {
        this.overviewPage = new OverviewPage(this);
        this.documentsPage = new DocumentsPage(this);
        this.smlifPage = new SMLIFPage(this);
        this.formPages = new AbstractFormPage[]{this.overviewPage, this.documentsPage, this.smlifPage};
        try {
            int i = 0;
            while (i < this.formPages.length) {
                this.addPage((IEditorPart)this.formPages[i], this.getEditorInput());
                ++i;
            }
            this.getSite().setSelectionProvider(null);
            this.setActivePage("org.eclipse.cosmos.rm.smlif.OverviewPage");
        }
        catch (PartInitException e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.errorEditorTitle, SMLMessages.errorEditorPages, e);
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.activateListener.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.enableResourceListener = false;
        this.smlifFormPart.commit(true);
        if (!this.isDirty()) {
            this.editorDirtyStateChanged();
        }
        int i = 0;
        while (i < this.formPages.length) {
            this.formPages[i].doSave(monitor);
            ++i;
        }
        this.enableResourceListener = true;
    }

    public void doSaveAs() {
        this.smlifPage.doSaveAs();
        this.setInput(this.smlifPage.getEditorInput());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enableResourceListener || this.workspaceFile == null) {
            return;
        }
        block0 : switch (event.getType()) {
            case 2: {
                this.closeAllEditors(event);
                break;
            }
            case 1: {
                IEditorInput input = this.getEditorInput();
                if (input == null) {
                    return;
                }
                String inputPath = this.workspaceFile.getFullPath().toString();
                if (inputPath == null || inputPath.length() <= 0) {
                    return;
                }
                IResourceDelta[] affectedChildren = event.getDelta().getAffectedChildren();
                ArrayList affectedResourcePaths = new ArrayList();
                this.findAffectedResourcePaths(affectedChildren, affectedResourcePaths);
                int i = 0;
                int resourceCount = affectedResourcePaths.size();
                while (i < resourceCount) {
                    if (inputPath.equals(affectedResourcePaths.get(i))) {
                        this.needsReload = true;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void closeAllEditors(final IResourceChangeEvent resourceChangeEvent) {
        Runnable closeEditors = new Runnable(){

            public void run() {
                IWorkbenchPage[] pages = SMLIFEditor.this.getSite().getWorkbenchWindow().getPages();
                int i = 0;
                while (i < pages.length) {
                    if (resourceChangeEvent == null || SMLIFEditor.this.workspaceFile.getProject().equals((Object)resourceChangeEvent.getResource())) {
                        IEditorPart editorPart = pages[i].findEditor(SMLIFEditor.this.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                    ++i;
                }
            }
        };
        Display.getDefault().asyncExec(closeEditors);
    }

    private void findAffectedResourcePaths(IResourceDelta[] affectedChildren, List list) {
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta[] affected = affectedChildren[i].getAffectedChildren();
            if (affected == null || affected.length <= 0) {
                list.add(affectedChildren[i].getFullPath().toString());
            } else {
                this.findAffectedResourcePaths(affected, list);
            }
            ++i;
        }
    }

    public String retrieveField(int type, String name) {
        Node rootDocumentNode = this.getDocumentNode();
        if (rootDocumentNode == null) {
            return null;
        }
        if (type == 0) {
            this.identityNode = this.identityNode == null ? SMLCommonUtil.retrieveChildNode(rootDocumentNode, "http://schemas.serviceml.org/smlif/2006/10", "identity") : this.identityNode;
            return SMLCommonUtil.retrieveTextNode(SMLCommonUtil.retrieveChildNode(this.identityNode, "http://schemas.serviceml.org/smlif/2006/10", name));
        }
        return null;
    }

    public Node retrieveChildNode(String uri, String localName) {
        return SMLCommonUtil.retrieveChildNode(this.getDocumentNode(), uri, localName);
    }

    /*
     * Exception decompiling
     */
    protected Node getDocumentNode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Document getDocument() {
        if (this.document == null) {
            this.getDocumentNode();
        }
        return this.document;
    }

    public SMLFormToolkit getExtendedToolkit() {
        return this.extendedToolkit;
    }

    public SMLIFFormPart getSmlifFormPart() {
        return this.smlifFormPart;
    }

    public void markDirty() {
        boolean markEditorDirty = false;
        markEditorDirty = !this.isDirty();
        this.smlifFormPart.markDirty();
        if (markEditorDirty) {
            this.editorDirtyStateChanged();
        }
    }

    private class ActivateListener
    implements IPartListener,
    IWindowListener {
        public ActivateListener(IEditorSite site) {
            site.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            SMLIFEditor.this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            this.handleActivation();
        }

        private void handleActivation() {
            long currentModfiedDate = 0L;
            if (SMLIFEditor.this.workspaceFile == null) {
                return;
            }
            currentModfiedDate = new File(SMLIFEditor.this.workspaceFile.getRawLocation().toString()).lastModified();
            if (currentModfiedDate != 0L && currentModfiedDate != SMLIFEditor.this.lastModifiedDate && !SMLIFEditor.this.workspaceFile.isSynchronized(0)) {
                SMLIFEditor.this.lastModifiedDate = currentModfiedDate;
                if (!SMLIFEditor.this.needsReload && !MessageDialog.openQuestion((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.editorFileChangedTitle, (String)SMLMessages.editorFileChanged)) {
                    return;
                }
                try {
                    SMLIFEditor.this.workspaceFile.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    SMLCommonUtil.openErrorWithDetail(SMLMessages.errorSynchronizeTitle, SMLMessages.errorSynchronize, e);
                    return;
                }
                SMLIFEditor.this.needsReload = true;
            }
            if (SMLIFEditor.this.needsReload) {
                SMLIFEditor.this.rootNode = null;
                SMLIFEditor.this.identityNode = null;
                SMLIFEditor.this.document = null;
                int i = 0;
                while (i < SMLIFEditor.this.formPages.length) {
                    SMLIFEditor.this.formPages[i].updateContent();
                    ++i;
                }
            }
            SMLIFEditor.this.needsReload = false;
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

