/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFEditor;
import org.eclipse.cosmos.rm.smlif.internal.editor.XMLLineStyler;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.w3c.dom.Node;

public class SMLIFPage
extends AbstractFormPage {
    public static final String ID = "org.eclipse.cosmos.rm.smlif.SMLIFPage";
    private StringBuffer buffer = new StringBuffer();
    private StyledText xmlContent;
    private int scrollPosition = 0;

    public SMLIFPage(FormEditor editor) {
        super(editor, ID, SMLMessages.editorSMLIFTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.addPart((IFormPart)((SMLIFEditor)this.getEditor()).getSmlifFormPart());
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        Composite parent = form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        parent.setLayout((Layout)gridLayout);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        this.xmlContent = editor.getExtendedToolkit().createStyledtext(parent, "", 2816);
        this.xmlContent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.xmlContent.addLineStyleListener((LineStyleListener)new XMLLineStyler());
        this.xmlContent.setFont(new Font((Device)Display.getDefault(), "Courier New", 10, 0));
        this.xmlContent.setEditable(false);
        form.setEnabled(this.isEnabled());
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (!active) {
            this.scrollPosition = this.xmlContent.getTopIndex();
            return;
        }
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        if (this.buffer.length() <= 0 || editor.isDirty()) {
            this.updateContent();
        }
        this.xmlContent.setText(this.buffer.toString());
        this.xmlContent.setTopIndex(this.scrollPosition);
    }

    public void dispose() {
        super.dispose();
        if (this.xmlContent != null) {
            this.xmlContent.dispose();
            this.xmlContent = null;
        }
        this.buffer = null;
    }

    protected void createLeftColumn(Composite parent) {
    }

    protected void createRightColumn(Composite parent) {
    }

    public void doSave(IProgressMonitor monitor) {
        this.updateContent();
    }

    protected void updateContent() {
        this.buffer = new StringBuffer();
        Node documentNode = ((SMLIFEditor)this.getEditor()).getDocumentNode();
        if (documentNode != null) {
            SMLCommonUtil.serializeNode(this.buffer, documentNode, 0);
        }
        if (this.isActive()) {
            this.xmlContent.setText(this.buffer.toString());
        }
    }
}

