/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizard;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ModelUnitFile;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBinding;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableCellModifier;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableLabelProvider;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleFindingFileHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportToSMLIFWizardPage3
extends WizardPage {
    protected static final String DOCUMENT_COLUMN = "DOCUMENT_COLUMN";
    protected static final String RULE_COLUMN = "RULE_COLUMN";
    protected static final String ALIAS_COLUMN = "ALIAS_COLUMN";
    protected ComboBoxCellEditor documentChoicesCombo;
    protected TableViewer ruleBindingsTableViewer;
    protected ComboBoxCellEditor aliasChoicesCombo;
    protected ComboBoxCellEditor ruleChoicesCombo;
    protected List documents;

    public ExportToSMLIFWizardPage3(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
    }

    public void createControl(Composite parent) {
        Composite topComponent = new Composite(parent, 0);
        GridData topComponentData = new GridData(768);
        topComponent.setLayoutData((Object)topComponentData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topComponent.setLayout((Layout)layout);
        this.createRuleBindingsLabel(topComponent);
        this.createRuleBindingsTable(topComponent);
        this.createAddRemoveButtons(topComponent);
        this.setControl((Control)topComponent);
        this.setPageComplete(true);
        Dialog.applyDialogFont((Control)topComponent);
    }

    protected void createAddRemoveButtons(Composite parent) {
        Composite buttonComposite = ExportToSMLIFWizard.createVerticalButtonPanel(parent);
        Button addButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardAddButtonLabelNonPrompting);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ((Collection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getInput()).add(new RuleBinding());
                ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.refresh();
            }
        });
        Button removeButton = ExportToSMLIFWizard.createVerticalButtonPanelButton(buttonComposite, SMLMessages.exportWizardRemoveButtonText);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection selection = (IStructuredSelection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getSelection();
                ((Collection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getInput()).removeAll(selection.toList());
                ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.refresh();
            }
        });
    }

    protected void createRuleBindingsTable(Composite parent) {
        this.ruleBindingsTableViewer = new TableViewer(parent, 65538);
        this.setTableProperties();
        ControlListener listener = this.createTableControlListener(this.ruleBindingsTableViewer.getTable());
        parent.addControlListener(listener);
    }

    protected void setTableProperties() {
        TableLayout layout = new TableLayout();
        Table ruleBindingsTable = this.ruleBindingsTableViewer.getTable();
        ruleBindingsTable.setLayout((Layout)layout);
        ruleBindingsTable.setLinesVisible(true);
        ruleBindingsTable.setLayoutData((Object)new GridData(4, -1, true, false));
        ruleBindingsTable.setHeaderVisible(true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        ruleBindingsTable.setLayoutData((Object)gridData);
        String[] columnNames = new String[]{SMLMessages.exportWizardRuleTableDocumentColumn, SMLMessages.exportWizardRuleTableAliasColumn, SMLMessages.exportWizardRuleTableRuleColumn};
        String[] columnProperties = new String[]{DOCUMENT_COLUMN, ALIAS_COLUMN, RULE_COLUMN};
        ColumnPixelData columnLayout = new ColumnPixelData(100, true);
        TableColumn column = null;
        int i = 0;
        while (i < columnNames.length) {
            column = new TableColumn(ruleBindingsTable, 16384);
            column.setResizable(columnLayout.resizable);
            column.setText(columnNames[i]);
            layout.addColumnData((ColumnLayoutData)columnLayout);
            ++i;
        }
        this.documentChoicesCombo = new ComboBoxCellEditor((Composite)ruleBindingsTable, new String[0], 12);
        this.aliasChoicesCombo = new ComboBoxCellEditor((Composite)ruleBindingsTable, new String[0], 12);
        this.ruleChoicesCombo = new ComboBoxCellEditor((Composite)ruleBindingsTable, new String[0], 12);
        this.ruleBindingsTableViewer.setCellEditors(new CellEditor[]{this.documentChoicesCombo, this.aliasChoicesCombo, this.ruleChoicesCombo});
        this.ruleBindingsTableViewer.setCellModifier((ICellModifier)new RuleBindingTableCellModifier(Arrays.asList(columnProperties), this));
        this.ruleBindingsTableViewer.setColumnProperties(columnProperties);
        this.updateComboChoices();
        this.ruleBindingsTableViewer.setLabelProvider((IBaseLabelProvider)new RuleBindingTableLabelProvider());
        this.ruleBindingsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ruleBindingsTableViewer.setInput((Object)this.getExportWizard().getRuleBindings());
        ruleBindingsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                IStructuredSelection tableSelection = (IStructuredSelection)ExportToSMLIFWizardPage3.this.ruleBindingsTableViewer.getSelection();
                RuleBinding selectedBinding = (RuleBinding)tableSelection.getFirstElement();
                ArrayList aliasChoices = new ArrayList();
                if (selectedBinding.getDocument() != null) {
                    aliasChoices = selectedBinding.getDocument().getAliases();
                }
                ExportToSMLIFWizardPage3.this.aliasChoicesCombo.setItems(aliasChoices.toArray(new String[0]));
            }
        });
    }

    protected void updateComboChoices() {
        Object[] files = this.getModel();
        ArrayList<String> docNames = new ArrayList<String>();
        this.documents = new ArrayList();
        int i = 0;
        while (i < files.length) {
            ModelUnitFile file = (ModelUnitFile)files[i];
            if (file.isPhenic() && file.getAliases().size() > 0) {
                docNames.add(file.getFileName());
                this.documents.add(file);
            }
            ++i;
        }
        Collections.sort(docNames);
        Collections.sort(this.documents, new Comparator(){

            public int compare(Object document1, Object document2) {
                return ((ModelUnitFile)document1).getFileName().compareTo(((ModelUnitFile)document2).getFileName());
            }
        });
        if (this.documentChoicesCombo != null) {
            this.documentChoicesCombo.setItems(docNames.toArray(new String[0]));
            this.ruleChoicesCombo.setItems(this.getRuleListChoices());
        }
    }

    protected final int calculateRemainingHorizontalSpace(Table table) {
        boolean visible;
        Rectangle bounds = table.getBounds();
        boolean bl = visible = bounds.width != 0 || bounds.height != 0;
        if (!visible) {
            return 0;
        }
        int width = bounds.width;
        int tableBorderWidth = table.getBorderWidth();
        width -= tableBorderWidth * 2;
        ScrollBar scrollbar = table.getVerticalBar();
        Point scrollbarSize = scrollbar.getSize();
        width -= scrollbarSize.x;
        TableColumn[] columns = table.getColumns();
        int count = columns.length;
        int cumulative = 0;
        int i = 1;
        while (i < count) {
            TableColumn column = columns[i];
            int columnWidth = column.getWidth();
            cumulative += columnWidth;
            ++i;
        }
        int remainder = width - cumulative;
        return remainder;
    }

    protected ControlListener createTableControlListener(final Table table) {
        return new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ExportToSMLIFWizardPage3.this.handleTableResized(table);
            }
        };
    }

    protected void handleTableResized(Table table) {
        int width = this.calculateRemainingHorizontalSpace(table);
        if (width == 0) {
            return;
        }
        TableColumn[] columns = table.getColumns();
        TableColumn column = columns[0];
        column.setWidth(width);
    }

    protected void createRuleBindingsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(SMLMessages.exportWizardRuleBindingsSectionLabel);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    protected Object[] getModel() {
        Collection selectedFiles = this.getExportWizard().getSelectedFiles().values();
        if (selectedFiles.size() == 0) {
            return new ModelUnitFile[0];
        }
        return selectedFiles.toArray();
    }

    protected ExportToSMLIFWizard getExportWizard() {
        return (ExportToSMLIFWizard)this.getWizard();
    }

    protected String[] getRuleListChoices() {
        ArrayList result = new ArrayList();
        Object[] selectedFiles = this.getModel();
        int i = 0;
        while (i < selectedFiles.length) {
            ModelUnitFile file = (ModelUnitFile)selectedFiles[i];
            if (!file.isPhenic() && file.hasRule() && !file.getAliases().isEmpty()) {
                result.add(file.getAliases().get(0));
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    protected boolean genicHasRule(IFile file) {
        RuleFindingFileHandler handler = new RuleFindingFileHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(file.getLocation().toOSString(), (DefaultHandler)handler);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.hasRule();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.handleTableResized(this.ruleBindingsTableViewer.getTable());
    }

    public List getDocuments() {
        return this.documents;
    }
}

