/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataFileHandler
extends DefaultHandler {
    protected boolean inAlias;
    protected HashMap ruleBindings = new HashMap();
    protected HashMap docAliases = new HashMap();
    protected StringBuffer currentAliasBuffer = new StringBuffer();
    protected String baseURI;
    protected boolean inBaseURI = false;
    protected StringBuffer baseURIBuffer = new StringBuffer();
    protected boolean inDescription = false;
    protected boolean inName = false;
    protected StringBuffer nameBuffer = new StringBuffer();
    protected String name;
    protected String description;
    protected StringBuffer descriptionBuffer = new StringBuffer();
    protected String lastFile;
    protected boolean inDisplayName = false;
    protected boolean inVersion = false;
    protected String version;
    protected StringBuffer versionBuffer = new StringBuffer();
    protected String displayName;
    protected StringBuffer displayNameBuffer = new StringBuffer();

    public void characters(char[] ch, int start, int length) throws SAXException {
        String elementData = new String(ch, start, length);
        String trimmedElementData = elementData.trim();
        if (this.inAlias) {
            this.currentAliasBuffer.append(trimmedElementData);
        }
        if (this.inBaseURI) {
            this.baseURIBuffer.append(trimmedElementData);
        }
        if (this.inName) {
            this.nameBuffer.append(trimmedElementData);
        }
        if (this.inDisplayName) {
            this.displayNameBuffer.append(trimmedElementData);
        }
        if (this.inVersion) {
            this.versionBuffer.append(trimmedElementData);
        }
        if (this.inDescription) {
            this.descriptionBuffer.append(elementData);
        }
        super.characters(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("alias".equals(qName)) {
            this.inAlias = false;
            String alias = this.currentAliasBuffer.toString().trim();
            ArrayList<String> aliases = (ArrayList<String>)this.docAliases.get(this.lastFile);
            if (aliases == null) {
                aliases = new ArrayList<String>();
            }
            aliases.add(alias);
            this.docAliases.put(this.lastFile, aliases);
            this.currentAliasBuffer = new StringBuffer();
        }
        if ("baseURI".equals(qName)) {
            this.inBaseURI = false;
            this.baseURI = this.baseURIBuffer.toString().trim();
            this.baseURIBuffer = new StringBuffer();
        }
        if ("name".equals(qName)) {
            this.inName = false;
            this.name = this.nameBuffer.toString().trim();
            this.nameBuffer = new StringBuffer();
        }
        if ("version".equals(qName)) {
            this.inVersion = false;
            this.version = this.versionBuffer.toString().trim();
            this.versionBuffer = new StringBuffer();
        }
        if ("displayName".equals(qName)) {
            this.inDisplayName = false;
            this.displayName = this.displayNameBuffer.toString().trim();
            this.displayNameBuffer = new StringBuffer();
        }
        if ("description".equals(qName)) {
            this.inDescription = false;
            this.description = this.descriptionBuffer.toString();
            this.descriptionBuffer = new StringBuffer();
        }
        super.endElement(uri, localName, qName);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ruleBinding".equals(qName)) {
            String docAlias = attributes.getValue("documentAlias");
            String ruleAlias = attributes.getValue("ruleAlias");
            if (docAlias != null && ruleAlias != null) {
                this.ruleBindings.put(docAlias, ruleAlias);
            }
        }
        if ("file".equals(qName)) {
            this.lastFile = attributes.getValue("path");
        }
        if ("alias".equals(qName)) {
            this.inAlias = true;
        }
        if ("baseURI".equals(qName)) {
            this.inBaseURI = true;
        }
        if ("name".equals(qName)) {
            this.inName = true;
        }
        if ("version".equals(qName)) {
            this.inVersion = true;
        }
        if ("displayName".equals(qName)) {
            this.inDisplayName = true;
        }
        if ("description".equals(qName)) {
            this.inDescription = true;
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public HashMap getDocAliases() {
        return this.docAliases;
    }

    public HashMap getRuleBindings() {
        return this.ruleBindings;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }
}

