/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleFindingFileHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class ModelUnitFile {
    private static final int UNINITIALIZED_INT = -1;
    protected IFile file;
    protected ArrayList aliases = new ArrayList();
    protected Boolean hasRule = null;
    protected int type = -1;

    public ModelUnitFile(IFile file) {
        this.file = file;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String toString() {
        return this.getFileName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getFileName() == null ? 0 : this.getFileName().hashCode());
        return result;
    }

    protected void initHasRule() {
        RuleFindingFileHandler handler = new RuleFindingFileHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(this.file.getLocation().toOSString(), (DefaultHandler)handler);
        }
        catch (SAXNotRecognizedException e) {
            e.printStackTrace();
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setHasRule(handler.hasRule());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelUnitFile)) {
            return false;
        }
        ModelUnitFile other = (ModelUnitFile)obj;
        return !(this.getFile() == null ? other.getFile() != null : !this.getFile().equals((Object)other.getFile()));
    }

    public int getType() {
        if (this.type == -1) {
            this.type = SMLCommonUtil.identifyDocumentType(this.file);
        }
        return this.type;
    }

    public ArrayList getAliases() {
        return this.aliases;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public boolean addAlias(String string) {
        return this.aliases.add(string);
    }

    public boolean removeAlias(Object string) {
        return this.aliases.remove(string);
    }

    public void removeAlias(int index) {
        this.aliases.remove(index);
    }

    public IFile getFile() {
        return this.file;
    }

    public boolean hasRule() {
        if (this.hasRule == null) {
            this.initHasRule();
        }
        return this.hasRule;
    }

    public void setHasRule(boolean value) {
        this.hasRule = new Boolean(value);
    }

    public void setAliasesIfEmpty(ArrayList newAliases) {
        if (this.aliases.isEmpty()) {
            this.aliases.addAll(newAliases);
        }
    }

    public boolean isPhenic() {
        return this.getType() == 1;
    }

    public boolean isGenic() {
        return this.getType() == 0;
    }
}

