/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ModelUnitFile;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBinding;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public class RuleBindingTableCellModifier
implements ICellModifier {
    private static final Integer NOT_FOUND = new Integer(-1);
    private ExportToSMLIFWizardPage3 wizardPage;
    private List columnProperties;

    public RuleBindingTableCellModifier(List columnProperties, ExportToSMLIFWizardPage3 wizardPage) {
        this.wizardPage = wizardPage;
        this.columnProperties = columnProperties;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.columnProperties.indexOf(property);
        Object modelDataForColumn = RuleBindingTableLabelProvider.getModelDataForColumn(element, columnIndex);
        if (modelDataForColumn == null) {
            return NOT_FOUND;
        }
        if ("DOCUMENT_COLUMN".equals(property)) {
            ModelUnitFile file = (ModelUnitFile)modelDataForColumn;
            return new Integer(this.wizardPage.getDocuments().indexOf(file));
        }
        if ("ALIAS_COLUMN".equals(property)) {
            String alias = (String)modelDataForColumn;
            IStructuredSelection tableSelection = (IStructuredSelection)this.wizardPage.ruleBindingsTableViewer.getSelection();
            RuleBinding selectedBinding = (RuleBinding)tableSelection.getFirstElement();
            ArrayList aliasChoices = new ArrayList();
            if (selectedBinding.getDocument() != null) {
                aliasChoices = selectedBinding.getDocument().getAliases();
            }
            return new Integer(aliasChoices.indexOf(alias));
        }
        if ("RULE_COLUMN".equals(property)) {
            String rule = (String)modelDataForColumn;
            String[] ruleChoices = this.wizardPage.ruleChoicesCombo.getItems();
            int i = 0;
            while (i < ruleChoices.length) {
                if (ruleChoices[i].equals(rule)) {
                    return new Integer(i);
                }
                ++i;
            }
            return NOT_FOUND;
        }
        return NOT_FOUND;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnProperties.indexOf(property);
        RuleBinding ruleBinding = null;
        if (element instanceof Item) {
            TableItem item = (TableItem)element;
            ruleBinding = (RuleBinding)item.getData();
        } else {
            ruleBinding = (RuleBinding)element;
        }
        int selectionIndex = (Integer)value;
        if (selectionIndex == -1) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                List files = this.wizardPage.getDocuments();
                ModelUnitFile file = (ModelUnitFile)files.get(selectionIndex);
                if (file == null || file.equals(ruleBinding.getDocument())) break;
                ruleBinding.setDocument(file);
                ruleBinding.setAlias(null);
                this.wizardPage.aliasChoicesCombo.setItems(file.getAliases().toArray(new String[0]));
                break;
            }
            case 1: {
                String alias = this.wizardPage.aliasChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setAlias(alias);
                break;
            }
            case 2: {
                String rule = this.wizardPage.ruleChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setRule(rule);
                break;
            }
        }
        this.wizardPage.ruleBindingsTableViewer.refresh();
    }
}

