/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.importing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.importing.ExistingFileEvent;
import org.eclipse.cosmos.rm.smlif.internal.importing.IImportEventListener;
import org.eclipse.cosmos.rm.smlif.internal.importing.ImportException;
import org.eclipse.cosmos.rm.smlif.internal.importing.ModelUnit;
import org.eclipse.cosmos.rm.smlif.internal.importing.SMLIFFileHandler;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportFromSMLIF {
    private static final String FILE_ELEMENT = "file";
    private static final String METADATA_ELEMENT = "metadata";
    private boolean createNecessaryStructure;
    private boolean overwriteFilesWithoutWarning = true;
    private Collection importEventListeners;

    public final void addImportEventListener(IImportEventListener importEventListener) {
        if (importEventListener == null) {
            throw new NullPointerException();
        }
        if (this.importEventListeners == null) {
            this.importEventListeners = new ArrayList();
        }
        if (!this.importEventListeners.contains(importEventListener)) {
            this.importEventListeners.add(importEventListener);
        }
    }

    public final void removeImportEventListener(IImportEventListener importEventListener) {
        if (importEventListener == null) {
            throw new NullPointerException();
        }
        if (this.importEventListeners != null) {
            this.importEventListeners.remove(importEventListener);
        }
    }

    private final void fireExistingFileEncountered(ExistingFileEvent importEvent) {
        if (importEvent == null) {
            throw new NullPointerException();
        }
        if (this.importEventListeners != null) {
            for (IImportEventListener listener : this.importEventListeners) {
                listener.existingFileEncountered(importEvent);
            }
        }
    }

    public boolean importFromFileSystemFile(String smlifFileName, String targetDirName) throws ImportException {
        if (ImportFromSMLIF.isNullOrEmpty(smlifFileName)) {
            throw new ImportException(SMLMessages.importErrorNullSmlifFileName);
        }
        if (ImportFromSMLIF.isNullOrEmpty(targetDirName)) {
            throw new ImportException(SMLMessages.importErrorNullTargetDirName);
        }
        SMLIFFileHandler handler = new SMLIFFileHandler();
        try {
            IContainer folder;
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            Path targetDirPath = new Path(targetDirName);
            IProject targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(targetDirPath.segment(0));
            if (!targetProject.exists()) {
                if (!this.createNecessaryStructure) {
                    throw new ImportException(NLS.bind((String)SMLMessages.importErrorProjectDoesNotExist, (Object)targetProject.getName()));
                }
                targetProject.create(null);
                targetProject.open(null);
            }
            String targetDirNameAbsolute = null;
            if (targetDirPath.segmentCount() > 1) {
                IFile targetDirectoryFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetDirPath);
                targetDirNameAbsolute = targetDirectoryFile.getLocation().toOSString();
            } else {
                targetDirNameAbsolute = targetProject.getLocation().toOSString();
            }
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(smlifFileName, (DefaultHandler)handler);
            File metadataFile = new File(String.valueOf(targetDirNameAbsolute) + File.separatorChar + ".smlif_meta");
            BufferedWriter metadataFileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metadataFile), "UTF-8"));
            metadataFileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            metadataFileWriter.write(String.valueOf(SMLCommonUtil.beginTagFor(METADATA_ELEMENT)) + "\n");
            if (handler.getName() != null) {
                metadataFileWriter.write("\t" + ImportFromSMLIF.createElementTag("name", handler.getName()) + "\n");
            }
            if (handler.getDisplayName() != null) {
                metadataFileWriter.write("\t" + ImportFromSMLIF.createElementTag("displayName", handler.getDisplayName()) + "\n");
            }
            if (handler.getVersion() != null) {
                metadataFileWriter.write("\t" + ImportFromSMLIF.createElementTag("version", handler.getVersion()) + "\n");
            }
            if (handler.getBaseURI() != null) {
                metadataFileWriter.write("\t" + ImportFromSMLIF.createElementTag("baseURI", handler.getBaseURI()) + "\n");
            }
            if (handler.getDescription() != null) {
                metadataFileWriter.write("\t" + SMLCommonUtil.beginTagFor("description") + handler.getDescription() + "\n" + "\t" + SMLCommonUtil.endTagFor("description") + "\n");
            }
            for (String alias : handler.getRuleBindings().keySet()) {
                metadataFileWriter.write("\t<ruleBinding documentAlias=\"" + alias + "\"" + " " + "ruleAlias" + "=\"" + handler.getRuleBindings().get(alias) + "\"/>" + "\n");
            }
            for (ModelUnit modelUnit : handler.getModelUnits()) {
                String targetFileName = modelUnit.getFileName();
                File smlifFile = new File(String.valueOf(targetDirNameAbsolute) + File.separatorChar + handler.getModelLocation() + targetFileName);
                if (!this.overwriteFilesWithoutWarning && smlifFile.exists()) {
                    ExistingFileEvent importEvent = new ExistingFileEvent(smlifFile.getName());
                    this.fireExistingFileEncountered(importEvent);
                    if (!importEvent.doit) continue;
                }
                if (this.createNecessaryStructure && !smlifFile.getParentFile().exists() && !smlifFile.getParentFile().mkdirs()) {
                    throw new ImportException(NLS.bind((String)SMLMessages.importErrorCouldNotCreateDirectory, (Object)smlifFile.getParent().toString()), null);
                }
                IPath projectRelativePath = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(smlifFile.getAbsolutePath())).getProjectRelativePath();
                metadataFileWriter.write("\t<file path=\"" + projectRelativePath.toPortableString() + "\">" + "\n");
                for (String alias : modelUnit.getAliases()) {
                    metadataFileWriter.write("\t\t" + ImportFromSMLIF.createElementTag("alias", alias) + "\n");
                }
                metadataFileWriter.write("\t" + SMLCommonUtil.endTagFor(FILE_ELEMENT) + "\n");
                BufferedWriter writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(smlifFile), "UTF-8"));
                        writer.write(modelUnit.getFileContents().toString());
                    }
                    catch (IOException exc) {
                        throw new ImportException(NLS.bind((String)SMLMessages.importErrorCouldNotWriteFile, (Object)smlifFile.toString()), exc);
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            metadataFileWriter.write(String.valueOf(SMLCommonUtil.endTagFor(METADATA_ELEMENT)) + "\n");
            metadataFileWriter.close();
            IFile mfWorkspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(metadataFile.getAbsolutePath().toString()));
            if (mfWorkspaceFile != null) {
                mfWorkspaceFile.refreshLocal(1, null);
            }
            if ((folder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(Path.fromOSString((String)targetDirNameAbsolute))) != null) {
                folder.refreshLocal(2, null);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (ImportException e) {
            throw e;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static String createElementTag(String elementName, String elementData) {
        return String.valueOf(SMLCommonUtil.beginTagFor(elementName)) + elementData + SMLCommonUtil.endTagFor(elementName);
    }

    private static boolean isNullOrEmpty(String string) {
        return string == null || "".equals(string);
    }

    public void setCreateNecessaryStructure(boolean createNecessaryStructure) {
        this.createNecessaryStructure = createNecessaryStructure;
    }

    public void setOverwriteFilesWithoutWarning(boolean overwriteFilesWithoutWarning) {
        this.overwriteFilesWithoutWarning = overwriteFilesWithoutWarning;
    }
}

