/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.importing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ModelUnit {
    private static final String XML_SUFFIX = ".xml";
    private static final String XSD_SUFFIX = ".xsd";
    private static final String PHENIC_PREFIX = "phenic";
    private static final String GENIC_PREFIX = "genic";
    private String fileName = null;
    private StringBuffer contents = new StringBuffer();
    private ArrayList aliases = new ArrayList();
    private int type = -1;

    public ModelUnit(int type) {
        this.type = type;
    }

    public void start() {
        this.contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\n");
    }

    public void stop() {
    }

    public StringBuffer getFileContents() {
        return this.contents;
    }

    public String getFileName() {
        String fileName = this.fileName;
        if (fileName == null || "".equals(fileName)) {
            if (this.aliases.size() > 0) {
                fileName = (String)this.aliases.get(0);
            } else {
                File tempFile = null;
                try {
                    tempFile = File.createTempFile(this.getFilePrefix(), this.getFileSuffix());
                    tempFile.delete();
                }
                catch (IOException iOException) {}
                fileName = tempFile.getName();
            }
        }
        return fileName;
    }

    private String getFilePrefix() {
        return this.isGenic() ? GENIC_PREFIX : PHENIC_PREFIX;
    }

    private String getFileSuffix() {
        return this.isGenic() ? XSD_SUFFIX : XML_SUFFIX;
    }

    protected boolean isGenic() {
        return this.type == 0;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void appendToContents(String string) {
        this.contents.append(string);
    }

    public void addAlias(String string) {
        this.aliases.add(string);
    }

    public ArrayList getAliases() {
        return this.aliases;
    }
}

