/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLConstants;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SMLCommonUtil {
    public static void openErrorWithDetail(Shell parent, String title, String message, String cause) {
        class CustomErrorDialog
        extends ErrorDialog {
            private String cause;
            private static final int LIST_ITEM_COUNT = 7;
            private List list;
            private boolean isListDisplayed;
            private Clipboard clipboard;

            public CustomErrorDialog(Shell parentShell, int severity, String dialogTitle, String message, String cause) {
                super(parentShell, dialogTitle, message, (IStatus)new Status(severity, "org.eclipse.cosmos.rm.smlif", severity, "", new Throwable(cause)), 7);
                this.cause = cause;
                this.isListDisplayed = false;
            }

            public void openErrorDialog() {
                this.open();
            }

            protected List createDropDownList(Composite parent) {
                if (this.isListDisplayed) {
                    this.isListDisplayed = false;
                    this.list.dispose();
                    return this.list;
                }
                this.isListDisplayed = true;
                this.list = new List(parent, 2818);
                if (this.cause != null) {
                    StringTokenizer st = new StringTokenizer(this.cause, "\n");
                    String indents = "";
                    boolean addedIndentation = false;
                    while (st.hasMoreTokens()) {
                        String currentToken = st.nextToken();
                        currentToken = currentToken.replace('\r', ' ');
                        currentToken = currentToken.trim();
                        if (!addedIndentation && currentToken.startsWith("at")) {
                            indents = String.valueOf(indents) + "  ";
                            addedIndentation = true;
                        } else if (addedIndentation && !currentToken.startsWith("at")) {
                            addedIndentation = false;
                        }
                        this.list.add(String.valueOf(indents) + currentToken);
                    }
                }
                GridData data = new GridData(1808);
                data.heightHint = this.list.getItemHeight() * 7;
                data.horizontalSpan = 2;
                this.list.setLayoutData((Object)data);
                this.list.setFont(parent.getFont());
                Menu copyMenu = new Menu((Control)this.list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }
                });
                copyItem.setText(SMLMessages.commonCopy);
                this.list.setMenu(copyMenu);
                return this.list;
            }

            private void copyToClipboard() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer clipBoardBuffer = new StringBuffer();
                String[] listEntrySelections = this.list.getSelection();
                int i = 0;
                while (i < listEntrySelections.length) {
                    clipBoardBuffer.append(String.valueOf(listEntrySelections[i]) + SMLConstants.LINE_SEPARATOR);
                    ++i;
                }
                this.clipboard = new Clipboard(this.list.getDisplay());
                this.clipboard.setContents(new Object[]{clipBoardBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        CustomErrorDialog errorDialog = new CustomErrorDialog(parent, 4, title, message, cause);
        errorDialog.openErrorDialog();
    }

    public static void openErrorWithDetail(final String title, final String message, Throwable t) {
        String stackTrace = SMLCommonUtil.getExceptionStackTrace(t);
        Throwable exceptionCause = t.getCause() != null ? t.getCause() : t;
        final String cause = String.valueOf(exceptionCause.getClass().getName()) + "\n" + exceptionCause.getMessage() + "\n" + stackTrace;
        SMLPlugin.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SMLCommonUtil.openErrorWithDetail(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, cause);
            }
        });
    }

    public static String getExceptionStackTrace(Throwable t) {
        Throwable throwable = SMLCommonUtil.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    public static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return SMLCommonUtil.findCause(cause);
    }

    public static int identifyDocumentType(IFile file) {
        Throwable exception = null;
        try {
            return SMLValidatorUtil.identifyDocumentType((IFile)file);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (CoreException e) {
            exception = e;
        }
        if (exception != null) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.errorContentTypeTitle, NLS.bind((String)SMLMessages.errorContentType, (Object)file.getFullPath()), exception);
        }
        return 3;
    }

    public static Node retrieveChildNode(Node parent, String uri, String localName) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (uri.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String retrieveTextNode(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node textNode = children.item(i);
            String currentText = null;
            if (textNode.getNodeType() == 3 && (currentText = textNode.getNodeValue()) != null && (currentText = currentText.trim()).length() > 0) {
                sb.append(currentText);
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        StringBuffer finalTextValue = new StringBuffer();
        while (st.hasMoreTokens()) {
            String currentLine = st.nextToken().trim();
            if (currentLine.length() <= 0) continue;
            if (finalTextValue.length() > 0) {
                finalTextValue.append(" ");
            }
            finalTextValue.append(currentLine);
        }
        return finalTextValue.toString();
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames) {
        return SMLCommonUtil.nestedNodeRetrieval(node, nodeNames, false, true);
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames, boolean create, boolean append) {
        Node currentNode = node;
        int i = 0;
        while (i < nodeNames.length) {
            if (currentNode == null) {
                return null;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(currentNode, nodeNames[i][0], nodeNames[i][1]);
            if (childNode == null && create) {
                childNode = SMLCommonUtil.createFormattedElement(currentNode, nodeNames[i][0], nodeNames[i][1], append);
            }
            currentNode = childNode;
            ++i;
        }
        return currentNode;
    }

    public static Node createFormattedElement(Node parentNode, String uri, String localName, boolean append) {
        Element childNode = null;
        Document ownerDocument = parentNode.getOwnerDocument();
        childNode = ownerDocument.createElementNS(uri, localName);
        childNode.setPrefix(parentNode.getPrefix());
        Node firstChild = parentNode.getFirstChild();
        Node sibiling = parentNode.getLastChild();
        Node indentNode = null;
        while (sibiling != null && sibiling.getNodeType() != 1) {
            sibiling = sibiling.getPreviousSibling();
        }
        if (sibiling != null && sibiling.getNodeType() == 1 && SMLCommonUtil.isWhitespace(indentNode = sibiling.getPreviousSibling())) {
            Node lastChildNode = parentNode.getLastChild();
            if (SMLCommonUtil.isWhitespace(lastChildNode)) {
                parentNode.removeChild(lastChildNode);
            }
            Text indent = ownerDocument.createTextNode(indentNode.getNodeValue());
            if (append) {
                parentNode.appendChild(indent);
            } else {
                parentNode.insertBefore(indent, firstChild);
            }
        }
        if (append) {
            parentNode.appendChild(childNode);
        } else if (indentNode != null) {
            parentNode.insertBefore(childNode, indentNode.getNextSibling());
        } else {
            parentNode.insertBefore(childNode, firstChild);
        }
        Node parentIndent = parentNode.getPreviousSibling();
        if (SMLCommonUtil.isWhitespace(parentNode)) {
            parentNode.insertBefore(ownerDocument.createTextNode(parentIndent.getNodeValue()), childNode.getNextSibling());
        }
        return childNode;
    }

    public static Node createElement(Node parentNode, String uri, String localName) {
        Element node = parentNode.getOwnerDocument().createElementNS(uri, localName);
        node.setPrefix(parentNode.getPrefix());
        parentNode.appendChild(node);
        return node;
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, boolean autoFormat) {
        SMLCommonUtil.serializeNode(buffer, node, indent, null, null, autoFormat);
    }

    public static void serializeNode(StringBuffer buffer, Node node) {
        SMLCommonUtil.serializeNode(buffer, node, -1, false);
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, String currentIndex, Map indices, boolean autoFormat) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: {
                if (!autoFormat) {
                    buffer.append(node.getNodeValue());
                    break;
                }
                StringBuffer textValueBuffer = new StringBuffer();
                String textValue = node.getNodeValue();
                StringTokenizer st = new StringTokenizer(textValue, "\n");
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken().trim();
                    if (currentToken.length() <= 0) continue;
                    textValueBuffer.append(IValidationConstants.LINE_SEPARATOR);
                    SMLValidatorUtil.addIndent((StringBuffer)textValueBuffer, (int)indent);
                    textValueBuffer.append(currentToken);
                }
                buffer.append(textValueBuffer);
                break;
            }
            case 8: {
                if (node.getNodeValue() == null) {
                    return;
                }
                if (autoFormat) {
                    SMLValidatorUtil.addIndent((StringBuffer)buffer, (int)indent);
                }
                buffer.append("<!--" + node.getNodeValue() + "-->");
                if (!autoFormat) break;
                buffer.append(IValidationConstants.LINE_SEPARATOR);
                break;
            }
            case 1: {
                if (autoFormat) {
                    boolean needsLineSep = false;
                    int i = buffer.length() - 1;
                    while (i >= 0) {
                        char currentChar = buffer.charAt(i);
                        if (currentChar == '\n') break;
                        if (currentChar != '\t' && currentChar != ' ' && currentChar != '\r') {
                            needsLineSep = true;
                            break;
                        }
                        --i;
                    }
                    if (needsLineSep) {
                        buffer.append(IValidationConstants.LINE_SEPARATOR);
                    }
                }
                NamedNodeMap attributes = node.getAttributes();
                Node[] children = SMLCommonUtil.retrieveChildNodes(node);
                boolean hasAttributes = attributes != null && attributes.getLength() > 0;
                boolean hasChildren = children != null && children.length > 0;
                int[] elementIndices = new int[2];
                elementIndices[0] = buffer.length();
                if (autoFormat) {
                    SMLValidatorUtil.addElement((StringBuffer)buffer, (int)indent, (String)node.getNodeName(), (boolean)false, (boolean)false);
                } else {
                    buffer.append("<").append(node.getNodeName());
                }
                if (hasAttributes) {
                    if (autoFormat) {
                        SMLValidatorUtil.addAttribute((StringBuffer)buffer, (NamedNodeMap)attributes, (!hasChildren ? 1 : 0) != 0, (boolean)true);
                    } else {
                        int i = 0;
                        int attCount = attributes.getLength();
                        while (i < attCount) {
                            Node currentAttribute = attributes.item(i);
                            buffer.append(" " + currentAttribute.getNodeName() + "=" + "\"" + currentAttribute.getNodeValue() + "\"");
                            ++i;
                        }
                        buffer.append(hasChildren ? ">" : "/>");
                    }
                } else if (!hasChildren) {
                    buffer.append("/").append(">");
                } else {
                    buffer.append(">");
                }
                if (!hasChildren) {
                    elementIndices[1] = buffer.length();
                    if (currentIndex != null) {
                        indices.put(currentIndex, elementIndices);
                    }
                    return;
                }
                int counter = -1;
                if (autoFormat) {
                    int i = 0;
                    while (i < children.length) {
                        Node child = children[i];
                        if (!SMLCommonUtil.isWhitespace(child)) {
                            buffer.append(IValidationConstants.LINE_SEPARATOR);
                            if (child.getNodeType() == 1) {
                                ++counter;
                            }
                            SMLCommonUtil.serializeNode(buffer, child, indent + 1, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        }
                        ++i;
                    }
                } else {
                    NodeList children1 = node.getChildNodes();
                    int i = 0;
                    int nodeCount = children1.getLength();
                    while (i < nodeCount) {
                        Node currentChild = children1.item(i);
                        if (currentChild.getNodeType() == 1) {
                            ++counter;
                        }
                        SMLCommonUtil.serializeNode(buffer, currentChild, indent + 1, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        ++i;
                    }
                }
                if (autoFormat) {
                    buffer.append(IValidationConstants.LINE_SEPARATOR);
                    SMLValidatorUtil.addElement((StringBuffer)buffer, (int)indent, (String)node.getNodeName(), (boolean)true, (boolean)true);
                } else {
                    buffer.append("<").append("/").append(node.getNodeName()).append(">");
                }
                elementIndices[1] = buffer.length();
                if (currentIndex == null) break;
                indices.put(currentIndex, elementIndices);
                break;
            }
            case 9: {
                buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + IValidationConstants.LINE_SEPARATOR);
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int i = 0;
                int childCount = children.getLength();
                while (i < childCount) {
                    SMLCommonUtil.serializeNode(buffer, children.item(i), indent, currentIndex, indices, autoFormat);
                    ++i;
                }
                break;
            }
        }
    }

    public static boolean isWhitespace(Node node) {
        return node != null && node.getNodeType() == 3 && (node.getNodeValue() == null || node.getNodeValue().trim().length() <= 0);
    }

    private static Node[] retrieveChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        ArrayList<Node> finalChildrenList = new ArrayList<Node>();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (!SMLCommonUtil.isWhitespace(child)) {
                finalChildrenList.add(child);
            }
            ++i;
        }
        return finalChildrenList.toArray(new Node[finalChildrenList.size()]);
    }

    public static String beginTagFor(String elementName) {
        return SMLCommonUtil.tagFor(false, null, elementName);
    }

    public static String beginTagFor(String namespace, String elementName) {
        return SMLCommonUtil.tagFor(false, namespace, elementName);
    }

    public static String endTagFor(String elementName) {
        return SMLCommonUtil.tagFor(true, null, elementName);
    }

    public static String endTagFor(String namespace, String elementName) {
        return SMLCommonUtil.tagFor(true, namespace, elementName);
    }

    protected static String tagFor(boolean end, String namespace, String elementName) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        if (namespace != null) {
            tagBuffer.append(namespace).append(":");
        }
        tagBuffer.append(elementName).append(">");
        return tagBuffer.toString();
    }
}

