/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.smlif.internal.SMLImages;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.dialogs.ResourceSelectionDialog;
import org.eclipse.cosmos.rm.smlif.internal.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLFormToolkit;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFEditor;
import org.eclipse.cosmos.rm.smlif.internal.editor.XMLLineStyler;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentsPage
extends AbstractFormPage
implements SelectionListener,
ISelectionChangedListener {
    public static final String ID = "org.eclipse.cosmos.rm.smlif.DocumentsPage";
    private static final byte OPERATION_ADD_DOCUMENT = 0;
    private static final byte OPERATION_REMOVE_DOCUMENT = 1;
    private static final byte OPERATION_ADD_ALIASES = 2;
    private static final byte OPERATION_REMOVE_ALIASES = 3;
    private static final byte OPERATION_MODIFY_ALIAS = 4;
    private Table aliasTable;
    private StyledText rawStyledText;
    private TreeViewer logicalRepresentation;
    private Node input;
    private Button addAlias;
    private Button removeAlias;
    private Map indices = new Hashtable();
    private TreeViewer documentTreeViewer;

    public DocumentsPage(FormEditor editor) {
        super(editor, ID, SMLMessages.editorDocumentTitle);
    }

    protected void setWeight(SashForm sashForm) {
        sashForm.setWeights(new int[]{40, 60});
    }

    protected void createLeftColumn(Composite parent) {
        this.getManagedForm().addPart((IFormPart)((SMLIFEditor)this.getEditor()).getSmlifFormPart());
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(parent);
        Composite sectionClient = toolkit.createComposite((Composite)section, 0);
        sectionClient.setLayout((Layout)new GridLayout());
        sectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        Tree documentTree = toolkit.createTree(sectionClient, 0);
        documentTree.setLayout((Layout)new GridLayout());
        documentTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.documentTreeViewer = new TreeViewer(documentTree);
        this.documentTreeViewer.setContentProvider((IContentProvider)new DocumentContentProvider());
        this.documentTreeViewer.setLabelProvider((IBaseLabelProvider)new DocumentLabelProvider());
        this.documentTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.documentTreeViewer.setInput((Object)this.getEditor());
        Menu documentContextMenu = new Menu((Control)documentTree);
        documentTree.setMenu(documentContextMenu);
        final MenuItem addDocument = this.createMenuItem(documentContextMenu, SMLMessages.editorAddDocument, (byte)0);
        final MenuItem removeDocument = this.createMenuItem(documentContextMenu, SMLMessages.editorRemoveDocument, (byte)1);
        documentContextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                DocumentTreeElement selection = (DocumentTreeElement)((StructuredSelection)DocumentsPage.this.documentTreeViewer.getSelection()).getFirstElement();
                boolean rootSelected = selection != null && selection.isRootElement();
                addDocument.setEnabled(rootSelected);
                addDocument.setImage(rootSelected ? SMLImages.INSTANCE.getImage("c", "add.gif") : SMLImages.INSTANCE.getImage("d", "add.gif"));
                removeDocument.setEnabled(!rootSelected);
                removeDocument.setImage(!rootSelected ? SMLImages.INSTANCE.getImage("c", "remove.gif") : SMLImages.INSTANCE.getImage("d", "remove.gif"));
            }
        });
        this.makeSectionReady(section, sectionClient, SMLMessages.editorDocuments);
    }

    private MenuItem createMenuItem(Menu parent, String text, byte operation) {
        MenuItem menuItem = new MenuItem(parent, 0);
        menuItem.setText(text);
        menuItem.addSelectionListener((SelectionListener)this);
        menuItem.setData((Object)new Byte(operation));
        return menuItem;
    }

    private Button createButton(Composite parent, String text, SelectionListener listener, byte operation, boolean enabled) {
        Button button = this.getManagedForm().getToolkit().createButton(parent, text, 0);
        button.setLayoutData((Object)new GridData(4, -1, true, false));
        button.addSelectionListener(listener);
        button.setData((Object)new Byte(operation));
        button.setEnabled(enabled);
        GridData layoutData = new GridData(-1, -1, true, false);
        layoutData.widthHint = 100;
        layoutData.horizontalAlignment = 131072;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    protected void createRightColumn(Composite parent) {
        SMLFormToolkit toolkit = ((SMLIFEditor)this.getEditor()).getExtendedToolkit();
        SashForm sashForm = toolkit.createSashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Section logicalSection = this.createSection((Composite)sashForm);
        Composite logicalClient = toolkit.createComposite((Composite)logicalSection);
        logicalClient.setLayout((Layout)new GridLayout());
        logicalClient.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createLabel(logicalClient, SMLMessages.editorAliases);
        Composite aliasComposite = toolkit.createComposite(logicalClient);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        aliasComposite.setLayout((Layout)gridLayout);
        aliasComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        this.aliasTable = toolkit.createTable(aliasComposite, 0);
        this.aliasTable.setLinesVisible(true);
        this.aliasTable.setLayout((Layout)new GridLayout());
        this.aliasTable.setLayoutData((Object)new GridData(4, -1, true, false));
        this.aliasTable.setHeaderVisible(true);
        CheckboxTableViewer aliasTableViewer = new CheckboxTableViewer(this.aliasTable);
        this.setTableProperties((TableViewer)aliasTableViewer);
        Composite buttonComposite = toolkit.createComposite(aliasComposite);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        GridData buttonCompositeGD = new GridData();
        buttonCompositeGD.verticalAlignment = 128;
        buttonCompositeGD.horizontalAlignment = 131072;
        buttonComposite.setLayoutData((Object)buttonCompositeGD);
        this.addAlias = this.createButton(buttonComposite, SMLMessages.editorAddButton, this, (byte)2, false);
        this.removeAlias = this.createButton(buttonComposite, SMLMessages.editorRemoveButton, this, (byte)3, false);
        this.aliasTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(DocumentsPage.this.aliasTable.getSelection() != null && DocumentsPage.this.aliasTable.getSelection().length > 0);
            }

            public void focusLost(FocusEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(false);
            }
        });
        this.aliasTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DocumentsPage.this.removeAlias.setEnabled(DocumentsPage.this.aliasTable.getSelection() != null && DocumentsPage.this.aliasTable.getSelection().length > 0);
            }
        });
        toolkit.createLabel(logicalClient, SMLMessages.editorLogicalTree);
        Tree logicalTree = toolkit.createTree(logicalClient, 0);
        logicalTree.setLayout((Layout)new GridLayout());
        logicalTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.logicalRepresentation = new TreeViewer(logicalTree);
        this.logicalRepresentation.setContentProvider((IContentProvider)new LogicalContentProvider());
        this.logicalRepresentation.setLabelProvider((IBaseLabelProvider)new LogicalLabelProvider());
        this.logicalRepresentation.addSelectionChangedListener((ISelectionChangedListener)new LogicalSelectionListener());
        this.makeSectionReady(logicalSection, logicalClient, SMLMessages.editorLogicalRepresentation);
        Section rawSection = this.createSection((Composite)sashForm);
        Composite rawSectionClient = toolkit.createComposite((Composite)rawSection);
        rawSectionClient.setLayout((Layout)new GridLayout());
        rawSectionClient.setLayoutData((Object)new GridData(4, 4, true, true));
        SMLIFEditor editor = (SMLIFEditor)this.getEditor();
        this.rawStyledText = editor.getExtendedToolkit().createStyledtext(rawSectionClient, null, 2816);
        this.rawStyledText.setLayout((Layout)new GridLayout());
        this.rawStyledText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rawStyledText.addLineStyleListener((LineStyleListener)new XMLLineStyler());
        this.rawStyledText.setFont(new Font((Device)Display.getDefault(), "Courier New", 10, 0));
        this.rawStyledText.setEditable(false);
        this.makeSectionReady(rawSection, rawSectionClient, SMLMessages.editorXMLRepresentation);
    }

    private void setTableProperties(TableViewer tableViewer) {
        TableLayout layout = new TableLayout();
        this.aliasTable.setLayout((Layout)layout);
        GridData aliasTableGD = new GridData(4, 4, true, true);
        aliasTableGD.heightHint = 50;
        this.aliasTable.setLayoutData((Object)aliasTableGD);
        ColumnPixelData columnLayout = new ColumnPixelData(300, true);
        layout.addColumnData((ColumnLayoutData)columnLayout);
        TableColumn column = new TableColumn(this.aliasTable, 0, 0);
        column.setResizable(columnLayout.resizable);
        column.setText(SMLMessages.editorName);
        tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.aliasTable)});
        tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                TableItem[] tableItem = DocumentsPage.this.aliasTable.getSelection();
                if (tableItem == null || tableItem.length != 1) {
                    return null;
                }
                return tableItem[0].getText(0);
            }

            public void modify(Object element, String property, Object value) {
                TableItem[] tableItem = DocumentsPage.this.aliasTable.getSelection();
                if (tableItem == null || tableItem.length != 1 || tableItem[0].getText().equals((String)value)) {
                    return;
                }
                DocumentsPage.this.handleOperation((byte)4, new Object[]{value});
                tableItem[0].setText((String)value);
            }
        });
        tableViewer.setColumnProperties(new String[]{"ALIAS_COLUMN"});
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.handleOperation((Byte)e.widget.getData(), null);
    }

    private boolean handleOperation(byte operation, Object[] arguments) {
        switch (operation) {
            case 0: {
                Tree documentTree = this.documentTreeViewer.getTree();
                TreeItem[] selection = documentTree.getSelection();
                if (selection == null || selection.length <= 0) {
                    return false;
                }
                boolean definitionsSelected = documentTree.indexOf(selection[0]) == 0;
                ResourceSelectionDialog resourceDialog = new ResourceSelectionDialog(SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), definitionsSelected ? 0 : 1);
                resourceDialog.setMultiSelection(true);
                IFile[] selectedFile = resourceDialog.open();
                if (selectedFile == null || selectedFile.length <= 0) {
                    return false;
                }
                SMLIFEditor editor = (SMLIFEditor)this.getEditor();
                Node rootNode = editor.retrieveChildNode("http://schemas.serviceml.org/smlif/2007/02", definitionsSelected ? "definitions" : "instances");
                if (rootNode == null) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorAddingDocumentTitle, (String)SMLMessages.errorAddingDocument0);
                    return false;
                }
                IFile file = null;
                try {
                    int i = 0;
                    while (i < selectedFile.length) {
                        file = selectedFile[i];
                        Node documentNode = SMLCommonUtil.createElement(rootNode, "http://schemas.serviceml.org/smlif/2007/02", "document");
                        Node dataNode = SMLCommonUtil.createElement(documentNode, "http://schemas.serviceml.org/smlif/2007/02", "data");
                        this.adoptNode(dataNode.getOwnerDocument(), dataNode, SMLValidatorUtil.domParseDocument((InputStream)file.getContents(), (boolean)false, (boolean)true).getFirstChild());
                        ++i;
                    }
                }
                catch (Exception e) {
                    SMLCommonUtil.openErrorWithDetail(SMLMessages.errorAddingDocumentTitle, NLS.bind((String)SMLMessages.errorAddingDocument1, (Object)(file == null ? "" : file.getName())), e);
                    return false;
                }
                this.documentTreeViewer.refresh();
                this.expandRootElement(definitionsSelected);
                editor.markDirty();
                break;
            }
            case 1: {
                Tree documentTree = this.documentTreeViewer.getTree();
                TreeItem[] selections = documentTree.getSelection();
                if (selections == null || selections.length <= 0) {
                    return false;
                }
                if (!MessageDialog.openQuestion((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.editorRemoveDocumentTitle, (String)SMLMessages.editorRemoveDocumentQuestion)) {
                    return false;
                }
                TreeItem parentItem = selections[0].getParentItem();
                int documentIndex = parentItem == null ? -1 : parentItem.indexOf(selections[0]);
                SMLIFEditor editor = (SMLIFEditor)this.getEditor();
                Node rootNode = documentIndex < 0 ? null : editor.retrieveChildNode("http://schemas.serviceml.org/smlif/2007/02", documentTree.indexOf(parentItem) == 0 ? "definitions" : "instances");
                Node[] rootChildren = null;
                if (rootNode == null || documentIndex < 0 || (rootChildren = SMLValidatorUtil.retrieveChildElements((Node)rootNode)) == null || documentIndex >= rootChildren.length) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemovingDocumentTitle, (String)SMLMessages.errorRemovingDocument0);
                }
                rootNode.removeChild(rootChildren[documentIndex]);
                this.documentTreeViewer.refresh();
                this.expandRootElement(documentTree.indexOf(parentItem) == 0);
                editor.markDirty();
                break;
            }
            case 2: {
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "docinfo"}, {"http://schemas.serviceml.org/smlif/2007/02", "aliases"}}, true, false);
                Document ownerDocument = aliases.getOwnerDocument();
                Node aliasElement = SMLCommonUtil.createFormattedElement(aliases, "http://schemas.serviceml.org/smlif/2007/02", "alias", true);
                aliasElement.appendChild(ownerDocument.createTextNode(SMLMessages.editorAlias));
                TableItem tableItem = new TableItem(this.aliasTable, 0);
                tableItem.setText(SMLMessages.editorAlias);
                if (this.aliasTable.getItemCount() == 1) {
                    this.refreshContent();
                }
                ((SMLIFEditor)this.getEditor()).markDirty();
                break;
            }
            case 3: {
                if (this.input == null) {
                    return false;
                }
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "docinfo"}, {"http://schemas.serviceml.org/smlif/2007/02", "aliases"}});
                if (aliases == null) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias1);
                    return false;
                }
                TableItem[] selection = this.aliasTable.getSelection();
                if (selection.length != 1) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias2);
                    return false;
                }
                int inx = this.aliasTable.indexOf(selection[0]);
                NodeList aliasList = aliases.getChildNodes();
                int counter = -1;
                Node currentAlias = null;
                int i = 0;
                int aliasCount = aliasList.getLength();
                while (i < aliasCount && counter != inx) {
                    currentAlias = aliasList.item(i);
                    if (currentAlias.getNodeType() == 1) {
                        ++counter;
                    }
                    ++i;
                }
                if (counter != inx) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorRemoving, (String)SMLMessages.errorRemovingAlias1);
                    return false;
                }
                currentAlias.getParentNode().removeChild(currentAlias);
                this.aliasTable.remove(inx);
                if (inx == 0) {
                    this.refreshContent();
                }
                ((SMLIFEditor)this.getEditor()).markDirty();
                break;
            }
            case 4: {
                Node aliases = SMLCommonUtil.nestedNodeRetrieval(this.input, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "docinfo"}, {"http://schemas.serviceml.org/smlif/2007/02", "aliases"}});
                TableItem[] selection = this.aliasTable.getSelection();
                int selectionInx = selection == null || selection.length != 1 ? -1 : this.aliasTable.indexOf(selection[0]);
                Node[] aliasList = SMLValidatorUtil.retrieveChildElements((Node)aliases);
                if (aliases == null || selectionInx < 0 || selectionInx >= aliasList.length) {
                    MessageDialog.openError((Shell)SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.errorModifyingAliasTitle, (String)SMLMessages.errorModifyingAlias0);
                    if (selectionInx >= 0) {
                        this.aliasTable.remove(selectionInx);
                    }
                    return false;
                }
                NodeList aliasChildNodes = aliasList[selectionInx].getChildNodes();
                int i = 0;
                int aliasChildNodeCount = aliasChildNodes.getLength();
                while (i < aliasChildNodeCount) {
                    aliasList[selectionInx].removeChild(aliasChildNodes.item(i));
                    ++i;
                }
                aliasList[selectionInx].appendChild(aliasList[selectionInx].getOwnerDocument().createTextNode((String)arguments[0]));
                if (selectionInx == 0) {
                    this.refreshContent();
                }
                ((SMLIFEditor)this.getEditor()).markDirty();
            }
        }
        return true;
    }

    private void refreshContent() {
        Tree documentTree = this.documentTreeViewer.getTree();
        TreeItem[] selection = documentTree.getSelection();
        if (selection != null && selection.length > 0) {
            int itemInx = selection[0].getParentItem().indexOf(selection[0]);
            boolean definitionsSelected = documentTree.indexOf(selection[0].getParentItem()) == 0;
            this.documentTreeViewer.refresh();
            this.expandRootElement(definitionsSelected);
            Event event = new Event();
            event.type = 13;
            event.widget = documentTree;
            event.item = documentTree.getItem(definitionsSelected ? 0 : 1).getItem(itemInx);
            documentTree.setSelection((TreeItem)event.item);
            documentTree.notifyListeners(event.type, event);
        }
    }

    private void expandRootElement(boolean definitionsSelected) {
        int expandedInx;
        Tree documentTree = this.documentTreeViewer.getTree();
        int n = expandedInx = definitionsSelected ? 0 : 1;
        if (expandedInx < documentTree.getItemCount()) {
            Event event = new Event();
            event.type = 17;
            event.widget = documentTree;
            event.item = documentTree.getItem(expandedInx);
            documentTree.getItem(expandedInx).setExpanded(true);
            documentTree.notifyListeners(event.type, event);
        }
    }

    private void adoptNode(Document document, Node parent, Node node) {
        switch (node.getNodeType()) {
            case 3: {
                String value = node.getNodeValue();
                if (value == null) {
                    return;
                }
                parent.appendChild(document.createTextNode(value));
                break;
            }
            case 8: {
                String value = node.getNodeValue();
                if (value == null) {
                    return;
                }
                parent.appendChild(document.createComment(value));
            }
            case 1: {
                NodeList children;
                Element clonedNode = document.createElementNS(node.getNamespaceURI(), node.getNodeName());
                clonedNode.setPrefix(node.getPrefix());
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    int i = 0;
                    int attCount = attributes.getLength();
                    while (i < attCount) {
                        this.adoptNode(document, clonedNode, attributes.item(i));
                        ++i;
                    }
                }
                if ((children = node.getChildNodes()) != null) {
                    int i = 0;
                    int childCount = children.getLength();
                    while (i < childCount) {
                        this.adoptNode(document, clonedNode, children.item(i));
                        ++i;
                    }
                }
                parent.appendChild(clonedNode);
                break;
            }
            case 2: {
                Attr clonedNode = document.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                clonedNode.setNodeValue(node.getNodeValue());
                parent.getAttributes().setNamedItemNS(clonedNode);
            }
        }
    }

    private boolean isDefinitionOrInstance(Object element) {
        Node node = null;
        return element instanceof DocumentTreeElement && (node = ((DocumentTreeElement)element).getNode()) != null && "http://schemas.serviceml.org/smlif/2007/02".equals(node.getNamespaceURI()) && ("definitions".equals(node.getLocalName()) || "instances".equals(node.getLocalName()));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        StructuredSelection structuredSelection = null;
        if (!selection.isEmpty() && selection instanceof StructuredSelection && (structuredSelection = (StructuredSelection)selection).size() > 0) {
            DocumentTreeElement input = (DocumentTreeElement)structuredSelection.getFirstElement();
            this.setControlEnabble(!input.isRootElement());
            this.setInput(input.isRootElement() ? null : input.getNode());
        } else {
            this.setInput(null);
        }
    }

    private void setControlEnabble(boolean enable) {
        this.addAlias.setEnabled(enable);
        this.rawStyledText.setEnabled(enable);
    }

    private void setInput(Object input) {
        String whitespace;
        Node aliasesNode = SMLCommonUtil.nestedNodeRetrieval((Node)input, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "docinfo"}, {"http://schemas.serviceml.org/smlif/2007/02", "aliases"}});
        this.aliasTable.removeAll();
        this.populateTableAlias(aliasesNode);
        this.input = (Node)input;
        this.logicalRepresentation.setInput(input);
        this.indices.clear();
        Node[] node = null;
        if (input == null || (node = this.extractDocumentContent((Node)input)).length <= 0) {
            this.rawStyledText.setText("");
            return;
        }
        StringBuffer sb = new StringBuffer();
        Node lastChildElement = node[0].getLastChild();
        if (SMLCommonUtil.isWhitespace(lastChildElement) && (whitespace = lastChildElement.getNodeValue()) != null) {
            sb.append(whitespace);
        }
        SMLCommonUtil.serializeNode(sb, node[0], 0, "0", this.indices, false);
        this.rawStyledText.setText(sb.toString());
    }

    private void populateTableAlias(Node aliasesNode) {
        this.removeAlias.setEnabled(false);
        NodeList aliases = null;
        if (aliasesNode == null || (aliases = aliasesNode.getChildNodes()) == null || aliases.getLength() <= 0) {
            return;
        }
        int i = 0;
        int aliasCount = aliases.getLength();
        while (i < aliasCount) {
            String alias;
            Node currentAlias = aliases.item(i);
            if (currentAlias.getNodeType() != 3 && (alias = SMLCommonUtil.retrieveTextNode(currentAlias)) != null && alias.length() > 0) {
                TableItem tableItem = new TableItem(this.aliasTable, 0);
                tableItem.setText(alias);
            }
            ++i;
        }
    }

    private Node[] extractDocumentContent(Node documentNode) {
        Node dataNode = SMLCommonUtil.retrieveChildNode(documentNode, "http://schemas.serviceml.org/smlif/2007/02", "data");
        Node[] elements = SMLValidatorUtil.retrieveChildElements((Node)dataNode);
        if (elements.length <= 0) {
            Node[] nodeArray;
            dataNode = SMLCommonUtil.retrieveChildNode(this.input, "http://schemas.serviceml.org/smlif/2007/02", "locator");
            if (dataNode == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = dataNode;
            }
            return nodeArray;
        }
        return elements;
    }

    protected void updateContent() {
        if (this.documentTreeViewer != null && !this.documentTreeViewer.getTree().isDisposed()) {
            this.documentTreeViewer.refresh();
        }
    }

    private class DocumentContentProvider
    implements ITreeContentProvider {
        private DocumentContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Node node = ((DocumentTreeElement)parent).getNode();
            if (node == null) {
                return new Object[0];
            }
            ArrayList<DocumentTreeElement> children = new ArrayList<DocumentTreeElement>();
            NodeList nodeChildren = node.getChildNodes();
            int i = 0;
            int childCount = nodeChildren.getLength();
            while (i < childCount) {
                Node currentChildNode = nodeChildren.item(i);
                if (currentChildNode.getNodeType() == 1) {
                    DocumentTreeElement element = new DocumentTreeElement();
                    element.setNode(nodeChildren.item(i));
                    children.add(element);
                }
                ++i;
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return DocumentsPage.this.isDefinitionOrInstance(element);
        }

        public Object[] getElements(Object inputElement) {
            SMLIFEditor editor = (SMLIFEditor)DocumentsPage.this.getEditor();
            ArrayList elements = new ArrayList();
            this.addElement(elements, editor.retrieveChildNode("http://schemas.serviceml.org/smlif/2007/02", "definitions"), SMLMessages.editorDefinitions);
            this.addElement(elements, editor.retrieveChildNode("http://schemas.serviceml.org/smlif/2007/02", "instances"), SMLMessages.editorInstances);
            return elements.toArray();
        }

        private void addElement(List elements, Node node, String text) {
            if (node == null) {
                return;
            }
            DocumentTreeElement element = new DocumentTreeElement(true);
            element.setText(text);
            element.setNode(node);
            elements.add(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DocumentLabelProvider
    implements ILabelProvider {
        private DocumentLabelProvider() {
        }

        public Image getImage(Object element) {
            if (DocumentsPage.this.isDefinitionOrInstance(element)) {
                return "definitions".equals(((DocumentTreeElement)element).getNode().getLocalName()) ? SMLImages.INSTANCE.getImage("genics.gif") : SMLImages.INSTANCE.getImage("phenics.gif");
            }
            return SMLImages.INSTANCE.getImage("doc.gif");
        }

        public String getText(Object element) {
            DocumentTreeElement treeElement = (DocumentTreeElement)element;
            if (treeElement.getText() != null) {
                return treeElement.getText();
            }
            return treeElement.retrieveLabel();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class DocumentTreeElement {
        private Node node;
        private String text;
        private boolean rootElement;

        public DocumentTreeElement() {
        }

        public DocumentTreeElement(boolean rootElement) {
            this.rootElement = rootElement;
        }

        public String retrieveLabel() {
            if (this.node == null) {
                return null;
            }
            Node alias = SMLCommonUtil.nestedNodeRetrieval(this.node, new String[][]{{"http://schemas.serviceml.org/smlif/2007/02", "docinfo"}, {"http://schemas.serviceml.org/smlif/2007/02", "aliases"}, {"http://schemas.serviceml.org/smlif/2007/02", "alias"}});
            this.text = SMLCommonUtil.retrieveTextNode(alias);
            if (this.text != null && this.text.length() > 0) {
                return this.text;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(this.node, "http://schemas.serviceml.org/smlif/2007/02", "data");
            if (childNode == null) {
                childNode = SMLCommonUtil.retrieveChildNode(this.node, "http://schemas.serviceml.org/smlif/2007/02", "locator");
                if (childNode == null) {
                    return SMLMessages.commonUnknown;
                }
                Node reference = childNode.getAttributes().getNamedItemNS("http://www.w3.org/1999/xlink", "href");
                return reference == null ? SMLMessages.commonUnknown : String.valueOf(SMLMessages.editorRemoteDoc) + reference.getNodeValue();
            }
            NodeList children = childNode.getChildNodes();
            String text = this.retrieveElementName(children);
            return text == null ? SMLMessages.commonUnknown : text;
        }

        private String retrieveElementName(NodeList children) {
            int i = 0;
            int childCount = children.getLength();
            while (i < childCount) {
                Node node = children.item(i);
                if (node.getNodeType() != 3 && node.getLocalName() != null) {
                    return node.getLocalName();
                }
                ++i;
            }
            return null;
        }

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isRootElement() {
            return this.rootElement;
        }
    }

    private class LogicalContentProvider
    implements ITreeContentProvider {
        private LogicalContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            return SMLValidatorUtil.retrieveChildElements((Node)((Node)parent));
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return SMLValidatorUtil.retrieveChildElements((Node)((Node)element)).length > 0;
        }

        public Object[] getElements(Object input) {
            return DocumentsPage.this.extractDocumentContent((Node)input);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class LogicalLabelProvider
    implements ILabelProvider {
        private LogicalLabelProvider() {
        }

        public Image getImage(Object element) {
            return SMLImages.INSTANCE.getImage("element.gif");
        }

        public String getText(Object element) {
            return ((Node)element).getNodeName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class LogicalSelectionListener
    implements ISelectionChangedListener {
        private LogicalSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
                DocumentsPage.this.rawStyledText.setSelection(0, 0);
                return;
            }
            String index = this.findSelectionIndex(null, DocumentsPage.this.logicalRepresentation.getTree().getSelection()[0]);
            int[] elementIndices = (int[])DocumentsPage.this.indices.get(index);
            if (elementIndices == null) {
                DocumentsPage.this.rawStyledText.setSelection(0, 0);
                return;
            }
            DocumentsPage.this.rawStyledText.setSelection(elementIndices[0], elementIndices[1]);
        }

        private String findSelectionIndex(String index, TreeItem item) {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                String inx = String.valueOf(parentItem.indexOf(item));
                if (index != null && index.length() > 0) {
                    inx = String.valueOf(inx) + "," + index;
                }
                return this.findSelectionIndex(inx, parentItem);
            }
            return "0" + (index == null || index.length() <= 0 ? "" : "," + index);
        }
    }
}

