/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class SMLIFFormPart
implements IFormPart {
    private boolean dirty;
    private SMLIFEditor editor;

    public SMLIFFormPart(SMLIFEditor editor) {
        this.editor = editor;
    }

    public void commit(boolean onSave) {
        if (!onSave) {
            return;
        }
        IEditorInput input = this.editor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFile inputFile = ((IFileEditorInput)input).getFile();
        try {
            StringBuffer buffer = new StringBuffer();
            SMLCommonUtil.serializeNode(buffer, this.editor.getDocument());
            inputFile.setContents((InputStream)new ByteArrayInputStream(buffer.toString().getBytes("UTF-8")), 1, null);
            this.dirty = false;
        }
        catch (Exception e) {
            SMLCommonUtil.openErrorWithDetail(SMLMessages.errorSavingTitle, SMLMessages.errorSaving0, e);
        }
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void markDirty() {
        this.dirty = true;
    }
}

