/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLConstants;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.export.ExportException;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ModelUnitFile;
import org.eclipse.osgi.util.NLS;

public class ExportToSMLIF {
    private static final String LANG_DESCRIPTION = "langDescription";
    private static final String LANG_NAME = "langName";
    private static final String SMLIF_NAMESPACE = "smlif";
    protected StringBuffer smlifFileBuffer = new StringBuffer();
    protected String rootFileName = "";
    protected String rootFilePath = "";
    protected StringBuffer definitions = new StringBuffer();
    protected StringBuffer instances = new StringBuffer();
    protected StringBuffer ruleBindingsBuffer = new StringBuffer();
    protected final String nl = "\n";
    protected final String tab = "\t";

    protected void buildMetadata(String modelName, String baseURI, String version, String displayName, String modelDescription) {
        this.smlifFileBuffer.append(SMLConstants.smlifStart).append("\n").append("\t").append("\t").append(SMLCommonUtil.beginTagFor(SMLIF_NAMESPACE, "name")).append(modelName).append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "name")).append("\n").append("\t").append("\t");
        if (!"".equals(version)) {
            this.smlifFileBuffer.append("\n").append("\t").append("\t").append(SMLCommonUtil.beginTagFor(SMLIF_NAMESPACE, "version")).append(version).append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "version"));
        }
        if (!"".equals(displayName)) {
            this.smlifFileBuffer.append("\n").append("\t").append("\t").append(ExportToSMLIF.beginTagIntroWithLocID("displayName")).append(baseURI).append("/").append(LANG_NAME).append("\"").append(">").append(displayName).append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "displayName"));
        }
        this.smlifFileBuffer.append("\n").append("\t").append("\t").append(SMLCommonUtil.beginTagFor(SMLIF_NAMESPACE, "baseURI")).append(baseURI).append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "baseURI")).append("\n").append("\t").append("\t").append(ExportToSMLIF.beginTagIntroWithLocID("description")).append(baseURI).append("/").append(LANG_DESCRIPTION).append("\"").append(">").append("\n").append("\t").append("\t").append("\t").append(modelDescription).append("\n").append("\t").append("\t").append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "description")).append("\n").append("\t").append(SMLCommonUtil.endTagFor(SMLIF_NAMESPACE, "identity")).append("\n");
    }

    protected static String beginTagIntroWithLocID(String tagName) {
        return "<smlif:" + tagName + " " + "locid" + "=" + "\"";
    }

    protected void createDirectoryStructureFor(File smlifFile) throws ExportException {
        boolean mkdirsResult = false;
        if (!smlifFile.getParentFile().exists() && !(mkdirsResult = smlifFile.getParentFile().mkdirs())) {
            throw new ExportException(NLS.bind((String)SMLMessages.exportErrorCouldNotCreateDirectoryStructure, (Object)smlifFile.getName()));
        }
    }

    protected boolean fileExistsAndIsReadable(File file) throws ExportException {
        String name = file.getName();
        if (!file.exists()) {
            throw new ExportException(NLS.bind((String)SMLMessages.exportErrorFileNotFound, (Object)name));
        }
        if (!file.canRead()) {
            throw new ExportException(NLS.bind((String)SMLMessages.exportErrorFileNotReadable, (Object)name));
        }
        return true;
    }

    protected void addFileToDefinitionsAndInstances(ModelUnitFile file) {
        String name = file.getFileName().trim();
        if (name == null) {
            return;
        }
        if (file.isDefinition()) {
            if (this.definitions.length() == 0) {
                this.definitions.append(SMLConstants.definitionsStart);
            }
            this.addFileToSection(file, this.definitions);
        } else if (file.isInstance()) {
            if (this.instances.length() == 0) {
                this.instances.append(SMLConstants.instancesStart);
            }
            this.addFileToSection(file, this.instances);
        }
    }

    protected void addFileToSection(ModelUnitFile file, StringBuffer sectionBuffer) {
        sectionBuffer.append(this.getFileAlias(file));
        sectionBuffer.append(this.getFileContent(file));
        sectionBuffer.append(SMLConstants.docDataEnd);
    }

    protected StringBuffer getFileAlias(ModelUnitFile file) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(SMLConstants.docAliasesStart);
        if (file.getAliases().isEmpty()) {
            String name = file.getFile().getFullPath().toPortableString();
            if (name.startsWith(this.rootFilePath)) {
                name = name.substring(this.rootFilePath.length());
            }
            this.appendAliasToBuffer(name, buffer);
        } else {
            ArrayList aliases = file.getAliases();
            for (String alias : aliases) {
                this.appendAliasToBuffer(alias, buffer);
            }
        }
        buffer.append(SMLConstants.docAliasesEnd);
        return buffer;
    }

    protected void appendAliasToBuffer(String alias, StringBuffer buffer) {
        buffer.append(SMLConstants.docAliasStart).append(alias).append(SMLConstants.docAliasEnd);
    }

    protected StringBuffer getFileContent(ModelUnitFile modelUnitFile) {
        StringBuffer result;
        block17: {
            result = new StringBuffer();
            result.append("\n").append("\t");
            BufferedReader reader = null;
            try {
                try {
                    File file = new File(modelUnitFile.getFile().getLocation().toOSString());
                    reader = new LineNumberReader(new FileReader(file));
                    String line = ((LineNumberReader)reader).readLine();
                    while (line != null) {
                        int idx = line.indexOf("?>");
                        if (idx != -1) {
                            result.append(line.substring(idx + 2));
                        } else {
                            result.append(line).append("\n");
                        }
                        line = ((LineNumberReader)reader).readLine();
                    }
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        result.append("\t").append("\n");
        return result;
    }

    public boolean exportFromFiles(Iterator modelUnits, Map ruleBindings, String smlIFFileName, String modelName, String baseURI, String version, String displayName, String modelDescription) throws ExportException {
        File smlifFile = new File(smlIFFileName);
        this.rootFileName = smlifFile.getName();
        modelName = "".equals(modelName) ? this.rootFileName : modelName;
        Path path = new Path("/");
        this.rootFilePath = path.toPortableString();
        this.buildMetadata(modelName, baseURI, version, displayName, modelDescription);
        this.buildRuleBindings(ruleBindings);
        while (modelUnits.hasNext()) {
            ModelUnitFile modelUnitFile = (ModelUnitFile)modelUnits.next();
            String filePath = modelUnitFile.getFile().getLocation().toOSString();
            File file = new File(filePath);
            if (!this.fileExistsAndIsReadable(file)) continue;
            if (file.isDirectory()) {
                throw new ExportException(NLS.bind((String)SMLMessages.exportErrorNameShouldNotBeDirectory, (Object)filePath), null);
            }
            this.addFileToDefinitionsAndInstances(modelUnitFile);
        }
        this.appendDefinitionsAndInstances();
        this.deleteFileFromWorkspace(smlIFFileName);
        this.createDirectoryStructureFor(smlifFile);
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(smlifFile), "UTF-8"));
            writer.print(this.smlifFileBuffer.toString());
            writer.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(smlIFFileName));
            if (file != null) {
                file.refreshLocal(1, null);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return true;
    }

    protected void buildRuleBindings(Map ruleBindingsMap) {
        if (ruleBindingsMap == null || ruleBindingsMap.isEmpty()) {
            return;
        }
        this.ruleBindingsBuffer.append(SMLConstants.ruleBindingsStart);
        for (String docAlias : ruleBindingsMap.keySet()) {
            String ruleAlias = (String)ruleBindingsMap.get(docAlias);
            this.ruleBindingsBuffer.append(SMLConstants.ruleBindingStart).append(docAlias).append(SMLConstants.ruleBindingMiddle).append(ruleAlias).append(SMLConstants.ruleBindingEnd);
        }
        this.ruleBindingsBuffer.append(SMLConstants.ruleBindingsEnd);
    }

    protected IFile deleteFileFromWorkspace(String smlIFFileName) throws ExportException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(smlIFFileName));
        try {
            if (file != null) {
                file.delete(true, null);
            }
        }
        catch (CoreException e) {
            throw new ExportException(NLS.bind((String)SMLMessages.exportErrorCannotDeleteWorkspaceFile, (Object)file.getProjectRelativePath()), e);
        }
        return file;
    }

    protected void appendDefinitionsAndInstances() {
        if (this.hasRuleBindings()) {
            this.smlifFileBuffer.append("\n").append(this.ruleBindingsBuffer);
        }
        if (this.hasDefinitions()) {
            this.definitions.append(SMLConstants.definitionsEnd);
            this.smlifFileBuffer.append("\n").append(this.definitions);
        }
        if (this.hasInstances()) {
            this.instances.append(SMLConstants.instancesEnd);
            this.smlifFileBuffer.append("\n").append(this.instances);
        }
        this.smlifFileBuffer.append(SMLConstants.smlifEnd);
    }

    protected boolean hasRuleBindings() {
        return this.ruleBindingsBuffer.length() > 0;
    }

    protected boolean hasDefinitions() {
        return this.definitions.length() > 0;
    }

    protected boolean hasInstances() {
        return this.instances.length() > 0;
    }
}

