/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportResourceTreeContentProvider;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage2;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.MetadataFileHandler;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ModelUnitFile;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBinding;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportToSMLIFWizard
extends Wizard
implements IExportWizard,
ICheckStateListener {
    protected ExportToSMLIFWizardPage mainPage;
    protected ExportToSMLIFWizardPage2 page2;
    protected ExportToSMLIFWizardPage3 page3;
    protected IStructuredSelection selection;
    protected ArrayList ruleBindings = new ArrayList();
    protected HashMap selectedFiles = new HashMap();
    protected MetadataFileHandler metadataFileHandler;

    public void updateFromMetadata() {
        MetadataFileHandler metadataFileHandler = this.getMetadataFileHandler();
        if (metadataFileHandler == null) {
            return;
        }
        Iterator iter = metadataFileHandler.getDocAliases().keySet().iterator();
        HashMap<String, ModelUnitFile> aliasDocMap = new HashMap<String, ModelUnitFile>();
        while (iter.hasNext()) {
            String pathName = (String)iter.next();
            ArrayList aliases = (ArrayList)metadataFileHandler.getDocAliases().get(pathName);
            HashMap selectedFiles = this.getSelectedFiles();
            for (IFile file : selectedFiles.keySet()) {
                if (!file.getProjectRelativePath().toString().equals(pathName)) continue;
                ModelUnitFile muf = (ModelUnitFile)selectedFiles.get(file);
                muf.setAliasesIfEmpty(aliases);
                for (String alias : aliases) {
                    aliasDocMap.put(alias, muf);
                }
            }
        }
        for (String docAlias : metadataFileHandler.getRuleBindings().keySet()) {
            String ruleAlias = (String)metadataFileHandler.getRuleBindings().get(docAlias);
            ModelUnitFile doc = (ModelUnitFile)aliasDocMap.get(docAlias);
            if (doc == null) continue;
            RuleBinding binding = new RuleBinding(doc, docAlias, ruleAlias);
            if (this.getRuleBindings().indexOf(binding) != -1) continue;
            this.getRuleBindings().add(binding);
        }
    }

    public boolean performFinish() {
        return this.mainPage.doExport();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new ExportToSMLIFWizardPage(SMLMessages.exportWizardPageTitle, this.selection);
        this.mainPage.setDescription(SMLMessages.exportWizardFileInstruction);
        this.addPage((IWizardPage)this.mainPage);
        this.page2 = new ExportToSMLIFWizardPage2(SMLMessages.exportWizardPageTitle, this.selection);
        this.page2.setDescription(SMLMessages.exportWizardDescriptionPageTwo);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new ExportToSMLIFWizardPage3(SMLMessages.exportWizardPageTitle, this.selection);
        this.page3.setDescription(SMLMessages.exportWizardDescriptionPage3);
        this.addPage((IWizardPage)this.page3);
        this.setWindowTitle(SMLMessages.exportWizardTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public ExportToSMLIFWizardPage getMainPage() {
        return this.mainPage;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        IResource file = (IResource)event.getElement();
        if (event.getChecked()) {
            this.addFileToSelected(file);
        } else {
            this.removeFileFromSelected(file);
        }
        this.page2.updateDocumentList();
        this.page2.initDocumentIdentityFields();
        this.updateFromMetadata();
        this.page3.updateComboChoices();
        this.mainPage.updatePageComplete();
    }

    protected void addFileToSelected(IResource file) {
        if (file instanceof IContainer) {
            Object[] kids = ((ExportResourceTreeContentProvider)this.mainPage.getFileTree().getContentProvider()).getChildren(file);
            int i = 0;
            while (i < kids.length) {
                this.addFileToSelected((IResource)kids[i]);
                ++i;
            }
            return;
        }
        this.primAddFileToSelected(file);
    }

    protected void primAddFileToSelected(IResource file) {
        ModelUnitFile muf = (ModelUnitFile)this.selectedFiles.get(file);
        if (muf == null) {
            muf = new ModelUnitFile((IFile)file);
        }
        this.selectedFiles.put(file, muf);
    }

    protected void removeFileFromSelected(IResource file) {
        if (file instanceof IContainer) {
            Object[] kids = ((ExportResourceTreeContentProvider)this.mainPage.getFileTree().getContentProvider()).getChildren(file);
            int i = 0;
            while (i < kids.length) {
                this.removeFileFromSelected((IResource)kids[i]);
                ++i;
            }
            return;
        }
        this.primRemoveFileFromSelected(file);
    }

    protected void primRemoveFileFromSelected(IResource file) {
        if (this.selectedFiles.containsKey(file)) {
            this.selectedFiles.remove(file);
        }
    }

    public HashMap getSelectedFiles() {
        return this.selectedFiles;
    }

    protected void initMetadataFileHandler() {
        if (this.metadataFileHandler != null) {
            return;
        }
        ExportToSMLIFWizardPage mainPage = this.getMainPage();
        String projectName = mainPage.getProjectName();
        if (projectName == null) {
            return;
        }
        IFile metadataFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(String.valueOf('/') + projectName + '/' + ".smlif_meta"));
        if (!metadataFile.exists()) {
            return;
        }
        this.metadataFileHandler = new MetadataFileHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(metadataFile.getLocation().toOSString(), (DefaultHandler)this.metadataFileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    protected static Button createVerticalButtonPanelButton(Composite buttonComposite, String buttonText) {
        Button button = new Button(buttonComposite, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(256);
        buttonData.verticalAlignment = 1;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    protected static Composite createVerticalButtonPanel(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData buttonCompositeData = new GridData();
        buttonCompositeData.verticalAlignment = 4;
        buttonComposite.setLayoutData((Object)buttonCompositeData);
        return buttonComposite;
    }

    public MetadataFileHandler getMetadataFileHandler() {
        if (this.metadataFileHandler == null) {
            this.initMetadataFileHandler();
        }
        return this.metadataFileHandler;
    }

    public ArrayList getRuleBindings() {
        return this.ruleBindings;
    }
}

