/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.importing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.importing.ImportException;
import org.eclipse.cosmos.rm.smlif.internal.importing.ModelUnit;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SMLIFFileHandler
extends DefaultHandler {
    private boolean buildingModelUnit;
    private ModelUnit currentModel;
    private boolean inData = false;
    private boolean inDefinitions = false;
    private List modelUnits = new ArrayList();
    private StringBuffer currentAliasBuffer = new StringBuffer();
    private HashMap ruleBindings = new HashMap();
    private boolean inAlias = false;
    private String baseURI;
    private boolean inBaseURI = false;
    private StringBuffer baseURIBuffer = new StringBuffer();
    private boolean inDescription = false;
    private boolean inName = false;
    private StringBuffer nameBuffer = new StringBuffer();
    private String name;
    private String description;
    private StringBuffer descriptionBuffer = new StringBuffer();
    private boolean inDisplayName = false;
    private String displayName;
    private StringBuffer displayNameBuffer = new StringBuffer();
    private boolean inVersion = false;
    private StringBuffer versionBuffer = new StringBuffer();
    private String version;

    public void characters(char[] ch, int start, int length) throws SAXException {
        String elementData = new String(ch, start, length);
        if (this.inData) {
            this.writeToModelUnitFile(elementData);
        }
        String trimmedElementData = elementData.trim();
        if (this.inAlias) {
            this.currentAliasBuffer.append(trimmedElementData);
        }
        if (this.inBaseURI) {
            this.baseURIBuffer.append(trimmedElementData);
        }
        if (this.inName) {
            this.nameBuffer.append(trimmedElementData);
        }
        if (this.inDisplayName) {
            this.displayNameBuffer.append(trimmedElementData);
        }
        if (this.inVersion) {
            this.versionBuffer.append(trimmedElementData);
        }
        if (this.inDescription) {
            this.descriptionBuffer.append(elementData);
        }
        super.characters(ch, start, length);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("definitions".equals(localName)) {
            this.inDefinitions = false;
        }
        if ("data".equals(localName)) {
            this.inData = false;
            this.currentModel.stop();
            this.modelUnits.add(this.currentModel);
            this.currentModel = null;
        }
        if ("locator".equals(localName) && this.currentModel != null) {
            this.modelUnits.add(this.currentModel);
            this.currentModel = null;
        }
        if ("baseURI".equals(localName)) {
            this.inBaseURI = false;
            this.baseURI = this.baseURIBuffer.toString().trim();
            this.baseURIBuffer = new StringBuffer();
        }
        if ("name".equals(localName)) {
            this.inName = false;
            this.name = this.nameBuffer.toString().trim();
            this.nameBuffer = new StringBuffer();
        }
        if ("displayName".equals(localName)) {
            this.inDisplayName = false;
            this.displayName = this.displayNameBuffer.toString().trim();
            this.displayNameBuffer = new StringBuffer();
        }
        if ("version".equals(localName)) {
            this.inVersion = false;
            this.version = this.versionBuffer.toString().trim();
            this.versionBuffer = new StringBuffer();
        }
        if ("description".equals(localName)) {
            this.inDescription = false;
            this.description = this.descriptionBuffer.toString();
            this.descriptionBuffer = new StringBuffer();
        }
        if ("alias".equals(localName)) {
            this.inAlias = false;
            this.currentModel.addAlias(this.currentAliasBuffer.toString().trim());
            this.currentAliasBuffer = new StringBuffer();
        }
        if (this.inData) {
            this.writeToModelUnitFile("</" + qName + ">");
        }
        super.endElement(uri, localName, qName);
    }

    public String getModelLocation() {
        if (this.baseURI == null) {
            return "";
        }
        String result = this.baseURI;
        if (result.startsWith("http://")) {
            int nextSlash = (result = result.substring("http://".length())).indexOf(47);
            result = nextSlash == -1 ? "" : String.valueOf(result.substring(nextSlash)) + File.separatorChar;
        }
        return result;
    }

    public List getModelUnits() {
        return this.modelUnits;
    }

    public boolean inModelUnit() {
        return this.buildingModelUnit;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ruleBinding".equals(localName)) {
            String docAlias = attributes.getValue("documentAlias");
            String ruleAlias = attributes.getValue("ruleAlias");
            if (docAlias != null && ruleAlias != null) {
                this.ruleBindings.put(docAlias, ruleAlias);
            }
        }
        if ("definitions".equals(localName)) {
            this.inDefinitions = true;
        }
        if ("baseURI".equals(localName)) {
            this.inBaseURI = true;
        }
        if ("name".equals(localName)) {
            this.inName = true;
        }
        if ("displayName".equals(localName)) {
            this.inDisplayName = true;
        }
        if ("version".equals(localName)) {
            this.inVersion = true;
        }
        if ("description".equals(localName)) {
            this.inDescription = true;
        }
        if ("document".equals(localName)) {
            this.currentModel = new ModelUnit(this.inDefinitions ? 0 : 1);
            this.currentModel.start();
        }
        if ("locator".equals(localName)) {
            String remoteDocUrlString = attributes.getValue("http://www.w3.org/1999/xlink", "href");
            URL remoteDocUrl = null;
            try {
                remoteDocUrl = new URL(remoteDocUrlString);
            }
            catch (MalformedURLException malformedURLException) {
                this.currentModel = null;
                throw new ImportException(NLS.bind((String)SMLMessages.importErrorInvalidLocatorURL, (Object)remoteDocUrlString));
            }
            String localFileName = remoteDocUrl.getFile();
            this.currentModel.setFileName(localFileName);
            try {
                this.retrieveRemoteDocument(remoteDocUrlString);
            }
            catch (SMLValidatorUtil.RemoteRetrievalException remoteRetrievalException) {
                this.currentModel = null;
                throw new ImportException(NLS.bind((String)SMLMessages.importErrorMissingFileAtLocatorURL, (Object)remoteDocUrlString));
            }
        }
        if ("alias".equals(localName)) {
            this.inAlias = true;
        }
        if (this.inData) {
            this.buildingModelUnit = true;
            this.writeToModelUnitFile("<" + qName);
            if (attributes != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    String aName = attributes.getQName(i);
                    this.writeToModelUnitFile(" ");
                    this.writeToModelUnitFile(String.valueOf(aName) + "=\"" + attributes.getValue(i) + "\"");
                    ++i;
                }
            }
            this.writeToModelUnitFile(">");
        }
        if ("data".equals(localName)) {
            this.inData = true;
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private void retrieveRemoteDocument(String remoteDocUrlString) throws SMLValidatorUtil.RemoteRetrievalException {
        IOException exception = null;
        try {
            String line;
            URL locator = new URL(remoteDocUrlString);
            InputStream stream = locator.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                this.currentModel.appendToContents(String.valueOf(line) + "\n");
            }
            reader.close();
            return;
        }
        catch (MalformedURLException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        throw new SMLValidatorUtil.RemoteRetrievalException((Exception)exception);
    }

    private void writeToModelUnitFile(String string) {
        this.currentModel.appendToContents(string);
    }

    public HashMap getRuleBindings() {
        return this.ruleBindings;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getVersion() {
        return this.version;
    }
}

