/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.artifacts;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementNode;

public class ElementTypeMap {
    private Map types = new Hashtable();

    public void addElementDeclaration(String uri, String name, String type) {
        ElementNode node = new ElementNode();
        node.setUri(uri);
        node.setName(name);
        node.setType(type);
        this.addElementDeclaration(node);
    }

    public void addElementDeclaration(ElementNode elementNode) {
        String type;
        String name;
        String uri = elementNode.getUri();
        if (uri == null || (name = elementNode.getName()) == null || (type = elementNode.getType()) == null) {
            return;
        }
        Hashtable<String, String> elementTypes = (Hashtable<String, String>)this.types.get(uri);
        if (elementTypes == null) {
            elementTypes = new Hashtable<String, String>();
            this.types.put(uri, elementTypes);
        }
        elementTypes.put(name, type);
    }

    public String getType(ElementNode elementNode) {
        return this.getType(elementNode.getUri(), elementNode.getName());
    }

    public String getType(String uri, String name) {
        Map elementTypes = (Map)this.types.get(uri);
        return elementTypes == null ? null : (String)elementTypes.get(name);
    }
}

