/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;

public abstract class AbstractValidationOutput
implements IValidationOutput {
    private IResource associatedResource;

    public void initialize(Map attributes) {
        String fileName = (String)attributes.get("validation.instance");
        if (fileName != null) {
            this.associatedResource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
            if (!this.associatedResource.exists()) {
                this.associatedResource = null;
            }
        }
    }

    public abstract void reportMessage(ValidationMessage var1);

    public void reportError(String message) {
        this.reportError(0, message);
    }

    public void reportError(int lineNumber, String message) {
        this.reportMessage(2, lineNumber, message);
    }

    public void reportWarning(String message) {
        this.reportWarning(0, message);
    }

    public void reportWarning(int lineNumber, String message) {
        this.reportMessage(1, lineNumber, message);
    }

    public void reportInfo(String message) {
        this.reportInfo(0, message);
    }

    public void reportInfo(int lineNumber, String message) {
        this.reportMessage(0, lineNumber, message);
    }

    private void reportMessage(int severity, int lineNumber, String message) {
        ValidationMessage verificationMsg = new ValidationMessage();
        verificationMsg.setAttribute("attribute.severity", severity);
        verificationMsg.setAttribute("attribute.message", message);
        if (lineNumber > -1) {
            verificationMsg.setAttribute("attribute.line.number", lineNumber);
        }
        if (this.associatedResource != null) {
            verificationMsg.setAttribute("attribute.resource", this.associatedResource);
        }
        this.reportMessage(verificationMsg);
    }

    public void close() {
    }

    public static class ValidationMessage {
        public static final int SEVERITY_INFO = 0;
        public static final int SEVERITY_WARNING = 1;
        public static final int SEVERITY_ERROR = 2;
        public static final String ATTRIBUTE_MESSAGE = "attribute.message";
        public static final String ATTRIBUTE_SEVERITY = "attribute.severity";
        public static final String ATTRIBUTE_RESOURCE = "attribute.resource";
        public static final String ATTRIBUTE_LINE_NUMBER = "attribute.line.number";
        public static final int NO_LINE_NUMBER = 0;
        private Map attributes = new Hashtable();

        public void setAttribute(String key, String value) {
            this.setAttribute(key, (Object)value);
        }

        public void setAttribute(String key, int value) {
            this.attributes.put(key, new Integer(value));
        }

        public void setAttribute(String key, boolean value) {
            this.attributes.put(key, new Boolean(value));
        }

        public void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public int getAttribute(String key, int defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return defaultValue;
        }

        public boolean getAttribute(String key, boolean defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return defaultValue;
        }

        public String getAttribute(String key, String defaultValue) {
            Object value = this.attributes.get(key);
            if (value instanceof String) {
                return (String)value;
            }
            return defaultValue;
        }

        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("MSG: " + this.getAttribute(ATTRIBUTE_MESSAGE, "<none>"));
            return buffer.toString();
        }
    }
}

