/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.FileOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class MarkerOutput
extends AbstractValidationOutput {
    public static final String SML_MARKER_ID = "org.eclipse.cosmos.rm.validation.smlMarker";
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private Map settings;
    private FileOutput backupOutput;
    private boolean errorReported = false;
    private static List markerList = new ArrayList();

    public void initialize(Map attributes) {
        super.initialize(attributes);
        this.settings = attributes;
        try {
            try {
                int i = 0;
                int markerCount = markerList.size();
                while (i < markerCount) {
                    ((IMarker)markerList.get(i)).delete();
                    ++i;
                }
            }
            catch (CoreException coreException) {
                markerList.clear();
            }
        }
        finally {
            markerList.clear();
        }
    }

    public void reportMessage(AbstractValidationOutput.ValidationMessage validationMessage) {
        try {
            Object rsc = validationMessage.getAttribute("attribute.resource");
            IResource resource = rsc instanceof IResource ? (IResource)rsc : this.workspaceRoot;
            int severity = validationMessage.getAttribute("attribute.severity", 0);
            IMarker marker = resource.createMarker(SML_MARKER_ID);
            marker.setAttribute("message", (Object)validationMessage.getAttribute("attribute.message", ""));
            marker.setAttribute("severity", severity == 2 ? 2 : (severity == 1 ? 1 : 0));
            int lineNumber = validationMessage.getAttribute("attribute.line.number", -1);
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            markerList.add(marker);
        }
        catch (CoreException coreException) {
            if (this.backupOutput == null) {
                this.backupOutput = new FileOutput();
                this.backupOutput.initialize(this.settings);
            }
            if (!this.errorReported) {
                this.errorReported = true;
                MessageDialog.openError((Shell)SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)SMLMessages.commonError, (String)NLS.bind((String)SMLMessages.errorMarkerOutput, (Object)this.backupOutput.getFilePath()));
            }
            this.backupOutput.reportMessage(validationMessage);
        }
    }
}

