/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.DerefXPathFunction;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SMLValidatorUtil {
    public static XPath xpath;

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = xpath = factory == null ? null : factory.newXPath();
        if (xpath != null) {
            xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

                public XPathFunction resolveFunction(QName functionName, int arity) {
                    if ("http://schemas.serviceml.org/sml/function/2006/07".equals(functionName.getNamespaceURI()) || "http://schemas.serviceml.org/smlfn/query/2006/07".equals(functionName.getNamespaceURI()) && "deref".equals(functionName.getLocalPart()) && arity == 1) {
                        return DerefXPathFunction.instance();
                    }
                    return null;
                }
            });
        }
    }

    public static Object retrieveDataStructure(String databuilderId) {
        IDataBuilder databuilder = DataBuilderRegistry.instance().getDataStructureBuilder(databuilderId);
        if (databuilder == null) {
            return null;
        }
        return databuilder.getDataStructure();
    }

    public static String removeLineBreaks(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int lastChar = 0;
        int i = 0;
        int strLength = str.length();
        while (i < strLength) {
            char currentChar = str.charAt(i);
            if (currentChar != '\r' && (lastChar != 10 || currentChar != '\t' && currentChar != ' ')) {
                if (currentChar != '\n') {
                    sb.append(currentChar);
                }
                lastChar = currentChar;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Map retrieveNestedMap(Map map, String key, boolean create) {
        Hashtable nestedMap = (Hashtable)map.get(key);
        if (create && nestedMap == null) {
            nestedMap = new Hashtable();
            map.put(key, nestedMap);
        }
        return nestedMap;
    }

    public static Node retrieveRemoteDocument(String uri) throws RemoteRetrievalException {
        Exception exception = null;
        try {
            URL locator = new URL(uri);
            InputStream stream = locator.openStream();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            Document document = docBuilderFactory.newDocumentBuilder().parse(stream);
            return document.getChildNodes() == null || document.getChildNodes().getLength() != 1 ? null : document.getChildNodes().item(0);
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        throw new RemoteRetrievalException(exception);
    }

    public static Document domParseDocument(InputStream resource, boolean ignoreComments, boolean ignoreWhitespace) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(ignoreWhitespace);
        docBuilderFactory.setIgnoringComments(ignoreComments);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(resource);
    }

    public static Document domParseDocument(InputStream resource) throws ParserConfigurationException, SAXException, IOException {
        return SMLValidatorUtil.domParseDocument(resource, true, true);
    }

    public static int identifyDocumentType(IFile file) throws IOException, CoreException {
        InputStream fileInputStream = file.getContents();
        try {
            int type = 3;
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileInputStream, file.getName());
            int i = 0;
            if (i < types.length) {
            }
            int n = type;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void addElement(StringBuffer stringBuffer, int indent, String elementName, boolean close, boolean end) {
        if (stringBuffer == null) {
            return;
        }
        if (indent > 0) {
            SMLValidatorUtil.addIndent(stringBuffer, indent);
        }
        stringBuffer.append("<");
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(elementName);
        stringBuffer.append(end ? ">" + (close ? IValidationConstants.LINE_SEPARATOR : "") : "");
    }

    public static void addAttribute(StringBuffer stringBuffer, NamedNodeMap attributes, boolean close, boolean end) {
        int i = 0;
        int attCount = attributes.getLength();
        while (i < attCount) {
            Node currentAttribute = attributes.item(i);
            stringBuffer.append(" ");
            stringBuffer.append(currentAttribute.getNodeName());
            stringBuffer.append("=");
            stringBuffer.append("\"");
            stringBuffer.append(currentAttribute.getNodeValue());
            stringBuffer.append("\"");
            ++i;
        }
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(end ? ">" + (close ? IValidationConstants.LINE_SEPARATOR : "") : "");
    }

    public static void addIndent(StringBuffer stringBuffer, int indent) {
        int i = 0;
        while (i < indent) {
            stringBuffer.append("\t");
            ++i;
        }
    }

    public static boolean deleteFileTree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    SMLValidatorUtil.deleteFileTree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }

    public static Node[] retrieveChildElements(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                childElements.add(child);
            }
            ++i;
        }
        return childElements.toArray(new Node[childElements.size()]);
    }

    public static class RemoteRetrievalException
    extends Exception {
        private static final long serialVersionUID = 7633895444717500045L;

        public RemoteRetrievalException(String message) {
            super(message);
        }

        public RemoteRetrievalException(Exception cause) {
            super(cause);
        }
    }
}

