/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.IValidator;
import org.eclipse.cosmos.rm.validation.internal.core.IXMLValidator;
import org.eclipse.cosmos.rm.validation.internal.core.ValidationFactory;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DatastructureBuilderImpl
extends DefaultHandler
implements IValidator {
    private static final byte EVENT_CHARACTER = 0;
    private static final byte EVENT_START_DOCUMENT = 1;
    private static final byte EVENT_END_DOCUMENT = 2;
    private static final byte EVENT_START_PREFIX = 3;
    private static final byte EVENT_END_PREFIX = 4;
    private static final byte EVENT_IGNORABLE_WHITESPACE = 5;
    private static final byte EVENT_SKIPPED_ENTITY = 6;
    private static final byte EVENT_PROCESSING_INSTRUCTIONS = 8;
    private SAXParser saxParser;
    private IDataBuilder[] dataStructureBuilder;
    private AbstractValidationOutput validationLogger;
    private IXMLValidator xmlValidation;
    private String input;
    private boolean validateXML;
    private byte phase = (byte)2;
    private Locator locator;
    private boolean documentElementHit;
    private boolean smlIfInput;
    private boolean status = true;

    public void initialize(Map validationAttribute) {
        this.validationLogger = (AbstractValidationOutput)validationAttribute.get("validation.output");
        this.smlIfInput = !(validationAttribute.get("validation.input.type") instanceof String) || !"value.sml.unit".equals(validationAttribute.get("validation.input.type"));
        this.input = (String)validationAttribute.get("validation.instance");
        Object validationClass = validationAttribute.get("attribute.validation.xml");
        this.validateXML = true;
        if (validationClass == null) {
            this.validateXML = false;
        } else if (validationClass.equals("default.validation.xml")) {
            this.xmlValidation = null;
        } else {
            try {
                IValidator[] validation = ValidationFactory.createValidator(IXMLValidator.class, validationClass);
                this.xmlValidation = validation.length > 0 ? (IXMLValidator)validation[0] : null;
                this.xmlValidation.initialize(validationAttribute);
            }
            catch (InstantiationException instantiationException) {
                this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorInstantiating, validationClass));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorInstantiating, validationClass));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorClassNotFound, validationClass));
            }
        }
        this.setSchema((String)validationAttribute.get("validation.schema.smlif"));
    }

    protected void setSchema(String xsd) {
        try {
            if (xsd == null) {
                this.validateXML = false;
            }
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(this.validateXML);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", this.validateXML);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser newSaxParser = saxParserFactory.newSAXParser();
            if (xsd != null) {
                try {
                    newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", this.getClass().getClassLoader().getResourceAsStream(xsd));
                }
                catch (Exception exception) {
                    this.validationLogger.reportWarning(SMLMessages.errorUnsupportedSAXProperty0);
                    saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
                    newSaxParser = saxParserFactory.newSAXParser();
                }
            }
            this.saxParser = newSaxParser;
        }
        catch (ParserConfigurationException e) {
            this.fatalError(e);
        }
        catch (SAXNotRecognizedException e) {
            this.fatalError(NLS.bind((String)SMLMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXNotSupportedException e) {
            this.fatalError(NLS.bind((String)SMLMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXException e) {
            this.fatalError(e);
        }
    }

    public void error(SAXParseException exception) {
        this.status = false;
        this.validationLogger.reportError(String.valueOf(exception.getLocalizedMessage()) + SMLMessages.commonLine + exception.getLineNumber() + SMLMessages.commonColumn + exception.getColumnNumber());
    }

    protected void fatalError(Exception exception) {
        this.status = false;
        this.validationLogger.reportError(exception.getLocalizedMessage());
    }

    protected void fatalError(String errorMessage) {
        this.status = false;
        this.validationLogger.reportError(errorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate() {
        Throwable exception = null;
        String currentDocument = null;
        try {
            this.retrieveBuilders();
            if (this.smlIfInput) {
                currentDocument = this.input;
                this.saxParser.parse(new InputSource(new FileInputStream(new File(currentDocument))), (DefaultHandler)this);
                return true;
            }
            StringTokenizer inputs = new StringTokenizer(this.input, ",");
            ArrayList instanceList = new ArrayList();
            IdentityDataBuilder.SMLIFIdentity identity = (IdentityDataBuilder.SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            if (identity != null) {
                identity.setBaseURI("");
            }
            this.phase = 1;
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true, false, true);
            while (inputs.hasMoreTokens()) {
                currentDocument = inputs.nextToken();
                IResource resource = this.retrieveResource(currentDocument);
                if (resource == null) {
                    return false;
                }
                this.traverseRecursively(instanceList, resource, true, "");
            }
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true, false, false);
            this.phase = (byte)16;
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false, true, true);
            int i = 0;
            int instanceCount = instanceList.size();
            while (i < instanceCount) {
                this.traverseRecursively(instanceList, (IResource)instanceList.get(i), false, "");
                ++i;
            }
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false, true, false);
            return true;
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (CoreException e) {
            exception = e;
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        if (exception == null) return false;
        this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorParsingDocument, (Object)currentDocument));
        this.fatalError((Exception)exception);
        return false;
    }

    private void traverseRecursively(List instanceList, IResource currentResource, boolean isDefinition, String parentFolder) throws CoreException, IOException, SAXException, ParserConfigurationException {
        if (currentResource instanceof IContainer) {
            IResource[] children = ((IContainer)currentResource).members();
            parentFolder = String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + currentResource.getName();
            int i = 0;
            while (i < children.length) {
                this.traverseRecursively(instanceList, children[i], isDefinition, parentFolder);
                ++i;
            }
        } else if (currentResource instanceof IFile) {
            int type = SMLValidatorUtil.identifyDocumentType((IFile)currentResource);
            switch (type) {
                case 0: {
                    this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "document", "document", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
                    this.processData((IFile)currentResource);
                    this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "document", "document", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
                    break;
                }
                case 1: {
                    if (isDefinition) {
                        instanceList.add(currentResource);
                        return;
                    }
                    this.fireNotifications("http://schemas.serviceml.org/smlif/2007/02", new String[]{"document", "docinfo", "aliases", "alias"}, true);
                    char[] path = (String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + currentResource.getName()).toCharArray();
                    this.characters(path, 0, path.length);
                    this.fireNotifications("http://schemas.serviceml.org/smlif/2007/02", new String[]{"alias", "aliases", "docinfo"}, false);
                    this.processData((IFile)currentResource);
                    this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "document", "document", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
                }
            }
        }
    }

    private void processData(IFile file) throws SAXException, ParserConfigurationException, IOException, CoreException {
        InputStream fileInputStream = file.getContents();
        try {
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
            Document data = SMLValidatorUtil.domParseDocument(fileInputStream);
            NodeList childNodes = data.getChildNodes();
            if (childNodes != null && childNodes.getLength() > 0) {
                this.walkDocument(childNodes.item(0));
            }
            this.elementNotification("http://schemas.serviceml.org/smlif/2007/02", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void fireNotifications(String uri, String[] elements, boolean open) throws SAXException {
        int i = 0;
        while (i < elements.length) {
            this.elementNotification(uri, elements[i], elements[i], IValidationConstants.EMPTY_ATTRIBUTES, false, false, open);
            ++i;
        }
    }

    private IResource retrieveResource(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile currentResource = root.getFile((IPath)new Path(path));
        Object object = currentResource = currentResource.exists() ? currentResource : root.getFolder((IPath)new Path(path));
        if (!currentResource.exists()) {
            this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorMissingFile, (Object)path));
            return null;
        }
        return currentResource;
    }

    private void retrieveBuilders() {
        if (this.dataStructureBuilder == null) {
            Collection dataBuilders = DataBuilderRegistry.instance().getDataStructureBuilders();
            this.dataStructureBuilder = new IDataBuilder[dataBuilders.size()];
            dataBuilders.toArray(this.dataStructureBuilder);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean startDefinitionsPhase = false;
        boolean startInstancesPhase = false;
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if (this.phase != 16) {
                if (this.phase != 1 && "definitions".equals(localName)) {
                    this.phase = 1;
                    startDefinitionsPhase = true;
                } else if ("instances".equals(localName)) {
                    this.phase = (byte)16;
                    startInstancesPhase = true;
                }
            }
            if (this.phase == 1 || this.phase == 16) {
                if ("document".equals(localName)) {
                    this.documentElementHit = true;
                } else if (this.documentElementHit && "locator".equals(localName)) {
                    this.retrieveRemoteDocument(attributes);
                }
            }
        }
        this.elementNotification(uri, localName, qName, attributes, startDefinitionsPhase, startInstancesPhase, true);
    }

    private void retrieveRemoteDocument(Attributes attributes) throws SAXException {
        String href = attributes.getValue("http://www.w3.org/1999/xlink", "href");
        Node node = null;
        SMLValidatorUtil.RemoteRetrievalException exception = null;
        try {
            node = SMLValidatorUtil.retrieveRemoteDocument(href);
            Element dataNode = node.getOwnerDocument().createElementNS("http://schemas.serviceml.org/smlif/2007/02", "data");
            dataNode.appendChild(node);
            node = dataNode;
        }
        catch (SMLValidatorUtil.RemoteRetrievalException e) {
            exception = e;
        }
        if (exception != null || node == null) {
            this.validationLogger.reportError(NLS.bind((String)SMLMessages.errorMissingDocument, (Object)String.valueOf(this.locator.getLineNumber())));
            throw new SAXException(exception);
        }
        this.walkDocument(node);
    }

    private void walkDocument(Node node) throws SAXException {
        Attributes atts = this.toAttributes(node.getAttributes());
        this.domNotification(node, atts, true);
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            this.walkDocument(children.item(i));
            ++i;
        }
        this.domNotification(node, atts, false);
    }

    private void domNotification(Node node, Attributes atts, boolean start) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                this.elementNotification(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), atts, false, false, start);
                break;
            }
            case 3: {
                String value;
                if (!start || (value = node.getNodeValue()) == null) break;
                this.characters(value.toCharArray(), 0, value.length());
            }
        }
    }

    private Attributes toAttributes(NamedNodeMap attributes) {
        AttributeWrapper attributeWrapper = new AttributeWrapper(attributes);
        return attributeWrapper;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean endDefinitionsPhase = false;
        boolean endInstancesPhase = false;
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if (this.phase == 1 && "definitions".equals(localName)) {
                this.phase = 0;
                endDefinitionsPhase = true;
            } else if (this.phase == 16 && "instances".equals(localName)) {
                this.phase = 0;
                endInstancesPhase = true;
            }
            if ((this.phase == 1 || this.phase == 16) && "document".equals(localName)) {
                this.documentElementHit = false;
            }
        }
        this.elementNotification(uri, localName, qName, null, endDefinitionsPhase, endInstancesPhase, false);
    }

    private void elementNotification(String uri, String localName, String qName, Attributes attributes, boolean definitionPhase, boolean instancePhase, boolean start) throws SAXException {
        int i = 0;
        while (i < this.dataStructureBuilder.length) {
            IDataBuilder dataBuilder = this.dataStructureBuilder[i];
            if (definitionPhase) {
                if (start) {
                    dataBuilder.startDefinitions();
                } else {
                    dataBuilder.endDefinitions();
                }
            }
            if (instancePhase) {
                if (start) {
                    dataBuilder.startInstances();
                } else {
                    dataBuilder.endInstances();
                }
            }
            if (dataBuilder.getPhase() == 3 || dataBuilder.getPhase() == this.phase || dataBuilder.getPhase() == 0 && (this.phase == 16 || this.phase == 1)) {
                if (start) {
                    dataBuilder.startElement(uri, localName, qName, attributes);
                } else {
                    dataBuilder.endElement(uri, localName, qName);
                }
            }
            ++i;
        }
        if (this.xmlValidation != null) {
            if (start) {
                this.xmlValidation.startElement(uri, localName, qName, attributes);
            } else {
                this.xmlValidation.endElement(uri, localName, qName);
            }
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.eventNotification((byte)0, new Object[]{ch, new Integer(start), new Integer(len)});
    }

    public void endDocument() throws SAXException {
        this.eventNotification((byte)2, null);
    }

    public void endPrefixMapping(String arg0) throws SAXException {
        this.eventNotification((byte)4, new Object[]{arg0});
    }

    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        super.unparsedEntityDecl(arg0, arg1, arg2, arg3);
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.eventNotification((byte)5, new Object[]{arg0, new Integer(arg1), new Integer(arg2)});
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.eventNotification((byte)8, new Object[]{arg0, arg1});
    }

    public void skippedEntity(String arg0) throws SAXException {
        this.eventNotification((byte)6, new Object[]{arg0});
    }

    public void startDocument() throws SAXException {
        this.eventNotification((byte)1, null);
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.eventNotification((byte)3, new Object[]{arg0, arg1});
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.retrieveBuilders();
        int i = 0;
        while (i < this.dataStructureBuilder.length) {
            this.dataStructureBuilder[i].setDocumentLocator(locator);
            ++i;
        }
        if (this.xmlValidation != null) {
            this.xmlValidation.setDocumentLocator(locator);
        }
    }

    private void eventNotification(byte event, Object[] arguments) throws SAXException {
        this.retrieveBuilders();
        int i = 0;
        while (i < this.dataStructureBuilder.length) {
            if (this.dataStructureBuilder[i].getPhase() == 3 || this.dataStructureBuilder[i].getPhase() == this.phase || this.dataStructureBuilder[i].getPhase() == 0 && (this.phase == 16 || this.phase == 1)) {
                this.handleEvent(this.dataStructureBuilder[i], event, arguments);
            }
            ++i;
        }
        if (this.xmlValidation != null) {
            this.handleEvent(this.xmlValidation, event, arguments);
        }
    }

    private void handleEvent(ContentHandler contentHandler, byte event, Object[] arguments) throws SAXException {
        switch (event) {
            case 0: {
                contentHandler.characters((char[])arguments[0], (Integer)arguments[1], (Integer)arguments[2]);
                break;
            }
            case 1: {
                contentHandler.startDocument();
                break;
            }
            case 2: {
                contentHandler.endDocument();
                break;
            }
            case 3: {
                contentHandler.startPrefixMapping((String)arguments[0], (String)arguments[1]);
                break;
            }
            case 4: {
                contentHandler.endPrefixMapping((String)arguments[0]);
                break;
            }
            case 5: {
                contentHandler.ignorableWhitespace((char[])arguments[0], (Integer)arguments[1], (Integer)arguments[2]);
                break;
            }
            case 6: {
                contentHandler.skippedEntity((String)arguments[0]);
                break;
            }
            case 8: {
                contentHandler.processingInstruction((String)arguments[0], (String)arguments[1]);
            }
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    private class AttributeWrapper
    implements Attributes {
        private NamedNodeMap attributes;
        private Map qNameInx;
        private Map uriInx;

        public AttributeWrapper(NamedNodeMap attributes) {
            this.attributes = attributes;
            this.qNameInx = new Hashtable();
            this.uriInx = new Hashtable();
            if (attributes == null) {
                return;
            }
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                Node att = attributes.item(i);
                Integer inx = new Integer(i);
                this.qNameInx.put(att.getNodeName(), inx);
                String key = att.getNamespaceURI() == null ? "" : att.getNamespaceURI();
                key = String.valueOf(key) + att.getLocalName();
                this.uriInx.put(key, inx);
                ++i;
            }
        }

        public int getIndex(String qName) {
            Integer inx = (Integer)this.qNameInx.get(qName);
            return inx == null ? -1 : inx;
        }

        public int getIndex(String uri, String localName) {
            Integer inx = (Integer)this.uriInx.get(uri == null ? localName : String.valueOf(uri) + localName);
            return inx == null ? -1 : inx;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getLocalName(int index) {
            return this.attributes.item(index).getLocalName();
        }

        public String getQName(int index) {
            return this.attributes.item(index).getNodeName();
        }

        public String getType(int index) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getURI(int index) {
            return this.attributes.item(index).getNamespaceURI();
        }

        public String getValue(int index) {
            Node node = index >= 0 && index < this.attributes.getLength() ? this.attributes.item(index) : null;
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String qName) {
            Node node = this.attributes.getNamedItem(qName);
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String uri, String localName) {
            Node node = this.attributes.getNamedItemNS(uri, localName);
            return node == null ? null : node.getNodeValue();
        }
    }
}

