/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.FileOutput;
import org.eclipse.cosmos.rm.validation.internal.common.MarkerOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SystemOutput;
import org.eclipse.cosmos.rm.validation.internal.core.IValidator;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.AcyclicValidator;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.IdentityConstraintValidator;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.SchematronValidator;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.TargetValidator;

public class MainValidator {
    private static final String OPTION_XML = "-xml";
    private static final String OPTION_SML = "-sml";
    private static final String OPTION_SCHEMATRON = "-schematron";
    private static final String OPTION_FILE = "-output";
    private static final String SML_IF_SCHEMA = "validation-resources/smlif.xsd";
    private Map attributes = new Hashtable();

    public MainValidator() {
        this.setDefaultAttributes();
    }

    protected void setDefaultAttributes() {
        this.attributes.put("attribute.environment", "value.environment.standalone");
        this.attributes.put("attribute.validation.xml", "default.validation.xml");
        ArrayList<String> smlValidators = new ArrayList<String>();
        smlValidators.add(AcyclicValidator.class.getName());
        smlValidators.add(IdentityConstraintValidator.class.getName());
        smlValidators.add(TargetValidator.class.getName());
        smlValidators.add(SchematronValidator.class.getName());
        this.attributes.put("attribute.validation.sml", smlValidators);
        this.attributes.put("validation.schema.smlif", SML_IF_SCHEMA);
    }

    public void initialize(Map attributes) {
        for (String currentKey : attributes.keySet()) {
            this.setAttribute(currentKey, (String)attributes.get(currentKey));
        }
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    /*
     * Exception decompiling
     */
    public boolean start() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validate(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            if (validators[i] != null && !validators[i].validate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initValidators(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            if (validators[i] != null) {
                validators[i].initialize(this.attributes);
            }
            ++i;
        }
    }

    protected AbstractValidationOutput createValidationOutput() {
        String environment = (String)this.attributes.get("attribute.environment");
        AbstractValidationOutput validationOutput = null;
        validationOutput = "value.environment.eclipse".equals(environment) ? new MarkerOutput() : ("value.environment.standalone".equals(environment) ? new FileOutput() : new SystemOutput());
        ((AbstractValidationOutput)validationOutput).initialize(this.attributes);
        return validationOutput;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            MainValidator.printUsage();
            return;
        }
        int lastInx = -1;
        int currentInx = 0;
        MainValidator mainValidator = new MainValidator();
        try {
            while (lastInx != currentInx) {
                lastInx = currentInx;
                currentInx = MainValidator.processOption(mainValidator, args, currentInx);
            }
            if (currentInx != args.length - 1) {
                MainValidator.printUsage();
                return;
            }
            mainValidator.getAttributes().put("validation.instance", args[currentInx]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MainValidator.printUsage();
        }
        mainValidator.start();
    }

    private static int processOption(MainValidator mainValidator, String[] args, int inx) throws IllegalArgumentException {
        if (inx < 0 || inx >= args.length) {
            return inx;
        }
        String currentOption = args[inx];
        boolean xml = false;
        xml = OPTION_XML.equals(currentOption);
        if (xml || OPTION_SCHEMATRON.equals(currentOption)) {
            ++inx;
            inx = MainValidator.addAttribute(mainValidator, args, inx, xml ? "attribute.validation.xml" : "attribute.validation.schematron");
        } else if (OPTION_SML.equals(currentOption)) {
            ArrayList<String> smlValidator = new ArrayList<String>();
            while (++inx < args.length - 1 && !args[inx].startsWith("-")) {
                StringTokenizer st = new StringTokenizer(args[inx]);
                while (st.hasMoreTokens()) {
                    smlValidator.add(st.nextToken());
                }
            }
            if (smlValidator.isEmpty()) {
                throw new IllegalArgumentException();
            }
            mainValidator.getAttributes().put("attribute.validation.sml", smlValidator);
        } else if (OPTION_FILE.equals(currentOption)) {
            ++inx;
            inx = MainValidator.addAttribute(mainValidator, args, inx, "attribute.file.output");
        }
        return inx;
    }

    private static int addAttribute(MainValidator mainValidator, String[] args, int inx, String attribute) throws IllegalArgumentException {
        if (inx >= args.length || args[inx].startsWith("-")) {
            throw new IllegalArgumentException();
        }
        mainValidator.getAttributes().put(attribute, args[inx]);
        return inx + 1;
    }

    private static void printUsage() {
        System.err.println(SMLMessages.errorIllegalArguments);
    }
}

