/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class DocumentDOMBuilder
extends AbstractDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.XMLDefaultHandler";
    public static final String NO_ALIAS = "no_alias";
    private Document document;
    private Map domDocumentMap;
    private List documentsWithNoAlias;
    private Node rootElement;
    private Stack elementStack = new Stack();
    private List aliasesList;
    private String currentAlias;
    private boolean cdataStarted;
    private boolean aliasElementHit;
    private boolean documentElementHit;
    private boolean dataElementHit;
    private boolean instanceElementHit;

    public DocumentDOMBuilder() {
        this.domDocumentMap = new Hashtable();
        this.documentsWithNoAlias = new ArrayList();
        this.domDocumentMap.put(NO_ALIAS, this.documentsWithNoAlias);
        this.currentAlias = "";
        this.aliasesList = new ArrayList();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.dataElementHit) {
            if (this.document == null) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setIgnoringElementContentWhitespace(true);
                try {
                    this.document = factory.newDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this.setErrorMessage(SMLMessages.errorCreatingDocument);
                    this.setStructureValidity(false);
                    return;
                }
            }
            Element element = this.document.createElementNS(uri, qName);
            int i = 0;
            while (i < attributes.getLength()) {
                element.setAttribute(attributes.getQName(i), attributes.getValue(i));
                ++i;
            }
            if (this.rootElement == null) {
                this.rootElement = element;
            } else {
                ((Element)this.elementStack.peek()).appendChild(element);
            }
            this.elementStack.push(element);
        }
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if ("alias".equals(localName)) {
                this.aliasElementHit = true;
            } else if ("instances".equals(localName)) {
                this.instanceElementHit = true;
            } else if (this.instanceElementHit && "document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "data".equals(localName)) {
                this.dataElementHit = true;
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if ("http://schemas.serviceml.org/smlif/2007/02".equals(uri)) {
            if ("alias".equals(localName)) {
                if (this.currentAlias.length() > 0) {
                    this.aliasesList.add(this.currentAlias);
                }
                this.currentAlias = "";
                this.aliasElementHit = false;
            } else if (this.instanceElementHit && "instances".equals(localName)) {
                this.instanceElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
            } else if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
                if (this.rootElement != null) {
                    this.document.appendChild(this.rootElement);
                    if (this.aliasesList.size() <= 0) {
                        this.documentsWithNoAlias.add(this.rootElement);
                    }
                    int i = 0;
                    int aliasCount = this.aliasesList.size();
                    while (i < aliasCount) {
                        this.domDocumentMap.put(this.aliasesList.get(i), this.rootElement);
                        ++i;
                    }
                }
                this.aliasesList.clear();
                this.rootElement = null;
                this.document = null;
            }
        }
        if (this.dataElementHit) {
            this.elementStack.pop();
        }
    }

    public void characters(char[] characters, int start, int length) {
        if (this.aliasElementHit) {
            this.currentAlias = String.valueOf(this.currentAlias) + new String(characters, start, length);
        } else if (this.dataElementHit) {
            boolean isBufferEmpty;
            if (this.rootElement == null) {
                return;
            }
            String buffValue = new String(characters, start, length);
            boolean isBufferJustWhiteSpace = "".equals(buffValue.trim());
            boolean bl = isBufferEmpty = buffValue.length() <= 0;
            if (this.cdataStarted && isBufferEmpty || !this.cdataStarted && isBufferJustWhiteSpace) {
                this.cdataStarted = false;
                return;
            }
            Text text = this.document.createTextNode(buffValue);
            this.cdataStarted = true;
            if (this.elementStack.size() <= 0) {
                this.rootElement.appendChild(text);
            } else {
                ((Node)this.elementStack.peek()).appendChild(text);
            }
        }
    }

    public Object getDataStructure() {
        return this.domDocumentMap;
    }

    public List getDocumentsWithNoAlias() {
        return this.documentsWithNoAlias;
    }

    public byte getPhase() {
        return 3;
    }
}

