/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.IReferenceExpression;
import org.w3c.dom.Node;

public class URIReference
implements IReferenceExpression {
    private URI base;
    private URI reference;
    private String documentReference;
    private boolean transformed;
    private Map aliases;

    public URIReference(String reference) throws URISyntaxException {
        if (reference == null) {
            throw new URISyntaxException(null, SMLMessages.errorReferenceNullURI);
        }
        reference = this.trim(reference);
        this.reference = new URI(reference);
    }

    private String trim(String str) {
        str = str.trim();
        str = str.replaceAll("\\n", "");
        str = str.replaceAll("\\r", "");
        return str;
    }

    public String getDocumentReference() throws URISyntaxException {
        if (this.documentReference == null) {
            String fragment = this.reference.getFragment();
            String referenceStr = this.reference.toString();
            int fragmentInx = -1;
            if (fragment != null && fragment.length() > 0 && (fragmentInx = referenceStr.indexOf(fragment)) > 0) {
                referenceStr = referenceStr.substring(0, fragmentInx - 1);
            }
            this.documentReference = referenceStr;
            if (!this.isDocumentEmbedded(referenceStr) && !this.isTransformed()) {
                this.documentReference = null;
                this.transform();
                return this.getDocumentReference();
            }
        }
        return this.documentReference;
    }

    public String getFragment() throws URISyntaxException {
        this.getDocumentReference();
        return this.reference == null ? null : this.reference.getFragment();
    }

    private boolean isDocumentEmbedded(String document) {
        if (this.aliases == null) {
            this.aliases = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
            Map map = this.aliases = this.aliases == null ? new Hashtable() : this.aliases;
        }
        return this.aliases.get(document) != null;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public void transform() throws URISyntaxException {
        String query;
        String path;
        String authority;
        String scheme;
        this.transformed = true;
        if (this.base == null) {
            String baseURI = IdentityDataBuilder.retrieveBaseURI();
            if (baseURI == null) {
                throw new URISyntaxException("", SMLMessages.errorBaseNullURI);
            }
            this.base = new URI(baseURI);
        }
        if (this.defined(this.reference.getScheme())) {
            scheme = this.reference.getScheme();
            authority = this.reference.getAuthority();
            path = this.reference.getPath();
            query = this.reference.getQuery();
        } else {
            if (this.defined(this.reference.getAuthority())) {
                authority = this.reference.getAuthority();
                path = this.reference.getPath();
                query = this.reference.getQuery();
            } else {
                if (!this.defined(this.reference.getPath())) {
                    path = this.base.getPath();
                    query = this.defined(this.reference.getQuery()) ? this.reference.getQuery() : this.base.getQuery();
                } else {
                    path = this.reference.getPath().startsWith("/") ? this.removeDotSegments(this.reference.getPath()) : this.removeDotSegments(this.mergePath(this.base, this.reference));
                    query = this.reference.getQuery();
                }
                authority = this.base.getAuthority();
            }
            scheme = this.base.getScheme();
        }
        String fragment = this.reference.getFragment();
        try {
            this.reference = new URI(scheme, authority, path, query, fragment);
        }
        catch (URISyntaxException uRISyntaxException) {}
    }

    private String mergePath(URI base, URI relative) {
        if (this.defined(base.getAuthority()) && !this.defined(base.getPath())) {
            return "/" + relative.getPath();
        }
        String basePath = base.getPath();
        int rightMostSlash = basePath.lastIndexOf("/");
        basePath = rightMostSlash > 0 ? basePath.substring(0, rightMostSlash + 1) : "";
        return String.valueOf(basePath) + relative.getPath();
    }

    private String removeDotSegments(String input) {
        String output = "";
        while (input.length() > 0) {
            int length;
            String matchedPrefix = this.findMatch(input, new String[]{"../", "./"}, new String[0]);
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[]{"/./"}, new String[]{"/."});
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                input = "/" + input;
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[]{"/../"}, new String[]{"/.."});
            if (matchedPrefix != null) {
                length = matchedPrefix.length();
                input = input.length() > length ? input.substring(length) : "";
                input = "/" + input;
                int inx = output.lastIndexOf("/");
                output = inx > 0 ? output.substring(0, inx) : "";
                continue;
            }
            matchedPrefix = this.findMatch(input, new String[0], new String[]{".", ".."});
            if (matchedPrefix != null) {
                input = "";
                continue;
            }
            int inx = input.indexOf("/");
            if (inx == 0) {
                output = String.valueOf(output) + "/";
                input = input.substring(1);
                inx = input.indexOf("/");
            }
            if (inx > 0) {
                output = String.valueOf(output) + input.substring(0, inx);
                input = input.substring(inx);
                continue;
            }
            output = String.valueOf(output) + input;
            input = "";
        }
        return output;
    }

    private String findMatch(String input, String[] prefix, String[] equalityCheck) {
        int i = 0;
        while (i < prefix.length) {
            if (input.startsWith(prefix[i])) {
                return prefix[i];
            }
            ++i;
        }
        i = 0;
        while (i < equalityCheck.length) {
            if (input.equals(equalityCheck[i])) {
                return equalityCheck[i];
            }
            ++i;
        }
        return null;
    }

    private boolean defined(String field) {
        return field != null && field.length() > 0;
    }

    public Node retrieveDocumentDOM() throws URISyntaxException, SMLValidatorUtil.RemoteRetrievalException {
        String document = this.getDocumentReference();
        String scheme = this.reference.getScheme();
        if (scheme == null) {
            return (Node)this.aliases.get(document);
        }
        return SMLValidatorUtil.retrieveRemoteDocument(this.reference.toString());
    }
}

