/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.reference;

import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.NamespaceContextBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.AbstractScheme;
import org.eclipse.cosmos.rm.validation.internal.reference.BadExpressionException;
import org.eclipse.osgi.util.NLS;

public class XmlnsScheme
extends AbstractScheme {
    public static final String SCHEME = "xmlns";

    public Object evaluate(Object context) throws BadExpressionException {
        String uri;
        NamespaceContextBuilder.MappedNamespaceContext namespaceContext = (NamespaceContextBuilder.MappedNamespaceContext)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.NamespaceContextBuilder");
        if (namespaceContext == null) {
            throw new BadExpressionException(SMLMessages.errorMissingNamespace);
        }
        String expression = this.getExpression();
        int equalSignInx = -1;
        if (expression == null || (equalSignInx = expression.indexOf(61)) <= 0) {
            throw new BadExpressionException(NLS.bind((String)SMLMessages.errorBadNSExpression, (Object)expression));
        }
        String prefix = expression.substring(0, equalSignInx);
        String string = uri = equalSignInx + 1 >= expression.length() ? null : expression.substring(equalSignInx + 1);
        if (prefix == null || (prefix = prefix.trim()).length() <= 0) {
            throw new BadExpressionException(NLS.bind((String)SMLMessages.errorBadPrefix, (Object)expression));
        }
        if (uri == null || (uri = uri.trim()).length() <= 0) {
            throw new BadExpressionException(NLS.bind((String)SMLMessages.errorBadURI, (Object)expression));
        }
        namespaceContext.addEntry(prefix, uri);
        return context;
    }

    public String getType() {
        return SCHEME;
    }
}

