/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.DocumentNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementEdge;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AcyclicDataTypesList;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ReferenceGraphDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.ValidationMessages;
import org.eclipse.osgi.util.NLS;

public class AcyclicValidator
extends AbstractSMLValidator {
    private Map nodeOrder;
    private Map treeForest = new Hashtable();
    private List cycle;

    public void initialize(Map validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry databuilderRegistry = DataBuilderRegistry.instance();
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList", new AcyclicDataTypesList());
        databuilderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder", new ReferenceGraphDataBuilder());
    }

    public boolean validate() {
        Iterator acyclicTypes = (Iterator)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.AcyclicDataTypesList");
        Map referenceGraph = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder");
        Map inheritanceMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        IDataBuilder inheritanceDataBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        IValidationOutput output = this.getValidationOutput();
        if (referenceGraph == null || acyclicTypes == null || inheritanceMap == null) {
            output.reportError(ValidationMessages.acyclicUnknown);
            output.reportError(referenceGraph == null ? ValidationMessages.acyclicNoReferenceGraph : (acyclicTypes == null ? ValidationMessages.acyclicNoAcyclicTypeList : ValidationMessages.acyclicNoInheritanceMap));
            return false;
        }
        if (!inheritanceDataBuilder.isStructureValid()) {
            output.reportError(inheritanceDataBuilder.getErrorMessage());
            return false;
        }
        String[] graphNodes = new String[referenceGraph.size()];
        int counter = 0;
        Iterator iterator = referenceGraph.keySet().iterator();
        while (iterator.hasNext()) {
            graphNodes[counter++] = (String)iterator.next();
        }
        Edge backEdge = null;
        this.cycle = null;
        Iterator iter = acyclicTypes;
        while (iter.hasNext() && backEdge == null) {
            TypeNode elementType = (TypeNode)iter.next();
            this.treeForest.clear();
            int i = 0;
            while (i < graphNodes.length && backEdge == null) {
                if (this.nodeOrder != null) {
                    this.nodeOrder.remove(elementType);
                }
                if (this.getNodeOrder(referenceGraph, graphNodes[i], elementType) == -1) {
                    try {
                        backEdge = this.dfsSearch(referenceGraph, elementType, graphNodes[i]);
                    }
                    catch (URISyntaxException e) {
                        output.reportError(SMLMessages.errorInvalidURI);
                        if (e.getMessage() != null) {
                            output.reportError(e.getMessage());
                        }
                        return false;
                    }
                }
                ++i;
            }
        }
        if (backEdge != null) {
            output.reportError(NLS.bind((String)ValidationMessages.acyclicCycleFound, (Object)backEdge.referenceType));
            if (this.cycle != null && this.cycle.size() > 0) {
                String cycleString = "";
                int i = 0;
                int cycleNodeCount = this.cycle.size();
                while (i < cycleNodeCount) {
                    cycleString = String.valueOf(cycleString) + this.cycle.get(i) + ", ";
                    ++i;
                }
                cycleString = cycleString.substring(0, cycleString.length() - 2);
                output.reportError(NLS.bind((String)ValidationMessages.acyclicDetectedCycle, (Object)cycleString));
            }
            return false;
        }
        return true;
    }

    private int getNodeOrder(Map referenceGraph, String node, TypeNode elementType) {
        DocumentNode documentNode = (DocumentNode)referenceGraph.get(node);
        if (this.nodeOrder == null || documentNode == null) {
            return -1;
        }
        Map ordersPerElement = (Map)this.nodeOrder.get(elementType);
        Integer order = ordersPerElement == null ? null : (Integer)ordersPerElement.get(new Integer(documentNode.hashCode()));
        return order == null ? -1 : order;
    }

    private void incrementNodeOrder(Map referenceGraph, TypeNode elementType, String node) {
        Integer order;
        DocumentNode documentNode = (DocumentNode)referenceGraph.get(node);
        if (documentNode == null) {
            return;
        }
        if (this.nodeOrder == null) {
            this.nodeOrder = new Hashtable();
        }
        Integer hashcode = new Integer(documentNode.hashCode());
        Hashtable<Integer, Integer> ordersPerElement = (Hashtable<Integer, Integer>)this.nodeOrder.get(elementType);
        if (ordersPerElement == null) {
            ordersPerElement = new Hashtable<Integer, Integer>();
            this.nodeOrder.put(elementType, ordersPerElement);
        }
        ordersPerElement.put(hashcode, (order = (Integer)ordersPerElement.get(hashcode)) == null ? new Integer(0) : new Integer(order + 1));
    }

    private Edge dfsSearch(Map referenceGraph, TypeNode elementType, String documentAlias) throws URISyntaxException {
        DocumentNode documentNode = (DocumentNode)referenceGraph.get(documentAlias);
        if (documentNode == null) {
            return null;
        }
        this.incrementNodeOrder(referenceGraph, elementType, documentAlias);
        ElementEdge[] edges = documentNode.getEdges(elementType.getUri(), elementType.getType());
        Edge backEdge = null;
        Node node = (Node)this.treeForest.get(documentAlias);
        if (node == null) {
            node = new Node();
            this.treeForest.put(documentAlias, node);
        }
        int i = 0;
        while (i < edges.length) {
            String document = edges[i].getDocument();
            if (this.getNodeOrder(referenceGraph, document, elementType) != -1) {
                backEdge = new Edge(documentAlias, document, String.valueOf(elementType.getUri()) + elementType.getType());
                ArrayList<String> cycle = new ArrayList<String>();
                cycle.add(documentAlias);
                cycle.add(document);
                this.findCycle(document, documentAlias, cycle);
                if (documentAlias.equals(cycle.get(cycle.size() - 1))) {
                    this.cycle = cycle;
                }
                return backEdge;
            }
            node.addEdge(new Edge(documentAlias, document, String.valueOf(elementType.getUri()) + elementType.getType()));
            backEdge = this.dfsSearch(referenceGraph, elementType, document);
            ++i;
        }
        return backEdge;
    }

    private void findCycle(String source, String target, List cycle) {
        Node node = (Node)this.treeForest.get(source);
        if (node == null) {
            return;
        }
        int i = 0;
        int edgeCount = node.edges.size();
        while (i < edgeCount) {
            Edge currentEdge = (Edge)node.edges.get(i);
            cycle.add(currentEdge.targetDocument);
            if (target.equals(currentEdge.targetDocument)) break;
            this.findCycle(currentEdge.targetDocument, target, cycle);
            if (cycle.size() > 0 && target.equals(cycle.get(cycle.size() - 1))) break;
            cycle.remove(currentEdge.targetDocument);
            ++i;
        }
    }

    private static class Edge {
        public String sourceDocument;
        public String targetDocument;
        public String referenceType;

        public Edge(String sourceDocument, String targetDocument, String referenceType) {
            this.sourceDocument = sourceDocument;
            this.targetDocument = targetDocument;
            this.referenceType = referenceType;
        }
    }

    private static class Node {
        public List edges = new ArrayList();

        public void addEdge(Edge edge) {
            this.edges.add(edge);
        }
    }
}

