/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.Schematron;
import org.eclipse.cosmos.rm.validation.internal.artifacts.SchematronOutput;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementSchematronCacheBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementTypeMapDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IdentityDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.NamespaceContextBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.ValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.util.FileHelper;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchematronValidator
extends AbstractSMLValidator {
    protected static final String SKELETON15 = "validation-resources\\skeleton1-5.xsl";
    protected IValidationOutput validationLogger;
    protected ElementTypeMap elementTypeMapBuilderStructure;
    protected ElementSchematronCacheBuilder.RuleBindings schemaCacheBuilderStructure;
    protected Map inheritance;

    public void initialize(Map validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder", new ElementSchematronCacheBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder", new ElementTypeMapDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.IdentityDataBuilder", new IdentityDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl", new TypeInheritanceDataBuilderImpl());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.NamespaceContextBuilder", new NamespaceContextBuilder());
    }

    public boolean validate() {
        this.validationLogger = this.getValidationOutput();
        this.inheritance = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        this.elementTypeMapBuilderStructure = (ElementTypeMap)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        Map domDocuments = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        this.schemaCacheBuilderStructure = (ElementSchematronCacheBuilder.RuleBindings)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder");
        List docWithNoAlias = (List)domDocuments.get("no_alias");
        for (Object alias : domDocuments.keySet()) {
            Object rootElement = domDocuments.get(alias);
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, alias)) continue;
            return false;
        }
        for (Object rootElement : docWithNoAlias) {
            if (!(rootElement instanceof Element) || this.processNode((Element)rootElement, (Node)rootElement, null)) continue;
            return false;
        }
        return true;
    }

    protected boolean processNode(Node currentElement, Node rootElement, Object alias) {
        if (currentElement.getNodeType() != 1) {
            return true;
        }
        if (this.schemaCacheBuilderStructure.isRuleBindingPresent()) {
            String nodeNamespace = currentElement.getNamespaceURI();
            Schematron schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, currentElement.getLocalName());
            if (alias != null && schematron == null) {
                schematron = this.schemaCacheBuilderStructure.getBoundRule((String)alias);
            }
            String targetType = null;
            if (schematron == null && (targetType = this.elementTypeMapBuilderStructure.getType(currentElement.getNamespaceURI(), currentElement.getLocalName())) != null) {
                schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, targetType + "$typeDelim");
                Map inheritanceMap = null;
                if (schematron == null && (inheritanceMap = (Map)this.inheritance.get(currentElement.getNamespaceURI())) != null) {
                    TypeNode parent = (TypeNode)inheritanceMap.get(targetType);
                    while (parent != null) {
                        schematron = this.schemaCacheBuilderStructure.getBoundRule(nodeNamespace, String.valueOf(ParserHelper.removeNameSpace(parent.getType())) + "$typeDelim");
                        if (schematron != null) break;
                        parent = (TypeNode)inheritanceMap.get(parent.getType());
                    }
                }
            }
            if (schematron != null && !this.validateSchematron(schematron, currentElement, rootElement)) {
                return false;
            }
        }
        NodeList nodeLists = currentElement.getChildNodes();
        int x = 0;
        while (x < nodeLists.getLength()) {
            Node node = nodeLists.item(x);
            if (node.getNodeType() == 1 && !this.processNode(node, rootElement, null)) {
                return false;
            }
            ++x;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean validateSchematron(Schematron schematronNode, Node currentElement, Node rootElement) {
        ErrorCaptureStream errorCaptureStream = new ErrorCaptureStream();
        try {
            StringBuffer buffer = schematronNode.getFragment();
            if (buffer == null) {
                return true;
            }
            String fragment = buffer.toString();
            int schemaInx = fragment.lastIndexOf("</");
            if (schemaInx < 0) {
                return true;
            }
            List patterns = schematronNode.getPatterns();
            int i = 0;
            int patternCount = patterns.size();
            while (i < patternCount) {
                Schematron.Pattern pattern = (Schematron.Pattern)patterns.get(i);
                List rules = pattern.getRules();
                StringBuffer schematronFragmentBuffer = new StringBuffer(buffer);
                schematronFragmentBuffer.insert(schemaInx, pattern.getFragment());
                int j = 0;
                int ruleCount = rules.size();
                while (j < ruleCount) {
                    int patternInx = schematronFragmentBuffer.substring(0, schemaInx + pattern.getFragment().length()).lastIndexOf("</");
                    if (patternInx >= 0) {
                        StringBuffer fragmentWithRule = new StringBuffer(schematronFragmentBuffer);
                        Schematron.Rule rule = (Schematron.Rule)rules.get(j);
                        String ruleFragment = null;
                        if (!rule.getMatchContainsDeref() && !rule.getContext().startsWith("/")) {
                            ruleFragment = rule.getFragment().toString();
                            StringBuffer pathToRoot = new StringBuffer();
                            this.findPathToRoot(pathToRoot, currentElement);
                            String ruleContext = rule.getContext();
                            if (ruleContext.startsWith(".")) {
                                int forwardSlashInx = ruleContext.indexOf("/");
                                ruleContext = forwardSlashInx >= 0 ? ruleContext.substring(forwardSlashInx) : "";
                            }
                            ruleContext = ruleContext.length() > 0 ? "/" + ruleContext : ruleContext;
                            ruleFragment = ruleFragment.replace("\"" + rule.getContext() + "\"", "\"" + pathToRoot.toString().substring(0, pathToRoot.toString().length() - 1) + ruleContext + "\"");
                        }
                        fragmentWithRule.insert(patternInx, ruleFragment == null ? rule.getFragment().toString() : ruleFragment);
                        StringReader sr = new StringReader(fragmentWithRule.toString());
                        DOMResult schematron = new DOMResult();
                        this.transform(new StreamSource(sr), new StreamSource(FileHelper.getResourceAsStream(SKELETON15)), schematron, errorCaptureStream);
                        final Map prefixMap = schematronNode.getPrefixMap();
                        String ruleContext = rule.getContext();
                        if (rule.getMatchContainsDeref() && ruleContext.length() > 0) {
                            NamespaceContext namespaceContext = new NamespaceContext(){

                                public String getNamespaceURI(String prefix) {
                                    String uri = (String)prefixMap.get(prefix);
                                    return uri == null ? "" : uri;
                                }

                                public String getPrefix(String arg0) {
                                    return null;
                                }

                                public Iterator getPrefixes(String arg0) {
                                    return null;
                                }
                            };
                            SMLValidatorUtil.xpath.setNamespaceContext(namespaceContext);
                            XPathExpression xpathExp = SMLValidatorUtil.xpath.compile(ruleContext);
                            NodeList nodeList = (NodeList)xpathExp.evaluate(currentElement, XPathConstants.NODESET);
                            if (nodeList == null || nodeList.getLength() <= 0) {
                                this.validationLogger.reportError(NLS.bind((String)ValidationMessages.schematronMissingContext, (Object)ruleContext));
                                return false;
                            }
                            int x = 0;
                            while (x < nodeList.getLength()) {
                                if (!this.applySchematron(errorCaptureStream, nodeList.item(x), schematron.getNode())) {
                                    return false;
                                }
                                ++x;
                            }
                        } else {
                            if (ruleFragment != null) {
                                currentElement = currentElement.getOwnerDocument().getFirstChild();
                            }
                            if (!this.applySchematron(errorCaptureStream, currentElement, schematron.getNode())) {
                                return false;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            this.handleError(errorCaptureStream, e.getLocalizedMessage());
            return false;
        }
    }

    private void findPathToRoot(StringBuffer pathToRoot, Node currentElement) {
        pathToRoot.insert(0, String.valueOf(currentElement.getNodeName()) + '[' + this.findIndex(currentElement) + ']' + "/");
        Node parentNode = currentElement.getParentNode();
        if (parentNode == null || parentNode.getParentNode() == null || parentNode.getParentNode().getNodeType() == 9) {
            return;
        }
        this.findPathToRoot(pathToRoot, parentNode);
    }

    private int findIndex(Node currentElement) {
        Node[] children = SMLValidatorUtil.retrieveChildElements(currentElement.getParentNode());
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(currentElement)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    private void handleError(ErrorCaptureStream errorCaptureStream, String msg) {
        if (!errorCaptureStream.isEmpty()) {
            String[] lines = errorCaptureStream.getLines();
            int i = 0;
            while (i < lines.length && lines[i] != null) {
                this.validationLogger.reportError(lines[i]);
                ++i;
            }
        }
        this.validationLogger.reportError(msg);
    }

    private boolean applySchematron(ErrorCaptureStream errorCaptureStream, Node currentElement, Node schematron) {
        StringWriter sw = new StringWriter();
        StreamResult output = new StreamResult(sw);
        DOMSource schematronSource = new DOMSource(schematron);
        try {
            this.transform(this.createStreamSource(currentElement), schematronSource, output, errorCaptureStream);
        }
        catch (Exception e) {
            this.handleError(errorCaptureStream, NLS.bind((String)ValidationMessages.schematronTransformation, (Object)(e.getLocalizedMessage() == null ? "" : e.getLocalizedMessage())));
            return false;
        }
        String result = sw.getBuffer().toString();
        if (result.trim().length() > 0) {
            ElementSchematronCacheBuilder schematronBuilder = (ElementSchematronCacheBuilder)DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSchematronCacheBuilder");
            int outputIndex = result.indexOf("%outputids=");
            if (outputIndex > -1) {
                String[] parts = result.split("%", 3);
                String outputids = parts[1].split("=", 2)[1];
                String[] outputidsArray = outputids.split(" ", -1);
                int i = 0;
                while (i < outputidsArray.length) {
                    SchematronOutput cfr_ignored_0 = (SchematronOutput)schematronBuilder.getSchematronOutputs().get(outputidsArray[i]);
                    ++i;
                }
                result = parts[2].trim();
            }
            this.validationLogger.reportError(result);
            return false;
        }
        return true;
    }

    private StreamSource createStreamSource(Node node) {
        int lineNumber = 0;
        if (node instanceof ElementNode) {
            lineNumber = ((ElementNode)((Object)node)).getLine();
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(node);
            transformer.transform(source, result);
            return new StreamSource(new StringReader(result.getWriter().toString()));
        }
        catch (TransformerConfigurationException e) {
            this.validationLogger.reportError(lineNumber, e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            this.validationLogger.reportError(lineNumber, e.getLocalizedMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            this.validationLogger.reportError(lineNumber, e.getLocalizedMessage());
        }
        catch (TransformerException e) {
            this.validationLogger.reportError(lineNumber, e.getLocalizedMessage());
        }
        return null;
    }

    protected void transform(Source source, Source xslt, Result result, ErrorCaptureStream captureError) throws TransformerException {
        Transformer transformer = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        transformer = tFactory.newTransformer(xslt);
        transformer.setErrorListener(new ErrorListener(){

            public void error(TransformerException e) throws TransformerException {
                throw e;
            }

            public void fatalError(TransformerException e) throws TransformerException {
                throw e;
            }

            public void warning(TransformerException e) throws TransformerException {
                throw e;
            }
        });
        System.setErr(new PrintStream(captureError));
        transformer.transform(source, result);
        System.setErr(System.err);
    }

    private static class ErrorCaptureStream
    extends OutputStream {
        private String[] lines = new String[5];
        private int currentInx = 0;
        private StringBuffer buffer = new StringBuffer();

        public void write(int b) throws IOException {
            if (this.currentInx >= this.lines.length) {
                return;
            }
            if (b == 10) {
                if (this.currentInx == 0 || !this.buffer.toString().equals(this.lines[this.currentInx - 1])) {
                    this.lines[this.currentInx++] = this.buffer.toString();
                }
                this.buffer = new StringBuffer();
                return;
            }
            if (b != 13) {
                this.buffer.append((char)b);
            }
        }

        public boolean isEmpty() {
            return this.lines[0] == null;
        }

        public String[] getLines() {
            return this.lines;
        }
    }
}

