/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.util.Map;
import javax.xml.xpath.XPathFunctionException;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetElementNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetSchemaNode;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TypeNode;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementTypeMapDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.RefTypeElementBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.SubstitutionBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TargetInstanceBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TargetSchemaBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.TypeInheritanceDataBuilderImpl;
import org.eclipse.cosmos.rm.validation.internal.reference.DerefXPathFunction;
import org.eclipse.cosmos.rm.validation.internal.smlvalidators.ValidationMessages;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.w3c.dom.Element;

public class TargetValidator
extends AbstractSMLValidator {
    protected Map targetSchemaBuilderStructure;
    protected Map targetInstanceBuilderStructure;
    protected Map documentDOMBuilderElems;
    protected Map substitutionElementElems;
    protected ElementTypeMap elementTypeMapBuilderStructure;
    protected Map inheritance;
    protected IValidationOutput validationLogger;

    public void initialize(Map validationAttribute) {
        super.initialize(validationAttribute);
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl", new TypeInheritanceDataBuilderImpl());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.RefTypeElementBuilder", new RefTypeElementBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder", new ElementTypeMapDataBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetSchemaBuilder", new TargetSchemaBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder", new TargetInstanceBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.SubstitutionBuilder", new SubstitutionBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler", new DocumentDOMBuilder());
    }

    public boolean validate() {
        this.validationLogger = this.getValidationOutput();
        IDataBuilder targetSchemaBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetSchemaBuilder");
        IDataBuilder targetInstanceBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TargetInstanceBuilder");
        IDataBuilder substitionElement = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        IDataBuilder documentDOMBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler");
        IDataBuilder elementTypeMapBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
        IDataBuilder typeInheritanceDataBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.TypeInheritanceDataBuilderImpl");
        this.documentDOMBuilderElems = (Map)documentDOMBuilder.getDataStructure();
        this.substitutionElementElems = (Map)substitionElement.getDataStructure();
        this.targetSchemaBuilderStructure = (Map)targetSchemaBuilder.getDataStructure();
        this.targetInstanceBuilderStructure = (Map)targetInstanceBuilder.getDataStructure();
        this.elementTypeMapBuilderStructure = (ElementTypeMap)elementTypeMapBuilder.getDataStructure();
        this.inheritance = (Map)typeInheritanceDataBuilder.getDataStructure();
        return this.validateTargetInstance();
    }

    protected boolean validateTargetInstance() {
        for (TargetElementNode targetElementNode : this.targetInstanceBuilderStructure.keySet()) {
            Object subGroup;
            Map subGroupMap;
            TargetSchemaNode targetSchemaNode = (TargetSchemaNode)this.targetSchemaBuilderStructure.get(targetElementNode.getName());
            if (targetSchemaNode == null && (subGroupMap = (Map)this.substitutionElementElems.get(targetElementNode.getUri())) != null && (subGroup = subGroupMap.get(targetElementNode.getName())) != null) {
                targetSchemaNode = (TargetSchemaNode)this.targetSchemaBuilderStructure.get(ParserHelper.removeNameSpace((String)subGroup));
            }
            if ("true".equals(targetSchemaNode.getRequired()) && !this.isURIValid(targetElementNode.getTargetURI())) {
                Object[] errorParams = new String[]{targetElementNode.getName(), String.valueOf(targetElementNode.getLine()), String.valueOf(targetElementNode.getColumn())};
                this.validationLogger.reportError(targetElementNode.getLine(), ValidationMessages.bind((String)ValidationMessages.unresolveTargetURI, (Object[])errorParams));
                return false;
            }
            if (targetSchemaNode.getTargetElement() != null && !this.validateTargetElement(targetElementNode, targetSchemaNode)) {
                return false;
            }
            if (targetSchemaNode.getTargetType() == null || this.validateTargetType(targetElementNode, targetSchemaNode)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateTargetType(TargetElementNode targetElementNode, TargetSchemaNode targetSchemaNode) {
        boolean valid;
        String targetElementUri = targetElementNode.getTargetURI();
        String targetElementNamespace = targetElementNode.getUri();
        String getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNode.getUri(), targetElementUri);
        if (getTargetType != null && this.compareElementInstance(targetSchemaNode.getTargetType(), getTargetType)) {
            return true;
        }
        if (getTargetType != null) {
            Map inheritanceMap = (Map)this.inheritance.get(targetElementNamespace);
            boolean valid2 = false;
            if (inheritanceMap != null) {
                TypeNode parent = (TypeNode)inheritanceMap.get(getTargetType);
                while (parent != null) {
                    if (this.compareElementInstance(parent.getType(), targetSchemaNode.getTargetType())) {
                        valid2 = true;
                        break;
                    }
                    parent = (TypeNode)inheritanceMap.get(parent.getType());
                }
            }
            if (valid2) {
                return true;
            }
        }
        String targetTypeUri = null;
        Object alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null && alias instanceof Element) {
            targetTypeUri = ((Element)alias).getNodeName();
            targetElementNamespace = ((Element)alias).getNamespaceURI();
        }
        if (targetTypeUri != null) {
            getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementNamespace, targetTypeUri);
        }
        if (getTargetType != null && this.compareElementInstance(getTargetType, targetSchemaNode.getTargetType())) {
            return true;
        }
        if (getTargetType != null) {
            Map inheritanceMap = (Map)this.inheritance.get(targetElementNamespace);
            valid = false;
            if (inheritanceMap != null) {
                TypeNode parent = (TypeNode)inheritanceMap.get(getTargetType);
                while (parent != null) {
                    if (this.compareElementInstance(parent.getType(), targetSchemaNode.getTargetType())) {
                        valid = true;
                        break;
                    }
                    parent = (TypeNode)inheritanceMap.get(parent.getType());
                }
            }
            if (valid) {
                return true;
            }
        }
        Object substitionGroup = this.substitutionElementElems.get(targetElementUri);
        valid = false;
        while (substitionGroup != null) {
            getTargetType = this.elementTypeMapBuilderStructure.getType(targetElementUri, (String)substitionGroup);
            if (this.compareElementInstance(substitionGroup, targetSchemaNode.getTargetType())) {
                valid = true;
                break;
            }
            substitionGroup = this.substitutionElementElems.get(substitionGroup);
        }
        if (valid || alias == null) {
            return true;
        }
        Object[] errorParams = new String[]{targetElementNode.getName(), targetElementNode.getLine() < 0 ? ValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLine()), targetElementNode.getColumn() < 0 ? ValidationMessages.commonUnknown : String.valueOf(targetElementNode.getColumn()), targetElementUri, targetSchemaNode.getTargetType()};
        this.validationLogger.reportError(targetElementNode.getLine() < 0 ? 0 : targetElementNode.getLine(), ValidationMessages.bind((String)ValidationMessages.targetTypeInvalid, (Object[])errorParams));
        return false;
    }

    protected boolean validateTargetElement(TargetElementNode targetElementNode, TargetSchemaNode targetSchemaNode) {
        String targetElementUri = targetElementNode.getTargetURI();
        String targetElementNamespace = targetElementNode.getUri();
        if (this.compareElementInstance(targetSchemaNode.getTargetElement(), targetElementUri)) {
            return true;
        }
        Object alias = this.documentDOMBuilderElems.get(targetElementUri);
        if (alias != null && alias instanceof Element) {
            targetElementUri = ((Element)alias).getNodeName();
            targetElementNamespace = ((Element)alias).getNamespaceURI();
        }
        if (this.compareElementInstance(targetElementUri, targetSchemaNode.getTargetElement())) {
            return true;
        }
        Map substitionGroupMap = (Map)this.substitutionElementElems.get(targetElementNamespace);
        boolean valid = false;
        if (substitionGroupMap != null) {
            Object substitionGroup = substitionGroupMap.get(targetElementUri);
            while (substitionGroup != null) {
                if (this.compareElementInstance(substitionGroup, targetSchemaNode.getTargetElement())) {
                    valid = true;
                    break;
                }
                substitionGroup = ParserHelper.removeNameSpace((String)substitionGroup);
                substitionGroup = substitionGroupMap.get(substitionGroup);
            }
        }
        if (valid || alias == null) {
            return true;
        }
        Object[] errorParams = new String[]{targetElementNode.getName(), targetElementNode.getLine() < 0 ? ValidationMessages.commonUnknown : String.valueOf(targetElementNode.getLine()), targetElementNode.getColumn() < 0 ? ValidationMessages.commonUnknown : String.valueOf(targetElementNode.getColumn()), targetElementUri, targetSchemaNode.getTargetElement()};
        this.validationLogger.reportError(targetElementNode.getLine() < 0 ? 0 : targetElementNode.getLine(), ValidationMessages.bind((String)ValidationMessages.invalidTargetInstance, (Object[])errorParams));
        return false;
    }

    protected boolean compareElementInstance(Object elem1, Object elem2) {
        return ParserHelper.removeNameSpace((String)elem1).equals(ParserHelper.removeNameSpace((String)elem2));
    }

    protected boolean isURIValid(String uri) {
        try {
            return ((DerefXPathFunction)DerefXPathFunction.instance()).evaluate(SMLValidatorUtil.removeLineBreaks(uri)) != null;
        }
        catch (XPathFunctionException xPathFunctionException) {
            return false;
        }
    }
}

