/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.sqltools.common.ui.dialog.SQLPainterDlg;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.core.services.UIComponentService;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.LaunchUI;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.datatools.sqltools.routineeditor.util.RoutineUtil;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationDialog;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RoutineMainTab
extends AbstractLaunchConfigurationTab {
    static String LINE_SEPARATOR = System.getProperty("line.separator");
    private Group _grProfile;
    private Combo _comboProfile;
    private Label _labelProfileName;
    private Label _labelDbName;
    private Combo _comboDbName;
    private Group _grRadios;
    private Button _rbProc;
    private Button _rbFunction;
    private Button _rbEvent;
    private Button _rbSQL;
    private Button _rbTrigger;
    private Group _grRunString;
    private Text _txtObjname;
    private Button _pbRunBrowse;
    private Group _grParameters;
    private Text _txtPreview;
    private Button _pbConfigParameter;
    private List _parameterList = new ArrayList();
    private List _backupList;
    private Map _eventTriggerParams = new HashMap();
    FontMetrics _fontMetrics;
    private String _defaultPreview;
    private MenuManager _ctxMenuMgr;
    private IAction _psqlSelectAction;
    private IAction _psqlInsertAction;
    private IAction _psqlUpdateAction;
    private IAction _psqlDeleteAction;
    ProcIdentifier _currentProc;
    ProcIdentifier _backupProc;
    ILaunchConfiguration _configuration;

    public String getName() {
        return Messages.RoutineMainTab_name;
    }

    public Image getImage() {
        Image image = RoutineEditorImages.getImage("launch_configuration");
        return image;
    }

    public int convertHeightInCharsToPixels(int chars) {
        if (this._fontMetrics == null) {
            return 0;
        }
        return this._fontMetrics.getHeight() * chars;
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        this._fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public void createControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), "org.eclipse.datatools.sqltools.sqleditor.launch_configuration_main");
        this.initializeDialogUnits((Control)parent);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RoutineMainTab.this.setDirty(true);
                RoutineMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        int topNumColumn = 1;
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = topNumColumn;
        comp.setLayout((Layout)topLayout);
        this._grProfile = new Group(comp, 0);
        this._grProfile.setText(Messages.RoutineMainTab_profile);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = topNumColumn;
        this._grProfile.setLayoutData((Object)griddata);
        GridLayout profileLayout = new GridLayout();
        profileLayout.numColumns = 4;
        profileLayout.horizontalSpacing = 10;
        this._grProfile.setLayout((Layout)profileLayout);
        this._labelProfileName = new Label((Composite)this._grProfile, 0);
        this._labelProfileName.setText(Messages.RoutineMainTab_profile);
        this._comboProfile = new Combo((Composite)this._grProfile, 8);
        this._comboProfile.setItems(ProfileUtil.getSupportedDatabaseProfiles());
        this._comboProfile.setVisibleItemCount(20);
        this._comboProfile.setLayoutData((Object)new GridData(110, 25));
        this._comboProfile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RoutineMainTab.this._comboDbName != null) {
                    RoutineMainTab.this._comboDbName.removeAll();
                }
            }
        });
        this._labelDbName = new Label((Composite)this._grProfile, 0);
        this._labelDbName.setText(Messages.RoutineMainTab_dbname);
        this._comboDbName = new Combo((Composite)this._grProfile, 8);
        this._comboDbName.setVisibleItemCount(20);
        this._comboDbName.setLayoutData((Object)new GridData(110, 20));
        this._comboDbName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoutineMainTab.this._comboDbName.removeAll();
                String profileName = RoutineMainTab.this._comboProfile.getText();
                if (profileName != null) {
                    List list = ProfileUtil.getDatabaseList((String)profileName);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        RoutineMainTab.this._comboDbName.add(iterator.next().toString());
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._comboDbName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RoutineMainTab.this.setDirty(true);
                RoutineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this._grRadios = new Group(comp, 0);
        this._grRadios.setText(Messages.RoutineMainTab_type);
        griddata = new GridData(768);
        griddata.horizontalSpan = topNumColumn;
        this._grRadios.setLayoutData((Object)griddata);
        GridLayout radioLayout = new GridLayout();
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioLayout.numColumns = 2;
        radioLayout.makeColumnsEqualWidth = true;
        this._grRadios.setLayout((Layout)radioLayout);
        this._rbProc = this.createRadioButton((Composite)this._grRadios, Messages.RoutineMainTab_storedprocedure);
        this._rbFunction = this.createRadioButton((Composite)this._grRadios, Messages.RoutineMainTab_udf);
        this._rbTrigger = this.createRadioButton((Composite)this._grRadios, Messages.RoutineMainTab_trigger);
        this._rbEvent = this.createRadioButton((Composite)this._grRadios, Messages.RoutineMainTab_eventhandler);
        this._rbSQL = this.createRadioButton((Composite)this._grRadios, Messages.RoutineMainTab_adhoc);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RoutineMainTab.this.setDirty(true);
                RoutineMainTab.this.updateLaunchConfigurationDialog();
                try {
                    if (RoutineMainTab.this._currentProc == null) {
                        RoutineMainTab.this._txtPreview.setText("");
                        return;
                    }
                    if (RoutineMainTab.this._currentProc.getType() == RoutineMainTab.this.getCurrentTypeSelection() && RoutineMainTab.this._configuration != null) {
                        RoutineMainTab.this._txtPreview.setText(LaunchHelper.constructDirectInvocationSQLString(RoutineMainTab.this._configuration));
                    } else if (RoutineMainTab.this.getCurrentTypeSelection() == 4 && RoutineMainTab.this._configuration != null) {
                        RoutineMainTab.this._txtPreview.setText(LaunchHelper.constructDirectInvocationSQLString(RoutineMainTab.this._configuration));
                    } else {
                        RoutineMainTab.this._txtPreview.setText("");
                    }
                }
                catch (CoreException e1) {
                    RoutineMainTab.this._txtPreview.setText("");
                }
                catch (SQLException e1) {
                    RoutineMainTab.this._txtPreview.setText("");
                }
                catch (NoSuchProfileException e1) {
                    RoutineMainTab.this._txtPreview.setText("");
                }
            }
        };
        this._rbProc.addSelectionListener((SelectionListener)selectionListener);
        this._rbFunction.addSelectionListener((SelectionListener)selectionListener);
        this._rbEvent.addSelectionListener((SelectionListener)selectionListener);
        this._rbSQL.addSelectionListener((SelectionListener)selectionListener);
        this._rbTrigger.addSelectionListener((SelectionListener)selectionListener);
        this._grRunString = new Group(comp, 0);
        this._grRunString.setText(Messages.RoutineMainTab_objectname);
        griddata = new GridData(768);
        griddata.horizontalSpan = topNumColumn;
        this._grRunString.setLayoutData((Object)griddata);
        GridLayout objnameLayout = new GridLayout();
        objnameLayout.numColumns = 2;
        this._grRunString.setLayout((Layout)objnameLayout);
        this._txtObjname = new Text((Composite)this._grRunString, 2048);
        griddata = new GridData(768);
        griddata.grabExcessHorizontalSpace = true;
        this._txtObjname.setLayoutData((Object)griddata);
        this._pbRunBrowse = this.createPushButton((Composite)this._grRunString, Messages.RoutineMainTab_run_browse, null);
        this._pbRunBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object s = null;
                try {
                    if (RoutineMainTab.this._comboProfile.getText() != null && RoutineMainTab.this._comboDbName.getText() != null) {
                        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(RoutineMainTab.this._comboProfile.getText(), RoutineMainTab.this._comboDbName.getText());
                        s = LaunchUI.selectDatabaseObject(RoutineMainTab.this.getShell(), databaseIdentifier, RoutineMainTab.this.getCurrentTypeSelection(), RoutineMainTab.this._currentProc);
                    }
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)RoutineMainTab.this.getShell(), (String)Messages.RoutineMainTab_msg_error, (String)e1.getMessage());
                    return;
                }
                if (s != null && !s.equals(RoutineMainTab.this._currentProc)) {
                    RoutineMainTab.this.setDirty(true);
                    RoutineMainTab.this._currentProc = s;
                    RoutineMainTab.this._txtObjname.setText(s.getLongDisplayString());
                }
                if (RoutineMainTab.this.getCurrentTypeSelection() == 0 || RoutineMainTab.this.getCurrentTypeSelection() == 1) {
                    if (RoutineMainTab.this._currentProc != null) {
                        try {
                            ParameterDescriptor[] pds = LaunchUI.getParameterDescriptors(RoutineMainTab.this._currentProc);
                            RoutineMainTab.this.convertParameters(pds);
                            RoutineMainTab.this._defaultPreview = RoutineUtil.constructSPUDFDirectInvocationString(RoutineMainTab.this._currentProc, RoutineMainTab.this._parameterList, pds, true);
                            if (RoutineMainTab.this._defaultPreview != null) {
                                RoutineMainTab.this._txtPreview.setText(RoutineMainTab.this._defaultPreview);
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (RoutineMainTab.this.getCurrentTypeSelection() == 2) {
                    RoutineMainTab.this._txtPreview.setText(RoutineUtil.constructTriggerEventString(RoutineMainTab.this._currentProc, RoutineMainTab.this._eventTriggerParams, true));
                }
                RoutineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite botComp = new Composite(comp, 0);
        GridLayout botLayout = new GridLayout();
        botLayout.marginHeight = 0;
        botLayout.marginWidth = 0;
        botComp.setLayout((Layout)botLayout);
        this._grParameters = new Group(botComp, 0);
        this._grParameters.setText(Messages.RoutineMainTab_parameters);
        griddata = new GridData(768);
        griddata.horizontalSpan = topNumColumn;
        griddata.heightHint = this.convertHeightInCharsToPixels(8);
        this._grParameters.setLayoutData((Object)griddata);
        GridLayout parameterLayout = new GridLayout();
        parameterLayout.numColumns = 2;
        this._grParameters.setLayout((Layout)parameterLayout);
        this._txtPreview = new Text((Composite)this._grParameters, 0x2000A0A);
        griddata = new GridData(1808);
        griddata.grabExcessHorizontalSpace = true;
        this._txtPreview.setLayoutData((Object)griddata);
        this._txtPreview.addModifyListener(modifyListener);
        this._pbConfigParameter = this.createPushButton((Composite)this._grParameters, Messages.RoutineMainTab_configparam, null);
        this._pbConfigParameter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDescriptor[] pds;
                if (RoutineMainTab.this.getCurrentTypeSelection() == 4 || RoutineMainTab.this.getCurrentTypeSelection() == 3) {
                    SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName((String)RoutineMainTab.this._comboProfile.getText());
                    UIComponentService componentService = conf.getUIComponentService();
                    if (componentService.supportsDMLDialog()) {
                        Menu menu = RoutineMainTab.this.createContextMenuManager(componentService).createContextMenu((Control)RoutineMainTab.this._pbRunBrowse);
                        menu.setVisible(true);
                    } else {
                        MessageDialog.openInformation((Shell)RoutineMainTab.this.getShell(), (String)Messages.RoutineMainTab_sql_unimplemented_title, (String)Messages.RoutineMainTab_sql_unimplemented_msg);
                    }
                    return;
                }
                if (RoutineMainTab.this.getCurrentTypeSelection() == 2) {
                    return;
                }
                try {
                    pds = LaunchUI.getParameterDescriptors(RoutineMainTab.this._currentProc);
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)RoutineMainTab.this.getShell(), (String)Messages.RoutineMainTab_msg_error, (String)(Messages.RoutineMainTab_msg_error_metadata + e1.getMessage()));
                    e1.printStackTrace();
                    return;
                }
                List newValues = LaunchUI.configParameter(RoutineMainTab.this.getShell(), pds, RoutineMainTab.this._parameterList, true, RoutineMainTab.this._configuration);
                if (newValues != null) {
                    RoutineMainTab.this._parameterList = newValues;
                    RoutineMainTab.this._txtPreview.setText(RoutineUtil.constructSPUDFDirectInvocationString(RoutineMainTab.this._currentProc, RoutineMainTab.this._parameterList, pds, true));
                    RoutineMainTab.this.setDirty(true);
                    RoutineMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        GridData bgd = new GridData(768);
        if (this.getLaunchConfigurationDialog() instanceof LaunchConfigurationDialog) {
            bgd.heightHint = 240;
        }
        botComp.setLayoutData((Object)bgd);
    }

    private MenuManager createContextMenuManager(UIComponentService service) {
        this._ctxMenuMgr = new MenuManager(Messages.pasteSQL);
        this._psqlSelectAction = new SQLPainterAction(service, Messages.pasteSQL_select, "query");
        this._psqlInsertAction = new SQLPainterAction(service, Messages.pasteSQL_insert, "insert");
        this._psqlUpdateAction = new SQLPainterAction(service, Messages.pasteSQL_update, "update");
        this._psqlDeleteAction = new SQLPainterAction(service, Messages.pasteSQL_delete, "delete");
        if (this.getCurrentTypeSelection() != 61) {
            this._ctxMenuMgr.add(this._psqlSelectAction);
        }
        this._ctxMenuMgr.add(this._psqlInsertAction);
        this._ctxMenuMgr.add(this._psqlUpdateAction);
        this._ctxMenuMgr.add(this._psqlDeleteAction);
        return this._ctxMenuMgr;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ProcIdentifier pi = LaunchUI.getActiveProcIdentifier();
        if (pi != null) {
            LaunchHelper.initializeConfiguration(configuration, pi);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (configuration == null) {
                configuration = this._configuration;
            }
            DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier(configuration);
            String profile = databaseIdentifier.getProfileName();
            String dbName = databaseIdentifier.getDBname();
            this._comboProfile.setText(profile == null ? "" : profile);
            if (dbName != null) {
                this._comboDbName.add(dbName);
                this._comboDbName.setText(dbName);
            }
            boolean issql = LaunchHelper.isAdHocSQL(configuration);
            this._rbProc.setSelection(false);
            this._rbEvent.setSelection(false);
            this._rbSQL.setSelection(false);
            this._rbTrigger.setSelection(false);
            this._rbFunction.setSelection(false);
            if (issql) {
                this._rbSQL.setSelection(true);
                this._currentProc = null;
            } else {
                this._currentProc = LaunchHelper.readProcIdentifier(configuration);
                if (this._currentProc == null) {
                    this._rbProc.setSelection(true);
                    this._txtObjname.setText("");
                } else {
                    this._txtObjname.setText(this._currentProc.getLongDisplayString());
                    switch (this._currentProc.getType()) {
                        case 0: {
                            this._rbProc.setSelection(true);
                            this._parameterList = LaunchHelper.readParameterList(configuration);
                            break;
                        }
                        case 1: {
                            this._rbFunction.setSelection(true);
                            this._parameterList = LaunchHelper.readParameterList(configuration);
                            break;
                        }
                        case 2: {
                            this._rbEvent.setSelection(true);
                            this._eventTriggerParams = LaunchHelper.readEventParameter(configuration);
                            break;
                        }
                        case 3: {
                            this._txtObjname.setEditable(true);
                            this._txtObjname.setEnabled(true);
                            this._rbTrigger.setSelection(true);
                            break;
                        }
                        default: {
                            this._rbProc.setSelection(true);
                        }
                    }
                }
            }
            String sql = LaunchHelper.readLaunchSQLStatement(configuration);
            this._txtPreview.setText(sql);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected int getCurrentTypeSelection() {
        int type = 0;
        if (this._rbProc.getSelection()) {
            type = 0;
        } else if (this._rbFunction.getSelection()) {
            type = 1;
        } else if (this._rbEvent.getSelection()) {
            type = 2;
        } else if (this._rbSQL.getSelection()) {
            type = 4;
        } else if (this._rbTrigger.getSelection()) {
            type = 3;
        }
        return type;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String s = this._txtPreview.getText();
        if (s != null) {
            s = s.replaceAll(LINE_SEPARATOR, "\n");
        }
        if (this.getCurrentTypeSelection() == 0 || this.getCurrentTypeSelection() == 1) {
            if (this._currentProc == null) {
                this._currentProc = this._backupProc;
            }
            if (this._parameterList == null) {
                this._parameterList = this._backupList;
            }
            LaunchHelper.saveSPUDF(configuration, this._currentProc, this._parameterList, s);
            this._configuration = configuration;
            this._backupProc = this._currentProc;
            this._backupList = this._parameterList;
        } else if (this.getCurrentTypeSelection() == 2) {
            LaunchHelper.saveEvent(configuration, this._currentProc, this._eventTriggerParams, s);
        } else if (this.getCurrentTypeSelection() == 3) {
            LaunchHelper.saveTrigger(configuration, this._currentProc, s);
        } else {
            LaunchHelper.saveAdHocSQL(configuration, this._comboProfile.getText(), this._comboDbName.getText(), s);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.updateStatus();
    }

    protected boolean updateStatus() {
        String s;
        this.setErrorMessage(null);
        this.setMessage(null);
        String profileName = this._comboProfile.getText();
        String dbName = this._comboDbName.getText();
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
        if (profileName == null || profileName.trim().length() == 0 || !ProfileUtil.isDatabaseProfile((String)databaseIdentifier.getProfileName()) || dbName == null || dbName.trim().length() == 0) {
            if (profileName == null || profileName.trim().length() == 0 || !ProfileUtil.isDatabaseProfile((String)databaseIdentifier.getProfileName())) {
                this.setErrorMessage(Messages.RoutineMainTab_status_invalid_profile);
            } else if (dbName == null || dbName.trim().length() == 0) {
                this.setErrorMessage(Messages.RoutineMainTab_status_invalid_dbName);
            }
            SWTUtils.recursiveEnable((Control)this._grRadios, (boolean)false);
            SWTUtils.recursiveEnable((Control)this._grRunString, (boolean)false);
            SWTUtils.recursiveEnable((Control)this._grParameters, (boolean)false);
            return false;
        }
        boolean isSQLEmpty = false;
        String previewText = this._txtPreview.getText();
        if (previewText == null || previewText.trim().length() == 0) {
            this.setErrorMessage(Messages.RoutineMainTab_status_adhoc);
            isSQLEmpty = true;
        }
        if (this._rbTrigger.getSelection() && previewText != null) {
            boolean noselect;
            int i = previewText.trim().indexOf(" ");
            String firstword = previewText.trim();
            if (i > 0) {
                firstword = previewText.trim().substring(0, i);
            }
            boolean bl = noselect = "INSERT".equalsIgnoreCase(firstword) || "DELETE".equalsIgnoreCase(firstword) || "UPDATE".equalsIgnoreCase(firstword);
            if (!noselect) {
                this.setErrorMessage(Messages.RoutineMainTab_status_trigger_noselect);
                isSQLEmpty = true;
            }
        }
        SWTUtils.recursiveEnable((Control)this._grRadios, (boolean)true);
        SWTUtils.recursiveEnable((Control)this._grRunString, (boolean)true);
        DatabaseDefinition dbDef = ProfileUtil.getDatabaseDefinition((String)databaseIdentifier.getProfileName());
        if (dbDef != null) {
            if (dbDef.supportsEvents()) {
                this._rbEvent.setEnabled(true);
            } else {
                if (this._rbEvent.getSelection()) {
                    this._rbSQL.setSelection(true);
                }
                this._rbEvent.setEnabled(false);
            }
            if (dbDef.supportsSQLUDFs()) {
                this._rbFunction.setEnabled(true);
            } else {
                if (this._rbFunction.getSelection()) {
                    this._rbSQL.setSelection(true);
                }
                this._rbFunction.setEnabled(false);
            }
            if (dbDef.supportsTriggers()) {
                this._rbTrigger.setEnabled(true);
            } else {
                if (this._rbTrigger.getSelection()) {
                    this._rbSQL.setSelection(true);
                }
                this._rbTrigger.setEnabled(false);
            }
            if (dbDef.supportsStoredProcedures()) {
                this._rbProc.setEnabled(true);
            } else {
                if (this._rbProc.getSelection()) {
                    this._rbSQL.setSelection(true);
                }
                this._rbProc.setEnabled(false);
            }
        }
        this._txtObjname.setEditable(false);
        if (this._rbSQL.getSelection()) {
            this._pbConfigParameter.setText(Messages.RoutineMainTab_sql);
            this._txtObjname.setEditable(false);
            this._txtPreview.setEditable(true);
            this._txtPreview.setEnabled(true);
            this._pbRunBrowse.setEnabled(false);
            this._grParameters.setEnabled(true);
            this._pbConfigParameter.setEnabled(true);
            this._txtObjname.setText("");
            return !isSQLEmpty;
        }
        this._pbRunBrowse.setEnabled(true);
        this._pbRunBrowse.setText(Messages.RoutineMainTab_run_browse);
        this._pbConfigParameter.setText(Messages.RoutineMainTab_configparam);
        if (this._rbProc.getSelection()) {
            if (this._currentProc != null) {
                s = this._comboProfile.getText();
                if (s.equals(this._currentProc.getProfileName()) && this._currentProc.getType() == 0) {
                    this._txtObjname.setText(this._currentProc.getLongDisplayString());
                } else {
                    this._txtObjname.setText("");
                }
            } else {
                this._txtObjname.setText("");
            }
        } else if (this._rbFunction.getSelection()) {
            if (this._currentProc != null) {
                s = this._comboProfile.getText();
                if (s.equals(this._currentProc.getProfileName()) && this._currentProc.getType() == 1) {
                    this._txtObjname.setText(this._currentProc.getLongDisplayString());
                } else {
                    this._txtObjname.setText("");
                }
            } else {
                this._txtObjname.setText("");
            }
        } else if (this._rbEvent.getSelection()) {
            if (this._currentProc != null && this._currentProc.getType() == 2) {
                s = this._comboProfile.getText();
                if (s.equals(this._currentProc.getProfileName())) {
                    this._txtObjname.setText(this._currentProc.getLongDisplayString());
                } else {
                    this._txtObjname.setText("");
                }
            } else {
                this._txtObjname.setText("");
            }
        } else if (this._rbTrigger.getSelection()) {
            this._pbConfigParameter.setText(Messages.RoutineMainTab_sql);
            this._txtObjname.setEditable(false);
            this._txtPreview.setEditable(true);
            this._txtPreview.setEnabled(true);
            this._pbConfigParameter.setEnabled(true);
            if (this._currentProc != null && this._currentProc.getType() == 3) {
                s = this._comboProfile.getText();
                if (s.equals(this._currentProc.getProfileName())) {
                    this._txtObjname.setText(this._currentProc.getLongDisplayString());
                } else {
                    this._txtObjname.setText("");
                }
            } else {
                this._txtObjname.setText("");
            }
        }
        String runstrmsg = this.checkRunStringValid();
        if (runstrmsg == null) {
            SWTUtils.recursiveEnable((Control)this._grParameters, (boolean)true);
            this._pbConfigParameter.setEnabled(true);
            return !isSQLEmpty;
        }
        SWTUtils.recursiveEnable((Control)this._grParameters, (boolean)false);
        this.setErrorMessage(runstrmsg);
        return false;
    }

    private void convertParameters(ParameterDescriptor[] pds) {
        RoutineMainTab.resize(this._parameterList, pds.length, null);
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].isOutput()) continue;
            this._parameterList.set(i, null);
        }
    }

    private String checkRunStringValid() {
        if (this._txtObjname.getText().length() != 0) {
            return null;
        }
        switch (this.getCurrentTypeSelection()) {
            case 1: {
                return Messages.RoutineMainTab_status_function;
            }
            case 2: {
                return Messages.RoutineMainTab_status_event;
            }
            case 3: {
                return Messages.RoutineMainTab_status_trigger;
            }
        }
        return Messages.RoutineMainTab_status_sp;
    }

    public static void resize(List list, int size, Object fill) {
        block4: {
            int diff;
            block3: {
                if (size < 0) {
                    throw new IllegalArgumentException(Messages.RoutineMainTab_invalid_size);
                }
                diff = list.size() - size;
                if (diff >= 0) break block3;
                while (diff < 0) {
                    list.add(fill);
                    ++diff;
                }
                break block4;
            }
            if (diff <= 0) break block4;
            int i = list.size() - 1;
            while (diff > 0) {
                list.remove(i);
                --i;
                --diff;
            }
        }
    }

    private final class SQLPainterAction
    extends Action {
        private String _statmentType;
        private UIComponentService _service;

        public SQLPainterAction(UIComponentService service, String text, String statementType) {
            super(text);
            this._statmentType = statementType;
            this._service = service;
        }

        public void run() {
            try {
                SQLPainterDlg spd;
                String s;
                String oldRunString = RoutineMainTab.this._txtPreview.getText();
                String statment = RoutineMainTab.this._txtPreview.getText();
                String profileName = RoutineMainTab.this._comboProfile.getText();
                String dbName = RoutineMainTab.this._comboDbName.getText();
                String parameter = null;
                String parametersType = null;
                String tableName = null;
                if (RoutineMainTab.this._currentProc != null && RoutineMainTab.this._currentProc.getType() == 3) {
                    String ownerName = RoutineMainTab.this._currentProc.getOwnerName();
                    tableName = RoutineMainTab.this._currentProc.getTableName();
                    if (ownerName != null && ownerName.length() > 0) {
                        tableName = ownerName + "." + tableName;
                    }
                }
                if ((s = (spd = this._service.getDMLDialog(RoutineMainTab.this.getShell(), this._statmentType, statment, profileName, dbName, parametersType, parameter, tableName, new HashMap())).load()) != null && !s.equals("") && !s.equals(oldRunString)) {
                    RoutineMainTab.this.setDirty(true);
                    RoutineMainTab.this._txtPreview.setText(s);
                }
            }
            catch (Exception e) {
                RoutineEditorActivator.getDefault().log(e);
                MessageDialog.openError((Shell)RoutineMainTab.this.getShell(), (String)Messages.RoutineMainTab_msg_error, (String)e.getMessage());
                return;
            }
        }
    }
}

