/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.resource;

import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.datatools.sqltools.common.ui.resource.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.dialogs.WizardNewFolderMainPage;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

public class CreateFolderAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CreateFolderAction";
    private Shell _shell;
    private TreeViewer _viewer;

    public CreateFolderAction(TreeViewer viewer) {
        super(Messages.CreateFolderAction_text);
        if (viewer == null) {
            throw new IllegalArgumentException();
        }
        this._viewer = viewer;
        this._shell = viewer.getControl().getShell();
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setToolTipText(Messages.CreateFolderAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.create_folder_action_context");
    }

    public void run() {
        final BasicNewFolderResourceWizard wizard = new BasicNewFolderResourceWizard();
        wizard.init(PlatformUI.getWorkbench(), this.getStructuredSelection());
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(this._shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(Messages.CreateFolderAction_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.ide.new_folder_wizard_context");
        if (dialog.open() != 1) {
            this._shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IFolder folder = ((WizardNewFolderMainPage)wizard.getStartingPage()).createNewFolder();
                    if (folder != null) {
                        StructuredSelection ssel = new StructuredSelection((Object)folder);
                        CreateFolderAction.this._viewer.getControl().setRedraw(false);
                        CreateFolderAction.this._viewer.add((Object)folder.getParent(), (Object)folder);
                        CreateFolderAction.this._viewer.setSelection((ISelection)ssel, true);
                        CreateFolderAction.this._viewer.getControl().setRedraw(true);
                    }
                }
            });
        }
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IResource resource = (IResource)resources.next();
            if (this.resourceIsType(resource, 6) && resource.isAccessible()) continue;
            return false;
        }
        return true;
    }
}

