/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.profile;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;

public class ConnectProfile {
    String _serverType;
    String _name;
    String _host;
    int _port;
    String _dbname;
    String _user;
    String _pass;
    String _url;
    String _providerId;

    public ConnectProfile(String serverType, String host, int port, String dbname, String user, String pass) {
        this._serverType = serverType;
        this._host = host;
        this._port = port;
        this._dbname = dbname;
        this._user = user;
        this._pass = pass;
    }

    public ConnectProfile(IConnectionProfile profile) {
        Properties props = profile.getBaseProperties();
        this._serverType = props.getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        this._name = profile.getName();
        this._dbname = props.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        this._user = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        this._pass = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        this._url = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        this._providerId = profile.getProviderId();
    }

    public String getServerType() {
        return this._serverType;
    }

    public String getDbName() {
        return this._dbname;
    }

    public String getPass() {
        return this._pass;
    }

    public String getUser() {
        return this._user;
    }

    public int getPort() {
        return this._port;
    }

    public String getHost() {
        return this._host;
    }

    public boolean equals(Object profile) {
        if (!(profile instanceof ConnectProfile)) {
            return false;
        }
        ConnectProfile p = (ConnectProfile)profile;
        try {
            boolean equals = p.getProviderId().equals(this._providerId);
            equals = equals && (p.getHost() == null && this._host == null || p.getHost() != null && p.getHost().equals(this._host));
            equals = equals && p.getPort() == this._port;
            equals = equals && (p.getServerType() == null && this._serverType == null || p.getServerType() != null && p.getServerType().equals(this._serverType));
            equals = equals && (p.getUser() == null && this._user == null || p.getUser() != null && p.getUser().equals(this._user));
            boolean bl = equals = equals && p.getName().equals(this._name);
            if (equals) {
                if (ProfileUtil.isDatabaseProfile(p) || ProfileUtil.isDatabaseProfile(this)) {
                    if (this._dbname != null && this._dbname.equals(p.getDbName())) {
                        return true;
                    }
                    return this._dbname == null && p.getDbName() == null;
                }
                return true;
            }
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isOnlyNameChanged(ConnectProfile p) {
        if (!this._name.equals(p.getName())) {
            boolean equals = p.getProviderId().equals(this._providerId);
            equals = equals && (p.getHost() == null && this._host == null || p.getHost() != null && p.getHost().equals(this._host));
            equals = equals && p.getPort() == this._port;
            equals = equals && (p.getServerType() == null && this._serverType == null || p.getServerType() != null && p.getServerType().equals(this._serverType));
            boolean bl = equals = equals && (p.getUser() == null && this._user == null || p.getUser() != null && p.getUser().equals(this._user));
            if (equals) {
                if (ProfileUtil.isDatabaseProfile(p) || ProfileUtil.isDatabaseProfile(this)) {
                    if (p.getDbName() == null) {
                        return this._dbname == null;
                    }
                    return p.getDbName().equals(this._dbname);
                }
                return true;
            }
        }
        return false;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getProviderId() {
        return this._providerId;
    }

    public void setProviderId(String id) {
        this._providerId = id;
    }
}

