/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IDatabaseSetting;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.identifier.IIdentifierValidator;
import org.eclipse.datatools.sqltools.sql.identifier.ValidatorMessage;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SQLDevToolsUtil {
    private static Pattern ID_PATTERN = Pattern.compile("((\\Q[\\E([^\"]|(\"\"))+\\Q]\\E|[^\\s\"\\Q.\\E]+|\"([^\"]|(\"\"))+\")\\Q.\\E?)");
    private static Pattern STRING_PATTERN = Pattern.compile("(([^\\s']+)|('([^']|(''))+'))");

    public static ProcIdentifier getProcIdentifier(SQLObject routine) {
        Database db = null;
        if (routine instanceof Event) {
            db = ((Event)routine).getDatabase();
        } else {
            Schema schema = null;
            if (routine instanceof Routine) {
                schema = ((Routine)routine).getSchema();
            } else if (routine instanceof Trigger) {
                schema = ((Trigger)routine).getSchema();
            } else if (routine.eClass().getEStructuralFeature("schema") != null) {
                schema = (Schema)routine.eGet(routine.eClass().getEStructuralFeature("schema"));
            } else {
                return null;
            }
            db = ModelUtil.getDatabase(schema);
        }
        return SQLDevToolsUtil.getProcIdentifier(SQLDevToolsUtil.getDatabaseIdentifier(db), routine);
    }

    public static ProcIdentifier getProcIdentifier(DatabaseIdentifier databaseIdentifier, SQLObject routine) {
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        DBHelper h = null;
        h = config != null ? config.getDBHelper() : new DBHelper();
        ProcIdentifier proc = null;
        if (routine instanceof Routine) {
            Schema schema = ((Routine)routine).getSchema();
            if (routine instanceof Procedure) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 0, null, schema.getName());
            } else if (routine instanceof Function) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 1, null, schema.getName());
            }
        } else if (routine instanceof Trigger) {
            Schema schema = ((Trigger)routine).getSchema();
            Table table = ((Trigger)routine).getSubjectTable();
            proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 3, table.getName(), schema.getName());
        } else if (routine instanceof Event) {
            String creator = "";
            EStructuralFeature creatorFeature = routine.eClass().getEStructuralFeature("eventCreator");
            if (creatorFeature != null) {
                creator = (String)routine.eGet(creatorFeature);
            }
            proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 2, null, creator);
        } else {
            EStructuralFeature schemaFeature = routine.eClass().getEStructuralFeature("schema");
            EStructuralFeature eventIdFeature = routine.eClass().getEStructuralFeature("eventId");
            if (schemaFeature != null && eventIdFeature != null) {
                proc = h.getProcIdentifier(databaseIdentifier, routine.getName(), 2, null, ((Schema)routine.eGet(schemaFeature)).getName());
            }
        }
        return proc;
    }

    public static int getProcType(SQLObject routine) {
        if (routine instanceof Trigger) {
            return 3;
        }
        if (routine instanceof Procedure) {
            return 0;
        }
        if (routine instanceof Function) {
            return 1;
        }
        if (routine instanceof Event || SQLDevToolsUtil.isEventType(routine) != null) {
            return 2;
        }
        return 4;
    }

    public static EStructuralFeature isEventType(SQLObject routine) {
        return routine.eClass().getEStructuralFeature("eventId");
    }

    public static DatabaseIdentifier getDatabaseIdentifier(Database database) {
        ConnectionInfo connInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(database);
        if (connInfo instanceof ConnectionInfoImpl) {
            IConnectionProfile profile = ((ConnectionInfoImpl)connInfo).getConnectionProfile();
            return new DatabaseIdentifier(profile.getName(), database.getName());
        }
        return null;
    }

    public static boolean getQuotedIdentifier(DatabaseIdentifier dbid) {
        boolean quoted_id = false;
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfiguration(null, dbid);
        IDatabaseSetting config = factory.getDatabaseSetting(dbid);
        if (config != null) {
            try {
                Boolean value = (Boolean)config.getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
                quoted_id = value;
            }
            catch (IDatabaseSetting.NotSupportedSettingException e) {
                EditorCorePlugin.getDefault().log(e);
            }
        }
        return quoted_id;
    }

    public static boolean isQuotedIdentifierOn(DatabaseIdentifier databaseIdentifier) {
        boolean quotedIdentifier = false;
        Object quotedIdentifierCfg = null;
        try {
            SQLDevToolsConfiguration conf = SQLToolsFacade.getConfiguration(null, databaseIdentifier);
            quotedIdentifierCfg = conf.getDatabaseSetting(databaseIdentifier).getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
        }
        catch (IDatabaseSetting.NotSupportedSettingException notSupportedSettingException) {
            // empty catch block
        }
        if (quotedIdentifierCfg instanceof Boolean) {
            quotedIdentifier = (Boolean)quotedIdentifierCfg;
        }
        return quotedIdentifier;
    }

    public static String quoteStringWhenNecessary(String objstr) {
        String r = null;
        Matcher m = STRING_PATTERN.matcher(objstr);
        if (m.find()) {
            r = m.group();
        }
        if (r != null && r.equals(objstr)) {
            return r;
        }
        return SQLUtil.quote((String)objstr, (String)"'");
    }

    public static String quoteWhenNecessary(String content, DatabaseIdentifier databaseIdentifier) {
        return SQLDevToolsUtil.quoteWhenNecessary(content, databaseIdentifier, "\"");
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote, int identiferType) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        IIdentifierValidator validator = conf.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(id, identiferType, databaseIdentifier)) != null && ValidatorMessage.hasError(msg, 2))) {
            return id;
        }
        boolean quoted_id = false;
        IDatabaseSetting dbSetting = conf.getDatabaseSetting(databaseIdentifier);
        if (dbSetting != null) {
            try {
                quoted_id = (Boolean)dbSetting.getConnectionConfigProperty("C_QUOTED_IDENTIFIER");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (quoted_id) {
            return SQLUtil.quote((String)id, (String)quote);
        }
        return id;
    }

    public static String quoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier, String quote) {
        return SQLDevToolsUtil.quoteWhenNecessary(id, databaseIdentifier, quote, -1);
    }

    public static String unquoteWhenNecessary(String id, DatabaseIdentifier databaseIdentifier) {
        ValidatorMessage msg;
        if (id == null || id.equals("") || databaseIdentifier == null) {
            return id;
        }
        String newId = SQLUtil.unquote((String)id);
        SQLDevToolsConfiguration conf = SQLToolsFacade.getConfigurationByProfileName(databaseIdentifier.getProfileName());
        IIdentifierValidator validator = conf.getSQLService().getIdentifierValidator();
        if (!(validator == null || (msg = validator.isValid(newId, -1, databaseIdentifier)) != null && ValidatorMessage.hasError(msg, 2))) {
            return newId;
        }
        return id;
    }
}

