/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import com.ibm.icu.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class DelimitedStringList
extends Composite {
    private static final String DELIMITER = ",";
    private Button mAddButton;
    private Button mClearAllButton;
    private Button mRemoveButton;
    private Button mDownButton;
    private Button mUpButton;
    private List mPropsList;
    private Text mAddText;
    private Text mHiddenText;
    private String mDelimiter = ",";
    private String mWarning = null;
    private ListenerList changeListeners = new ListenerList();

    public DelimitedStringList(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.mAddText = new Text((Composite)this, 2048);
        this.mAddText.setLayoutData((Object)new GridData(768));
        this.mAddText.addModifyListener((ModifyListener)new AddTextModifyListener(this));
        this.mAddButton = new Button((Composite)this, 0);
        this.mAddButton.setLayoutData((Object)new GridData(256));
        this.mAddButton.setText(DriverMgmtMessages.getString((String)"DelimitedStringList.button.add"));
        this.mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.addStringToList();
                DelimitedStringList.this.fireChangedEvent(e.getSource());
            }
        });
        Composite mSpacerComposite = new Composite((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 10;
        gridData.horizontalSpan = 2;
        mSpacerComposite.setLayoutData((Object)gridData);
        mSpacerComposite.setLayout((Layout)new GridLayout());
        this.mPropsList = new List((Composite)this, 2048);
        GridData gridData2 = new GridData(272);
        gridData2.verticalSpan = 4;
        this.mPropsList.setLayoutData((Object)gridData2);
        this.mPropsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.updatePropertyButtons();
            }
        });
        this.mUpButton = new Button((Composite)this, 0);
        this.mUpButton.setLayoutData((Object)new GridData(256));
        this.mUpButton.setText(DriverMgmtMessages.getString((String)"DelimitedStringList.button.up"));
        this.mUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.moveUpInList();
            }
        });
        this.mDownButton = new Button((Composite)this, 0);
        this.mDownButton.setLayoutData((Object)new GridData(256));
        this.mDownButton.setText(DriverMgmtMessages.getString((String)"DelimitedStringList.button.down"));
        this.mDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.moveDownInList();
            }
        });
        this.mRemoveButton = new Button((Composite)this, 0);
        this.mRemoveButton.setLayoutData((Object)new GridData(256));
        this.mRemoveButton.setText(DriverMgmtMessages.getString((String)"DelimitedStringList.button.remove"));
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.removeFromList();
            }
        });
        this.mClearAllButton = new Button((Composite)this, 0);
        this.mClearAllButton.setLayoutData((Object)new GridData(256));
        this.mClearAllButton.setText(DriverMgmtMessages.getString((String)"DelimitedStringList.button.clear"));
        this.mClearAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelimitedStringList.this.mPropsList.removeAll();
                DelimitedStringList.this.updatePropertyButtons();
            }
        });
        this.mHiddenText = new Text((Composite)this, 2048);
        gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.mHiddenText.setLayoutData((Object)gridData2);
        this.mHiddenText.setVisible(false);
    }

    public void addModifyListener(ModifyListener listener) {
        this.mHiddenText.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.mHiddenText.removeModifyListener(listener);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    private void addStringToList() {
        if (this.mAddText.getText().length() > 0) {
            this.mPropsList.add(this.mAddText.getText().trim());
            String selected = this.getSelection();
            this.mHiddenText.setText(selected.trim());
            this.mAddText.setSelection(0, this.mAddText.getText().length());
            this.mAddText.setFocus();
        }
    }

    private void removeFromList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int index = this.mPropsList.getSelectionIndex();
            this.mPropsList.remove(index);
            String selected = this.getSelection();
            this.mHiddenText.setText(selected.trim());
            try {
                if (this.mPropsList.getItem(index) != null) {
                    this.mPropsList.select(index);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveUpInList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int selection = this.mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection > 0) {
                destination = selection - 1;
                String value_a = this.mPropsList.getItem(destination);
                String value_b = this.mPropsList.getItem(selection);
                String[] items = this.mPropsList.getItems();
                this.mPropsList.removeAll();
                int counter = 0;
                while (counter < items.length) {
                    if (counter == destination) {
                        this.mPropsList.add(value_b);
                        this.mPropsList.add(value_a);
                        counter += 2;
                        continue;
                    }
                    this.mPropsList.add(items[counter]);
                    ++counter;
                }
                String selected = this.getSelection();
                this.mHiddenText.setText(selected.trim());
                this.mPropsList.setSelection(destination);
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    private void moveDownInList() {
        if (this.mPropsList.getSelectionCount() == 1) {
            int selection = this.mPropsList.getSelectionIndex();
            int destination = -1;
            if (selection < this.mPropsList.getItemCount() - 1) {
                destination = selection + 1;
                String value_a = this.mPropsList.getItem(destination);
                String value_b = this.mPropsList.getItem(selection);
                String[] items = this.mPropsList.getItems();
                this.mPropsList.removeAll();
                for (int counter = 0; counter < items.length; ++counter) {
                    if (counter == selection) {
                        this.mPropsList.add(value_a);
                        this.mPropsList.add(value_b);
                        continue;
                    }
                    if (counter == destination) continue;
                    this.mPropsList.add(items[counter]);
                }
                String selected = this.getSelection();
                this.mHiddenText.setText(selected.trim());
                this.mPropsList.setSelection(destination);
            }
        }
        this.mPropsList.setFocus();
        this.updatePropertyButtons();
    }

    public String getSelection() {
        String selectString = "";
        for (int i = 0; i < this.mPropsList.getItems().length; ++i) {
            String testitem = this.mPropsList.getItem(i).trim();
            selectString = selectString + testitem;
            if (i >= this.mPropsList.getItems().length - 1) continue;
            selectString = selectString + this.mDelimiter;
        }
        return selectString;
    }

    private void updatePropertyButtons() {
        this.mDownButton.setEnabled(false);
        this.mUpButton.setEnabled(false);
        this.mRemoveButton.setEnabled(false);
        if (this.mPropsList.getItemCount() > 0 && this.mPropsList.getSelectionCount() == 1) {
            int selection = this.mPropsList.getSelectionIndex();
            this.mRemoveButton.setEnabled(true);
            if (selection - 1 >= 0) {
                this.mUpButton.setEnabled(true);
            }
            if (selection + 1 < this.mPropsList.getItemCount()) {
                this.mDownButton.setEnabled(true);
            }
        }
        String value = "";
        value = this.mAddText.getText();
        boolean flag = value != null && value.trim().length() > 0;
        boolean valid = this.validateText(value);
        this.mAddButton.setEnabled(flag && valid);
    }

    private boolean validateText(String text) {
        if (text != null && text.trim().length() > 0 && text.indexOf(DELIMITER) > -1) {
            this.mWarning = DriverMgmtMessages.getString((String)"DelimitedStringList.ValidationMsg.NoCommas");
            return false;
        }
        this.mWarning = null;
        return true;
    }

    public boolean setFocus() {
        if (this.mAddText != null) {
            return this.mAddText.setFocus();
        }
        return false;
    }

    public void setSelection(String str_list) {
        String[] str_array = this.parseString(str_list);
        this.mPropsList.setItems(str_array);
    }

    private String[] parseString(String str_list) {
        StringTokenizer tk = new StringTokenizer(str_list, this.mDelimiter);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    public void setDelimiter(String delimiter) {
        this.mDelimiter = delimiter;
    }

    public String getDelimiter() {
        return this.mDelimiter;
    }

    public String getWarning() {
        return this.mWarning;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ChangeListener)listeners[i]).stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    private class AddTextModifyListener
    implements ModifyListener {
        private DelimitedStringList parent;

        public AddTextModifyListener(DelimitedStringList parent) {
            this.parent = parent;
        }

        public void modifyText(ModifyEvent e) {
            DelimitedStringList.this.updatePropertyButtons();
            DelimitedStringList.this.fireChangedEvent((Object)this.parent);
        }
    }
}

