/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.DriverDefinitionsDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DriverListCombo {
    private Composite mPanel;
    private Combo mComboList;
    private Button mModify;
    private Label mLabel;
    private String mLabelText;
    private String mCategoryId;
    private String mErrorMessage;
    private String mInitialDriverName;
    private boolean mNullDriverValid = true;
    private String mFilter = null;
    private boolean mShowLabel = true;
    private ListenerList changeListeners = new ListenerList();

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public void setInitialDriverName(String driverName) {
        this.mInitialDriverName = driverName;
    }

    public String getInitialDriverName() {
        return this.mInitialDriverName;
    }

    public void setCategory(String category) {
        this.mCategoryId = category;
    }

    public String getCategory() {
        return this.mCategoryId;
    }

    public void setFilter(String filter) {
        this.mFilter = filter;
    }

    public String getFilter() {
        return this.mFilter;
    }

    public void setShowLabel(boolean flag) {
        this.mShowLabel = flag;
    }

    public boolean getShowLabel() {
        return this.mShowLabel;
    }

    public void setLabelText(String label) {
        this.mLabelText = label;
    }

    public String getLabelText() {
        return this.mLabelText;
    }

    public boolean getNullDriverIsValid() {
        return this.mNullDriverValid;
    }

    public void setNullDriverIsValid(boolean flag) {
        this.mNullDriverValid = flag;
    }

    public void createContents(Composite parent) {
        this.mPanel = new Composite(parent, 0);
        GridData vdata = new GridData(784);
        vdata.horizontalSpan = 2;
        this.mPanel.setLayoutData((Object)vdata);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mPanel.setLayout((Layout)gridLayout);
        if (this.mShowLabel) {
            this.mLabel = new Label(this.mPanel, 0);
            GridData ldata = new GridData(256);
            ldata.horizontalSpan = 2;
            this.mLabel.setLayoutData((Object)ldata);
            this.mLabel.setText(this.mLabelText);
        }
        this.mComboList = new Combo(this.mPanel, 2060);
        GridData cdata = new GridData(768);
        this.mComboList.setLayoutData((Object)cdata);
        ComboSelectionListener listener = new ComboSelectionListener(this);
        this.mComboList.addModifyListener((ModifyListener)listener);
        this.mComboList.addSelectionListener((SelectionListener)listener);
        this.mModify = new Button(this.mPanel, 8);
        this.mModify.setLayoutData((Object)new GridData(128));
        this.mModify.setText(DriverMgmtMessages.getString((String)"DriverListCombo.button.browse"));
        this.mModify.addSelectionListener((SelectionListener)new EditButtonSelectionChangedListener(this));
        this.refreshCombo();
    }

    public Combo getCombo() {
        return this.mComboList;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this.changeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ChangeListener)listeners[i]).stateChanged(e);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove((Object)listener);
    }

    protected String[] parseString(String str_list) {
        return this.parseString(str_list, ",");
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }

    private IPropertySet getSelectedDriver() {
        String keyString;
        int keyIndex = this.mComboList.getSelectionIndex();
        if (keyIndex > -1 && this.mComboList.getData(keyString = this.mComboList.getItem(keyIndex)) != null) {
            IPropertySet ps = (IPropertySet)this.mComboList.getData(keyString);
            return ps;
        }
        return null;
    }

    public DriverInstance getSelectedDriverInstance() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return new DriverInstance(ps);
        }
        return null;
    }

    public String getSelectedDriverName() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return ps.getName();
        }
        return null;
    }

    public String getSelectedDriverID() {
        IPropertySet ps = this.getSelectedDriver();
        if (ps != null) {
            return ps.getID();
        }
        return null;
    }

    public void setSelection(String name) {
        List<String> list = Arrays.asList(this.mComboList.getItems());
        if (list.contains(name)) {
            this.mComboList.select(list.indexOf(name));
            this.mComboList.setText(name);
        }
    }

    public void setSelectionToID(String id) {
        String driverName = null;
        List<String> list = Arrays.asList(this.mComboList.getItems());
        for (int i = 0; i < list.size(); ++i) {
            IPropertySet ps;
            String keyString = this.mComboList.getItem(i);
            if (this.mComboList.getData(keyString) == null || !(ps = (IPropertySet)this.mComboList.getData(keyString)).getID().equals(id)) continue;
            driverName = keyString;
            break;
        }
        if (driverName != null) {
            this.mComboList.select(list.indexOf(driverName));
            this.mComboList.setText(driverName);
        }
    }

    public void selectFirstItem() {
        if (this.mComboList.getItemCount() > 0) {
            this.mComboList.select(0);
        }
    }

    private boolean passesFilter(TemplateDescriptor template, IPropertySet pset) {
        boolean rtn = true;
        if (this.mFilter != null && template != null && pset != null) {
            String[] filters = this.parseString(this.mFilter, ",");
            for (int i = 0; i < filters.length; ++i) {
                String filter = filters[i];
                String[] args = this.parseString(filter, "=");
                String arg = args[0].trim();
                String value = args[1].trim();
                if (arg.equals("id")) {
                    if (pset.getID().indexOf(value) != -1) continue;
                    rtn = false;
                    break;
                }
                if (arg.equals("name")) {
                    if (pset.getName().indexOf(value) != -1) continue;
                    rtn = false;
                    break;
                }
                if (arg.equals("templateID")) {
                    if (template.getId().indexOf(value) != -1) continue;
                    rtn = false;
                    break;
                }
                if (arg.equals("templateIDStartsWith")) {
                    if (template.getId().startsWith(value)) continue;
                    rtn = false;
                    break;
                }
                if (arg.equals("templateIDEndsWith")) {
                    if (template.getId().endsWith(value)) continue;
                    rtn = false;
                    break;
                }
                if (!arg.equals("templateIDContains") || template.getId().indexOf(value) != -1) continue;
                rtn = false;
                break;
            }
        }
        return rtn;
    }

    public void refreshCombo() {
        int i;
        this.getCombo().removeAll();
        IPropertySet[] psets = new IPropertySet[]{};
        DriverInstance[] dilist = DriverManager.getInstance().getAllDriverInstances();
        if (dilist != null && dilist.length > 0) {
            psets = new IPropertySet[dilist.length];
            for (i = 0; i < psets.length; ++i) {
                psets[i] = dilist[i].getPropertySet();
            }
        }
        if (this.mCategoryId != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.mCategoryId);
            ArrayList templates = new ArrayList();
            if (category == null) {
                CategoryDescriptor[] categories = CategoryDescriptor.getRootCategories();
                int count = categories.length;
                for (int index = 0; index < count; ++index) {
                    this.populateAssociatedDriverTypes(categories[index], templates);
                }
            } else {
                this.populateAssociatedDriverTypes(category, templates);
            }
            for (int i2 = 0; i2 < templates.size(); ++i2) {
                TemplateDescriptor template = (TemplateDescriptor)templates.get(i2);
                for (int j = 0; j < psets.length; ++j) {
                    IPropertySet pset = psets[j];
                    String driverType = pset.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                    if (!driverType.equals(template.getId()) || !this.passesFilter(template, pset)) continue;
                    this.getCombo().add(pset.getName());
                    this.getCombo().setData(pset.getName(), (Object)pset);
                }
            }
        } else {
            for (i = 0; i < psets.length; ++i) {
                IPropertySet pset = psets[i];
                this.getCombo().add(pset.getName());
                this.getCombo().setData(pset.getName(), (Object)pset);
            }
        }
        String text = this.getCombo().getText();
        for (int i3 = 0; i3 < this.getCombo().getItemCount(); ++i3) {
            if (!this.getCombo().getItem(i3).equals(text)) continue;
            this.getCombo().select(i3);
            break;
        }
    }

    private void populateAssociatedDriverTypes(CategoryDescriptor category, List templates) {
        templates.addAll(category.getAssociatedDriverTypes());
        Iterator it = category.getChildCategories().iterator();
        while (it.hasNext()) {
            this.populateAssociatedDriverTypes((CategoryDescriptor)it.next(), templates);
        }
    }

    public class EditButtonSelectionChangedListener
    implements SelectionListener {
        private DriverListCombo parent;

        public EditButtonSelectionChangedListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int rtn;
            Shell newShell = new Shell();
            DriverDefinitionsDialog dlg = DriverListCombo.this.mCategoryId != null ? new DriverDefinitionsDialog(newShell, DriverListCombo.this.mCategoryId) : new DriverDefinitionsDialog(newShell);
            if (this.parent.getCombo().getText() != null && this.parent.getCombo().getText().length() > 0) {
                dlg.setInitialDriverName(this.parent.getCombo().getText());
            }
            if ((rtn = dlg.open()) != 0) {
                return;
            }
            String tempStore = DriverListCombo.this.mComboList.getText();
            DriverListCombo.this.refreshCombo();
            boolean fireEvent = false;
            if (dlg.getSelectedDefinition() != null) {
                fireEvent = true;
                String driverName = dlg.getSelectedDefinition().getName();
                String[] itemList = DriverListCombo.this.mComboList.getItems();
                if (itemList.length > 0) {
                    for (int i = 0; i < itemList.length; ++i) {
                        TemplateDescriptor template;
                        String item = itemList[i];
                        IPropertySet temp = (IPropertySet)DriverListCombo.this.mComboList.getData(item);
                        if (!temp.getID().equals(dlg.getSelectedDefinition().getID())) continue;
                        DriverListCombo.this.mComboList.setText(driverName);
                        DriverListCombo.this.mComboList.select(i);
                        String driverType = temp.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType");
                        if (driverType != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                            DriverValidator validator = new DriverValidator(template, temp);
                            DriverListCombo.this.mErrorMessage = null;
                            if (!validator.isValid()) {
                                DriverListCombo.this.mErrorMessage = validator.getMessage();
                            }
                        }
                        break;
                    }
                }
            } else {
                DriverListCombo.this.mComboList.setText(tempStore);
            }
            newShell.dispose();
            if (fireEvent) {
                DriverListCombo.this.fireChangedEvent(this.parent);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class ComboSelectionListener
    implements SelectionListener,
    ModifyListener {
        private DriverListCombo parent;

        public ComboSelectionListener(DriverListCombo combo) {
            this.parent = combo;
        }

        public void widgetSelected(SelectionEvent e) {
            int keyIndex = DriverListCombo.this.mComboList.getSelectionIndex();
            if (keyIndex > -1) {
                TemplateDescriptor template;
                String driverType;
                IPropertySet ps;
                String keyString = DriverListCombo.this.mComboList.getItem(keyIndex);
                if (DriverListCombo.this.mComboList.getData(keyString) != null && (ps = (IPropertySet)DriverListCombo.this.mComboList.getData(keyString)) != null && (driverType = ps.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")) != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                    DriverValidator validator = new DriverValidator(template, ps);
                    DriverListCombo.this.mErrorMessage = null;
                    if (!validator.isValid()) {
                        DriverListCombo.this.mErrorMessage = validator.getMessage();
                    }
                }
            } else if (DriverListCombo.this.mNullDriverValid) {
                DriverListCombo.this.mErrorMessage = null;
            } else {
                DriverListCombo.this.mErrorMessage = DriverMgmtMessages.getString((String)"DriverValidator.msg.no_driver_selected");
            }
            DriverListCombo.this.fireChangedEvent(this.parent);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void modifyText(ModifyEvent e) {
            String keyString = DriverListCombo.this.mComboList.getText();
            if (keyString.length() > 0) {
                TemplateDescriptor template;
                String driverType;
                IPropertySet ps;
                if (DriverListCombo.this.mComboList.getData(keyString) != null && (ps = (IPropertySet)DriverListCombo.this.mComboList.getData(keyString)) != null && (driverType = ps.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.drivers.defnType")) != null && (template = TemplateDescriptor.getDriverTemplateDescriptor((String)driverType)) != null) {
                    DriverValidator validator = new DriverValidator(template, ps);
                    DriverListCombo.this.mErrorMessage = null;
                    if (!validator.isValid()) {
                        DriverListCombo.this.mErrorMessage = validator.getMessage();
                    }
                }
            } else if (DriverListCombo.this.mNullDriverValid) {
                DriverListCombo.this.mErrorMessage = null;
            } else {
                DriverListCombo.this.mErrorMessage = DriverMgmtMessages.getString((String)"DriverValidator.msg.no_driver_selected");
            }
            DriverListCombo.this.fireChangedEvent(this.parent);
        }
    }
}

