/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DriverTreeFilter
extends ViewerFilter {
    private String mCategoryId;
    private CategoryDescriptor mCategoryDescriptor;
    private String mDriverTemplateId;
    private ArrayList okCategoryIds;
    private ArrayList okTemplateIds;

    public void setCategoryId(String categoryId) {
        this.mCategoryId = categoryId;
        this.mCategoryDescriptor = CategoryDescriptor.getCategoryDescriptor((String)categoryId);
        this.refreshOkList();
    }

    public void setDriverTemplateId(String driverTemplateId) {
        this.mDriverTemplateId = driverTemplateId;
    }

    private void refreshOkList() {
        block7: {
            block6: {
                this.okCategoryIds = new ArrayList();
                this.okTemplateIds = new ArrayList();
                if (this.mCategoryId == null) break block6;
                this.okCategoryIds = new ArrayList();
                this.okCategoryIds.add(this.mCategoryId);
                CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.mCategoryId);
                if (category == null) break block7;
                if (category.getParentCategory() != null) {
                    CategoryDescriptor parent = CategoryDescriptor.getCategoryDescriptor((String)category.getParentCategory());
                    this.okCategoryIds.add(parent.getId());
                    while (parent.getParentCategory() != null) {
                        parent = CategoryDescriptor.getCategoryDescriptor((String)parent.getParentCategory());
                        this.okCategoryIds.add(parent.getId());
                    }
                } else {
                    this.addChildren(category);
                }
                break block7;
            }
            if (this.mDriverTemplateId != null) {
                this.okTemplateIds.add(this.mDriverTemplateId);
                TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTemplateId);
                if (template != null && template.getParentCategory() != null) {
                    CategoryDescriptor parent = CategoryDescriptor.getCategoryDescriptor((String)template.getParentCategory());
                    this.okCategoryIds.add(parent.getId());
                    while (parent.getParentCategory() != null) {
                        parent = CategoryDescriptor.getCategoryDescriptor((String)parent.getParentCategory());
                        this.okCategoryIds.add(parent.getId());
                    }
                }
            }
        }
    }

    private void addChildren(CategoryDescriptor parent) {
        Object[] children = parent.getChildCategories().toArray();
        if (children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                CategoryDescriptor child = (CategoryDescriptor)children[i];
                this.okCategoryIds.add(child.getId());
                this.addChildren(child);
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TemplateDescriptor) {
            for (CategoryDescriptor cd = ((TemplateDescriptor)element).getParent(); cd != null; cd = cd.getParent()) {
                if (!cd.getId().equals(this.mCategoryId)) continue;
                return true;
            }
        } else if (element instanceof CategoryDescriptor) {
            CategoryDescriptor cd;
            for (cd = this.mCategoryDescriptor; cd != null; cd = cd.getParent()) {
                if (!cd.getId().equals(((CategoryDescriptor)element).getId())) continue;
                return true;
            }
            for (cd = (CategoryDescriptor)element; cd != null; cd = cd.getParent()) {
                if (!cd.getId().equals(this.mCategoryId)) continue;
                return true;
            }
        } else if (element instanceof IPropertySet) {
            TemplateDescriptor template;
            if (this.mDriverTemplateId != null && this.okTemplateIds.contains((template = (TemplateDescriptor)element).getId())) {
                return true;
            }
            return true;
        }
        return false;
    }
}

