/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileBaseDeleteChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.DeleteArguments;
import org.eclipse.swt.widgets.Shell;

public class ConnectionProfileCopyChange
extends Change {
    private IConnectionProfile mProfileToDuplicate;

    public ConnectionProfileCopyChange(IConnectionProfile profile, CopyArguments args) {
        this.mProfileToDuplicate = profile;
    }

    public String getName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.name"), this.mProfileToDuplicate.getName());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.mProfileToDuplicate == null || ProfileManager.getInstance().getProfileByName(this.mProfileToDuplicate.getName()) == null) {
            result.addFatalError(ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.error.ProfileDoesNotExist"));
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        CompositeChange undo = new CompositeChange(this.getName());
        undo.markAsSynthetic();
        undo.add(this.duplicateProfile(pm));
        return undo;
    }

    public Object getModifiedElement() {
        return this.mProfileToDuplicate;
    }

    private Change duplicateProfile(IProgressMonitor pm) {
        try {
            String newProfile = ProfileManager.getInstance().duplicateProfile(this.mProfileToDuplicate);
            IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(newProfile);
            if (profile.isAutoConnect()) {
                profile.connect();
            }
            return new ConnectionProfileBaseDeleteChange(profile, new DeleteArguments());
        }
        catch (ConnectionProfileException e) {
            Shell shell = new Shell();
            ExceptionHandler.showException(shell, ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.title.error"), e.getMessage(), e);
            return new NullChange();
        }
    }
}

