/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCopyChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyArguments;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class ConnectionProfileCopyProcessor
extends CopyProcessor {
    public static final String PROCESSOR_ID = "org.eclipse.datatools.connectivity.ui.copyProcessor";
    private IConnectionProfile mProfile;
    private CopyArguments mArguments;
    private ReorgExecutionLog mReorgExecutionLog;

    public ConnectionProfileCopyProcessor(IConnectionProfile profile) {
        this.mProfile = profile;
        this.mReorgExecutionLog = new ReorgExecutionLog();
        this.mArguments = new CopyArguments((Object)this.mProfile, this.mReorgExecutionLog);
    }

    public Object[] getElements() {
        return new Object[]{this.mProfile};
    }

    public String getIdentifier() {
        return PROCESSOR_ID;
    }

    public String getProcessorName() {
        return MessageFormat.format(ConnectivityUIPlugin.getDefault().getResourceString("CPCopyChange.name"), this.mProfile.getName());
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(new String());
        change.markAsSynthetic();
        change.add((Change)new ConnectionProfileCopyChange(this.mProfile, this.mArguments));
        return change;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        ArrayList<CopyParticipant> participants = new ArrayList<CopyParticipant>();
        participants.addAll(Arrays.asList(ParticipantManager.loadCopyParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.mProfile, (CopyArguments)this.mArguments, (String[])new String[0], (SharableParticipants)sharedParticipants)));
        return participants.toArray(new RefactoringParticipant[participants.size()]);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }
}

