/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.IHelpConstants;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class CPPropetyPage
extends PropertyPage {
    private Text txtProfileName;
    private Text txtProfileDesc;
    private Button btnAutoConnect;

    public CPPropetyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_name"));
        this.txtProfileName = new Text(content, 2048);
        this.txtProfileName.setLayoutData((Object)new GridData(768));
        this.txtProfileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CPPropetyPage.this.validate();
            }
        });
        label = new Label(content, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_desc"));
        this.txtProfileDesc = new Text(content, 2048);
        this.txtProfileDesc.setLayoutData((Object)new GridData(768));
        this.btnAutoConnect = new Button(content, 32);
        this.btnAutoConnect.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Button.AutoConnect1"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.btnAutoConnect.setLayoutData((Object)gd);
        this.initControls();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpConstants.CONTEXT_ID_CP_PROPERTY_PAGE);
        return content;
    }

    public boolean performOk() {
        IConnectionProfile profile = this.getConnectionProfile();
        try {
            ProfileManager.getInstance().modifyProfile(profile, this.txtProfileName.getText(), this.txtProfileDesc.getText(), new Boolean(this.btnAutoConnect.getSelection()));
        }
        catch (ConnectionProfileException e) {
            ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("dialog.exception.title"), ConnectivityUIPlugin.getDefault().getResourceString("dialog.exception.message", new Object[]{e.getMessage()}), e);
        }
        return true;
    }

    private void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        this.txtProfileName.setText(profile.getName());
        this.txtProfileDesc.setText(profile.getDescription());
        boolean showAutoConnect = profile.getProvider().needsMaintainConnection();
        if (!showAutoConnect) {
            this.btnAutoConnect.setSelection(true);
            this.btnAutoConnect.setEnabled(false);
            this.btnAutoConnect.setVisible(false);
        } else {
            this.btnAutoConnect.setSelection(profile.isAutoConnect());
        }
        this.setErrorMessage(null);
    }

    private IConnectionProfile getConnectionProfile() {
        IAdaptable element = this.getElement();
        IConnectionProfile profile = (IConnectionProfile)element.getAdapter(IConnectionProfile.class);
        return profile;
    }

    private void validate() {
        String errorMessage = null;
        if (this.txtProfileName.getText().length() == 0) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoName");
        } else if (!this.getConnectionProfile().getName().equals(this.txtProfileName.getText()) && ProfileManager.getInstance().getProfileByName(this.txtProfileName.getText()) != null) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.DuplicateName");
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }
}

