/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportProfilesDialog
extends Dialog {
    private Text txtFile;
    private Button btnOverwrite;
    private Throwable mException;
    private IConnectionProfile[] mProfiles;
    private boolean mOverwrite;

    public ImportProfilesDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.numColumns = 3;
        container.setLayout((Layout)gridLayout);
        Text text = new Text(container, 2122);
        text.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.text.text"));
        GridData gridData = new GridData(768);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 3;
        text.setLayoutData((Object)gridData);
        Label label = new Label(container, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 495;
        label.setLayoutData((Object)gridData);
        label = new Label(container, 0);
        gridData = new GridData();
        gridData.horizontalIndent = 5;
        label.setLayoutData((Object)gridData);
        label.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.label.text"));
        this.txtFile = new Text(container, 2048);
        GridData gridData2 = new GridData(768);
        gridData2.widthHint = 243;
        this.txtFile.setLayoutData((Object)gridData2);
        Button button = new Button(container, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProfilesDialog.this.txtFile.setText(new FileDialog(ImportProfilesDialog.this.getShell()).open());
            }
        });
        button.setLayoutData((Object)new GridData(64));
        button.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.button.text"));
        this.btnOverwrite = new Button(container, 32);
        gridData2 = new GridData(512);
        gridData2.horizontalIndent = 10;
        gridData2.horizontalSpan = 3;
        this.btnOverwrite.setLayoutData((Object)gridData2);
        this.btnOverwrite.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.btnOverwrite.text"));
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ConnectivityUIPlugin.getDefault().getResourceString("ImportProfilesDialog.null.title"));
    }

    public Throwable getException() {
        return this.mException;
    }

    public IConnectionProfile[] getProfiles() {
        return this.mProfiles;
    }

    public boolean isOverwritten() {
        return this.mOverwrite;
    }

    protected void okPressed() {
        if (this.txtFile.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.export.nofile"));
            return;
        }
        try {
            byte[] bytes = new byte[5];
            char[] xml = new char[]{'<', '?', 'x', 'm', 'l'};
            FileInputStream fis = new FileInputStream(this.txtFile.getText());
            fis.read(bytes);
            fis.close();
            boolean isXML = true;
            for (int i = 0; isXML && i < 5; ++i) {
                isXML = bytes[i] == xml[i];
            }
            this.mProfiles = isXML ? ConnectionProfileMgmt.loadCPs((File)new File(this.txtFile.getText()), null) : ConnectionProfileMgmt.loadCPs((File)new File(this.txtFile.getText()), (ICipherProvider)SecurityManager.getInstance().getDefaultCipherProvider());
        }
        catch (Exception e) {
            this.mException = e;
        }
        this.mOverwrite = this.btnOverwrite.getSelection();
        super.okPressed();
    }
}

